import { PackageManagerType } from './types';
interface PackageManagerProps {
    readonly runCommand: string;
    readonly buildCommand: string[];
    readonly crossCompile: boolean;
    readonly runLocally: boolean;
    readonly type: PackageManagerType;
}
/**
 * A Rust package manager
 */
export declare class PackageManager {
    /**
     * Create a package manager from a package manager type. Method will also check if it can be runned locally
     * @param type Package manager used
     * @returns the right PackageManager for that type
     */
    static fromType(type: PackageManagerType): PackageManager;
    readonly runCommand: string;
    readonly buildCommand: string[];
    readonly runLocally: boolean;
    readonly crossCompile: boolean;
    readonly type: PackageManagerType;
    constructor(props: PackageManagerProps);
    runBuildCommand(): string;
}
export {};
