"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PackageManager = void 0;
const os = require("os");
const types_1 = require("./types");
const util_1 = require("./util");
/**
 * A Rust package manager
 */
class PackageManager {
    /**
     * Create a package manager from a package manager type. Method will also check if it can be runned locally
     * @param type Package manager used
     * @returns the right PackageManager for that type
     */
    static fromType(type) {
        let runCommand = 'cargo-zigbuild';
        let buildCommand = ['zigbuild'];
        let crossCompile = true;
        if (type === types_1.PackageManagerType.CROSS) {
            runCommand = 'cross';
            buildCommand = ['build'];
        }
        return new PackageManager({
            runCommand: runCommand,
            buildCommand: buildCommand,
            runLocally: (0, util_1.canRunLocally)(runCommand),
            crossCompile: crossCompile,
            type,
        });
    }
    constructor(props) {
        this.runCommand = props.runCommand;
        this.buildCommand = props.buildCommand;
        this.crossCompile = props.crossCompile;
        this.runLocally = props.runLocally;
        this.type = props.type;
    }
    runBuildCommand() {
        return [
            os.platform() === 'win32' ? `${this.runCommand}.cmd` : this.runCommand,
            ...this.buildCommand,
        ].join(' ');
    }
}
exports.PackageManager = PackageManager;
//# sourceMappingURL=data:application/json;base64,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