/// <reference types="node" />
import { Architecture, AssetCode, Runtime } from 'aws-cdk-lib/aws-lambda';
import { BundlingFileAccess, BundlingOptions as CdkBundlingOptions, DockerImage, DockerVolume, ILocalBundling } from 'aws-cdk-lib/core';
import { BundlingOptions } from './types';
/**
 * Bundling properties
 */
export interface BundlingProps extends BundlingOptions {
    /**
     * Path to folder containing the Cargo.toml file.
     */
    readonly entry: string;
    /**
     * The runtime of the lambda function
     */
    readonly runtime: Runtime;
    /**
     * The system architecture of the lambda function
     *
     * @default - Architecture.X86_64
     */
    readonly architecture: Architecture;
    /**
     * Build only the specified binary
     *
     * @default Build all binaries
     */
    readonly binaryName?: string;
    /**
     * Which option to use to copy the source files to the docker container and output files back
     * @default - BundlingFileAccess.BIND_MOUNT
     */
    readonly bundlingFileAccess?: BundlingFileAccess;
}
/**
 * Bundling with esbuild
 */
export declare class Bundling implements CdkBundlingOptions {
    private readonly props;
    static X86_64__TARGET: string;
    static ARM_TARGET: string;
    /**
     * Cargo bundled Lambda asset code
     */
    static bundle(options: BundlingProps): AssetCode;
    readonly image: DockerImage;
    readonly entrypoint?: string[];
    readonly command: string[];
    readonly volumes?: DockerVolume[];
    readonly volumesFrom?: string[];
    readonly environment?: {
        [key: string]: string;
    };
    readonly workingDirectory?: string;
    readonly user?: string;
    readonly securityOpt?: string;
    readonly network?: string;
    readonly local?: ILocalBundling;
    readonly bundlingFileAccess?: BundlingFileAccess;
    private readonly packageManager;
    private readonly target;
    constructor(props: BundlingProps);
    createBundlingCommand(options: BundlingCommandOptions): string;
    private getLocalBundlingProvider;
}
/**
 * Command options for bundling a Lambda asset
 */
interface BundlingCommandOptions {
    readonly inputDir: string;
    readonly outputDir: string;
    readonly buildRunner: string;
    readonly buildArgs: string[];
    readonly osPlatform: NodeJS.Platform;
}
export {};
