import { FunctionOptions, Runtime, Function } from 'aws-cdk-lib/aws-lambda';
import { Construct } from 'constructs';
import { BundlingOptions } from './types';
/**
 * Properties for a RustFunction
 */
export interface RustFunctionProps extends FunctionOptions {
    /**
     * Path to the entry Cargo.toml file.
     *
     * @default - Derived from the name of the defining file and the construct's id.
     * If the `RustsFunction` is defined in `stack.ts` with `my-binary` as id
     * (`new RustFunction(this, 'my-binary')`), the construct will look at `stack.my-binary/Cargo.toml`
     */
    readonly entry?: string;
    /**
     * The name of the binary to build, in case that it's different that the package's name.
     *
     * @default Build all binaries
     */
    readonly binaryName?: string;
    /**
     * The runtime environment. Only OS-only runtimes are supported.
     *
     * @default `Runtime.PROVIDED_AL2023`
     */
    readonly runtime?: Runtime;
    /**
     * Bundling options
     *
     * @default - use default bundling options: all
     * binaries and packages are bundled.
     */
    readonly bundling?: BundlingOptions;
    /**
     * The path to the directory containing project Manifest file
     *
     * @default - the directory containing the `depsLockFilePath`
     */
    readonly projectRoot?: string;
}
/**
 * A Rust Lambda function
 */
export declare class RustFunction extends Function {
    constructor(scope: Construct, id: string, props?: RustFunctionProps);
}
