import { SpawnSyncOptions } from 'child_process';
export interface CallSite {
    getThis(): any;
    getTypeName(): string;
    getFunctionName(): string;
    getMethodName(): string;
    getFileName(): string;
    getLineNumber(): number;
    getColumnNumber(): number;
    getFunction(): Function;
    getEvalOrigin(): string;
    isNative(): boolean;
    isToplevel(): boolean;
    isEval(): boolean;
    isConstructor(): boolean;
}
export interface Package {
    name: string;
}
/**
 * Base layout of a Rust manifest file
 */
export interface TomlProps {
    readonly package?: Package;
    readonly workspace?: {
        members: string[];
    };
    readonly bin?: Package[];
}
/**
 * Get Manifest binary name
 * @param entry the Manifest file path
 */
export declare function getBinaryName(entry: string): string | undefined;
export declare function hasMultipleBinaries(entry: string): boolean | undefined;
/**
 * Check if the given Manifest contains multiple workspaces
 * @param entry the Manifest file path
 */
export declare function isWorkspace(entry: string): boolean | undefined;
/**
 * Spawn sync with error handling
 */
export declare function exec(cmd: string, args: string[], options?: SpawnSyncOptions): import("child_process").SpawnSyncReturns<string | Buffer<ArrayBufferLike>>;
/**
 * Check if an architecture target is installed.
 * @param target The target to test
 */
export declare function checkInstalledTarget(target: string): boolean;
/**
 * Check if a command can be run locally.
 * @param cmd The command to execute
 */
export declare function canRunLocally(cmd: string): boolean;
/**
 * Get callsites from the V8 stack trace API
 *
 * https://github.com/sindresorhus/callsites
 */
export declare function callsites(): CallSite[];
