import { checkExceptions, createWaiter, WaiterState } from "@smithy/util-waiter";
import { GetDeploymentCommand } from "../commands/GetDeploymentCommand";
const checkState = async (client, input) => {
    let reason;
    try {
        const result = await client.send(new GetDeploymentCommand(input));
        reason = result;
        try {
            const returnComparator = () => {
                return result.deploymentInfo.status;
            };
            if (returnComparator() === "Succeeded") {
                return { state: WaiterState.SUCCESS, reason };
            }
        }
        catch (e) { }
        try {
            const returnComparator = () => {
                return result.deploymentInfo.status;
            };
            if (returnComparator() === "Failed") {
                return { state: WaiterState.FAILURE, reason };
            }
        }
        catch (e) { }
        try {
            const returnComparator = () => {
                return result.deploymentInfo.status;
            };
            if (returnComparator() === "Stopped") {
                return { state: WaiterState.FAILURE, reason };
            }
        }
        catch (e) { }
    }
    catch (exception) {
        reason = exception;
    }
    return { state: WaiterState.RETRY, reason };
};
export const waitForDeploymentSuccessful = async (params, input) => {
    const serviceDefaults = { minDelay: 15, maxDelay: 120 };
    return createWaiter({ ...serviceDefaults, ...params }, input, checkState);
};
export const waitUntilDeploymentSuccessful = async (params, input) => {
    const serviceDefaults = { minDelay: 15, maxDelay: 120 };
    const result = await createWaiter({ ...serviceDefaults, ...params }, input, checkState);
    return checkExceptions(result);
};
