import { AwsSdkSigV4AuthInputConfig, AwsSdkSigV4AuthResolvedConfig, AwsSdkSigV4PreviouslyResolved } from "@aws-sdk/core";
import { HandlerExecutionContext, HttpAuthScheme, HttpAuthSchemeParameters, HttpAuthSchemeParametersProvider, HttpAuthSchemeProvider } from "@smithy/types";
import { CodeDeployClientResolvedConfig } from "../CodeDeployClient";
/**
 * @internal
 */
export interface CodeDeployHttpAuthSchemeParameters extends HttpAuthSchemeParameters {
    region?: string;
}
/**
 * @internal
 */
export interface CodeDeployHttpAuthSchemeParametersProvider extends HttpAuthSchemeParametersProvider<CodeDeployClientResolvedConfig, HandlerExecutionContext, CodeDeployHttpAuthSchemeParameters, object> {
}
/**
 * @internal
 */
export declare const defaultCodeDeployHttpAuthSchemeParametersProvider: (config: CodeDeployClientResolvedConfig, context: HandlerExecutionContext, input: object) => Promise<CodeDeployHttpAuthSchemeParameters>;
/**
 * @internal
 */
export interface CodeDeployHttpAuthSchemeProvider extends HttpAuthSchemeProvider<CodeDeployHttpAuthSchemeParameters> {
}
/**
 * @internal
 */
export declare const defaultCodeDeployHttpAuthSchemeProvider: CodeDeployHttpAuthSchemeProvider;
/**
 * @internal
 */
export interface HttpAuthSchemeInputConfig extends AwsSdkSigV4AuthInputConfig {
    /**
     * Configuration of HttpAuthSchemes for a client which provides default identity providers and signers per auth scheme.
     * @internal
     */
    httpAuthSchemes?: HttpAuthScheme[];
    /**
     * Configuration of an HttpAuthSchemeProvider for a client which resolves which HttpAuthScheme to use.
     * @internal
     */
    httpAuthSchemeProvider?: CodeDeployHttpAuthSchemeProvider;
}
/**
 * @internal
 */
export interface HttpAuthSchemeResolvedConfig extends AwsSdkSigV4AuthResolvedConfig {
    /**
     * Configuration of HttpAuthSchemes for a client which provides default identity providers and signers per auth scheme.
     * @internal
     */
    readonly httpAuthSchemes: HttpAuthScheme[];
    /**
     * Configuration of an HttpAuthSchemeProvider for a client which resolves which HttpAuthScheme to use.
     * @internal
     */
    readonly httpAuthSchemeProvider: CodeDeployHttpAuthSchemeProvider;
}
/**
 * @internal
 */
export declare const resolveHttpAuthSchemeConfig: <T>(config: T & HttpAuthSchemeInputConfig & AwsSdkSigV4PreviouslyResolved) => T & HttpAuthSchemeResolvedConfig;
