# cdo-sdk-python
Use the interactive documentation to explore the endpoints CDO has to offer

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 0.0.1
- Package version: 1.0.10
- Generator version: 7.4.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 3.7+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import cdo_sdk_python
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import cdo_sdk_python
```

### Tests

Execute `pytest` to run the tests.

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import cdo_sdk_python
from cdo_sdk_python.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://edge.us.cdo.cisco.com/api/rest
# See configuration.py for a list of all supported configuration parameters.
configuration = cdo_sdk_python.Configuration(
    host = "https://edge.us.cdo.cisco.com/api/rest"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure Bearer authorization (JWT): bearerAuth
configuration = cdo_sdk_python.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)


# Enter a context with an instance of the API client
with cdo_sdk_python.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = cdo_sdk_python.ChangeRequestsApi(api_client)
    change_request_create_input = cdo_sdk_python.ChangeRequestCreateInput() # ChangeRequestCreateInput | 

    try:
        # Create Change Requests.
        api_response = api_instance.create_change_request(change_request_create_input)
        print("The response of ChangeRequestsApi->create_change_request:\n")
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling ChangeRequestsApi->create_change_request: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *https://edge.us.cdo.cisco.com/api/rest*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*ChangeRequestsApi* | [**create_change_request**](docs/ChangeRequestsApi.md#create_change_request) | **POST** /v1/changeRequests | Create Change Requests.
*ChangeRequestsApi* | [**delete_change_request**](docs/ChangeRequestsApi.md#delete_change_request) | **DELETE** /v1/changeRequests/{changeRequestUid} | Delete a Change Request by UID in the CDO tenant
*ChangeRequestsApi* | [**get_change_request**](docs/ChangeRequestsApi.md#get_change_request) | **GET** /v1/changeRequests/{changeRequestUid} | Fetch a Change Request by UID in the CDO tenant.
*ChangeRequestsApi* | [**list_change_requests**](docs/ChangeRequestsApi.md#list_change_requests) | **GET** /v1/changeRequests | Fetch a list of Change Requests.
*ChangelogsApi* | [**get_changelog**](docs/ChangelogsApi.md#get_changelog) | **GET** /v1/changelogs/{changelogUid} | Fetch a Change Log by UID in the CDO tenant.
*ChangelogsApi* | [**list_changelogs**](docs/ChangelogsApi.md#list_changelogs) | **GET** /v1/changelogs | Fetch a list of Change Logs.
*ConnectorsApi* | [**fetch_sdc**](docs/ConnectorsApi.md#fetch_sdc) | **GET** /v1/connectors/sdcs/{sdcUid} | Fetch a SDC by UID in the CDO tenant
*ConnectorsApi* | [**list_sdcs**](docs/ConnectorsApi.md#list_sdcs) | **GET** /v1/connectors/sdcs | Fetch a list of SDCs in the CDO tenant
*InventoryApi* | [**create_duo_admin_panel**](docs/InventoryApi.md#create_duo_admin_panel) | **POST** /v1/inventory/devices/duoAdminPanels | Onboard a Duo Admin Panel in the CDO tenant
*InventoryApi* | [**create_ftd_device**](docs/InventoryApi.md#create_ftd_device) | **POST** /v1/inventory/devices/ftds | Create an FTD device in the CDO tenant
*InventoryApi* | [**delete_cd_fmc_managed_ftd_device**](docs/InventoryApi.md#delete_cd_fmc_managed_ftd_device) | **POST** /v1/inventory/devices/ftds/cdfmcManaged/{deviceUid}/delete | Delete cdFMC managed FTD device in the CDO tenant
*InventoryApi* | [**delete_cloud_service**](docs/InventoryApi.md#delete_cloud_service) | **DELETE** /v1/inventory/services/{cloudServiceUid} | Delete a Cloud Service by UID in the CDO tenant
*InventoryApi* | [**delete_device**](docs/InventoryApi.md#delete_device) | **DELETE** /v1/inventory/devices/{deviceUid} | Delete a device by UID in the CDO tenant
*InventoryApi* | [**delete_device_manager**](docs/InventoryApi.md#delete_device_manager) | **DELETE** /v1/inventory/managers/{deviceManagerUid} | Delete a Device Manager by UID in the CDO tenant
*InventoryApi* | [**delete_template_device**](docs/InventoryApi.md#delete_template_device) | **DELETE** /v1/inventory/templates/{templateDeviceUid} | Delete a template device by UID in the CDO tenant
*InventoryApi* | [**deploy_asa_device_changes**](docs/InventoryApi.md#deploy_asa_device_changes) | **POST** /v1/inventory/devices/asas/{deviceUid}/deploy | Deploy changes to an ASA device in the CDO tenant
*InventoryApi* | [**finish_onboarding_ftd_device**](docs/InventoryApi.md#finish_onboarding_ftd_device) | **POST** /v1/inventory/devices/ftds/register | Register an FTD device managed by an FMC to the CDO tenant. Call this API endpoint after you have created an FTD, and pasted the generated CLI output in the FTD
*InventoryApi* | [**get_cloud_service**](docs/InventoryApi.md#get_cloud_service) | **GET** /v1/inventory/services/{cloudServiceUid} | Fetch a Cloud Service by UID in the CDO tenant
*InventoryApi* | [**get_device**](docs/InventoryApi.md#get_device) | **GET** /v1/inventory/devices/{deviceUid} | Fetch a device by UID in the CDO tenant
*InventoryApi* | [**get_device_manager**](docs/InventoryApi.md#get_device_manager) | **GET** /v1/inventory/managers/{deviceManagerUid} | Fetch a Device Manager by UID in the CDO tenant
*InventoryApi* | [**get_template_device**](docs/InventoryApi.md#get_template_device) | **GET** /v1/inventory/templates/{templateDeviceUid} | Fetch a template device by UID in the CDO tenant
*InventoryApi* | [**list_device_cloud_services**](docs/InventoryApi.md#list_device_cloud_services) | **GET** /v1/inventory/services | Fetch a list of Cloud Services in the CDO tenant
*InventoryApi* | [**list_device_managers**](docs/InventoryApi.md#list_device_managers) | **GET** /v1/inventory/managers | Fetch a list of Device Managers (on-prem FMCs and cloud-delivered FMCs) in the CDO tenant
*InventoryApi* | [**list_devices**](docs/InventoryApi.md#list_devices) | **GET** /v1/inventory/devices | Fetch a list of devices in the CDO tenant
*InventoryApi* | [**list_template_devices**](docs/InventoryApi.md#list_template_devices) | **GET** /v1/inventory/templates | Fetch a list of template devices in the CDO tenant
*InventoryApi* | [**onboard_asa_device**](docs/InventoryApi.md#onboard_asa_device) | **POST** /v1/inventory/devices/asas | Onboard a ASA device in the CDO tenant
*InventoryApi* | [**onboard_ios_device**](docs/InventoryApi.md#onboard_ios_device) | **POST** /v1/inventory/devices/ios | Onboard a IOS device in the CDO tenant
*InventoryApi* | [**patch_cloud_service**](docs/InventoryApi.md#patch_cloud_service) | **PATCH** /v1/inventory/services/{cloudServiceUid} | Modify a Cloud Service by UID in the CDO tenant
*InventoryApi* | [**patch_device**](docs/InventoryApi.md#patch_device) | **PATCH** /v1/inventory/devices/{deviceUid} | Modify a device in the CDO tenant
*InventoryApi* | [**patch_device_manager**](docs/InventoryApi.md#patch_device_manager) | **PATCH** /v1/inventory/managers/{deviceManagerUid} | Modify a device manager by UID in the CDO tenant
*InventoryApi* | [**patch_template_device**](docs/InventoryApi.md#patch_template_device) | **PATCH** /v1/inventory/templates/{templateDeviceUid} | Modify a template device in the CDO tenant
*InventoryApi* | [**read_from_asa_device**](docs/InventoryApi.md#read_from_asa_device) | **POST** /v1/inventory/devices/asas/{deviceUid}/read | Read configuration on ASA device into CDO
*InventoryApi* | [**reconnect_asa_device**](docs/InventoryApi.md#reconnect_asa_device) | **POST** /v1/inventory/devices/asas/{deviceUid}/reconnect | Reconnect an ASA device in the CDO tenant
*MetaApi* | [**get_jwks**](docs/MetaApi.md#get_jwks) | **GET** /.well-known/jwks.json | Fetch The JSON Web Key Set
*MetaApi* | [**get_meta**](docs/MetaApi.md#get_meta) | **GET** /v1/meta | Get Meta information about CDO, including the IP addresses of CDO services
*MetaApi* | [**list_regions**](docs/MetaApi.md#list_regions) | **GET** /v1/regions | Fetch a list of CDO regions.
*ObjectManagementApi* | [**create_object**](docs/ObjectManagementApi.md#create_object) | **POST** /v0/objects | Creates an object in the CDO tenant
*ObjectManagementApi* | [**create_targets**](docs/ObjectManagementApi.md#create_targets) | **POST** /v0/objects/{uid}/targets | Create targets for an object in the CDO tenant
*ObjectManagementApi* | [**delete_object**](docs/ObjectManagementApi.md#delete_object) | **DELETE** /v0/objects/{uid} | Deletes an object in the CDO tenant
*ObjectManagementApi* | [**get_object**](docs/ObjectManagementApi.md#get_object) | **GET** /v0/objects/{uid} | Retrieves an object in the CDO tenant
*ObjectManagementApi* | [**get_object_usage**](docs/ObjectManagementApi.md#get_object_usage) | **GET** /v0/objects/{uid}/usage | Retrieves usages of an object in the CDO tenant
*ObjectManagementApi* | [**list_objects**](docs/ObjectManagementApi.md#list_objects) | **GET** /v0/objects | Retrieves objects in the CDO tenant
*ObjectManagementApi* | [**remove_targets**](docs/ObjectManagementApi.md#remove_targets) | **DELETE** /v0/objects/{uid}/targets | Removes targets from an object in the CDO tenant
*ObjectManagementApi* | [**update_object**](docs/ObjectManagementApi.md#update_object) | **PATCH** /v0/objects/{uid} | Updates an object in the CDO tenant
*RemoteAccessMonitoringApi* | [**get_ra_vpn_session**](docs/RemoteAccessMonitoringApi.md#get_ra_vpn_session) | **GET** /v1/vpnsessions/{raVpnSessionUid} | Fetch a RA VPN session by UID in the CDO tenant.
*RemoteAccessMonitoringApi* | [**list_ra_vpn_sessions**](docs/RemoteAccessMonitoringApi.md#list_ra_vpn_sessions) | **GET** /v1/vpnsessions | Fetch a list of RA VPN sessions.
*RemoteAccessMonitoringApi* | [**terminate_ra_vpn_sessions_by_device**](docs/RemoteAccessMonitoringApi.md#terminate_ra_vpn_sessions_by_device) | **POST** /v1/vpnsessions/{deviceUid}/terminate | Terminate all RA VPN sessions on a device in the CDO tenant.
*RemoteAccessMonitoringApi* | [**terminate_ra_vpn_sessions_by_device_and_user_name**](docs/RemoteAccessMonitoringApi.md#terminate_ra_vpn_sessions_by_device_and_user_name) | **POST** /v1/vpnsessions/{deviceUid}/terminate/{userName} | Terminate all of a user&#39;s RA VPN sessions on a device in the CDO tenant
*SearchApi* | [**initiate_full_indexing**](docs/SearchApi.md#initiate_full_indexing) | **POST** /v1/search/index | Initiate Full Indexing
*SearchApi* | [**search**](docs/SearchApi.md#search) | **GET** /v1/search | Search for devices, services, managers, objects and policies across the CDO tenant
*TenantManagementApi* | [**add_msp_tenant**](docs/TenantManagementApi.md#add_msp_tenant) | **POST** /v1/msp/tenants | Add a tenant to the MSP Portal
*TenantManagementApi* | [**get_tenant**](docs/TenantManagementApi.md#get_tenant) | **GET** /v1/tenants/{tenantUid} | Fetch a tenant by UID in CDO
*TenantManagementApi* | [**get_tenant_settings**](docs/TenantManagementApi.md#get_tenant_settings) | **GET** /v1/settings/tenant | Fetch the tenant settings in CDO
*TenantManagementApi* | [**list_feature_flags**](docs/TenantManagementApi.md#list_feature_flags) | **GET** /v1/features | Fetch the feature flags enabled for this tenant
*TenantManagementApi* | [**list_tenants**](docs/TenantManagementApi.md#list_tenants) | **GET** /v1/tenants | Fetch a list of tenants associated with the CDO user.
*TenantManagementApi* | [**update_tenant_settings**](docs/TenantManagementApi.md#update_tenant_settings) | **PATCH** /v1/settings/tenant | Update the tenant settings in CDO
*TransactionsApi* | [**get_transaction**](docs/TransactionsApi.md#get_transaction) | **GET** /v1/transactions/{transactionUid} | Get information of an in-progress CDO transaction
*UsersApi* | [**create_user**](docs/UsersApi.md#create_user) | **POST** /v1/users | Create a user in the CDO tenant
*UsersApi* | [**delete_user**](docs/UsersApi.md#delete_user) | **DELETE** /v1/users/{userUid} | Delete a User by UID in the CDO tenant
*UsersApi* | [**generate_api_token**](docs/UsersApi.md#generate_api_token) | **POST** /v1/users/{apiUserId}/apiToken/generate | Generate API Token for API-only user
*UsersApi* | [**get_token**](docs/UsersApi.md#get_token) | **GET** /v1/token | Fetch information on the current token
*UsersApi* | [**get_user**](docs/UsersApi.md#get_user) | **GET** /v1/users/{userUid} | Fetch a user by UID in the CDO tenant.
*UsersApi* | [**list_users**](docs/UsersApi.md#list_users) | **GET** /v1/users | Fetch a list of users associated with the CDO tenant.
*UsersApi* | [**revoke_api_token**](docs/UsersApi.md#revoke_api_token) | **POST** /v1/users/{apiUserId}/apiToken/revoke | Revoke API Token of API-only user
*UsersApi* | [**revoke_token**](docs/UsersApi.md#revoke_token) | **POST** /v1/token/revoke | Revoke the current token


## Documentation For Models

 - [ApiTokenInfo](docs/ApiTokenInfo.md)
 - [AsaCreateOrUpdateInput](docs/AsaCreateOrUpdateInput.md)
 - [AsaFailoverMate](docs/AsaFailoverMate.md)
 - [AsaFailoverMode](docs/AsaFailoverMode.md)
 - [AuthenticationError](docs/AuthenticationError.md)
 - [CdFmcInfo](docs/CdFmcInfo.md)
 - [CdFmcObject](docs/CdFmcObject.md)
 - [CdFmcResult](docs/CdFmcResult.md)
 - [CdoRegion](docs/CdoRegion.md)
 - [CdoRegionList](docs/CdoRegionList.md)
 - [CdoTokenInfo](docs/CdoTokenInfo.md)
 - [CdoTransaction](docs/CdoTransaction.md)
 - [CdoTransactionStatus](docs/CdoTransactionStatus.md)
 - [CdoTransactionType](docs/CdoTransactionType.md)
 - [ChangeRequest](docs/ChangeRequest.md)
 - [ChangeRequestCreateInput](docs/ChangeRequestCreateInput.md)
 - [ChangeRequestPage](docs/ChangeRequestPage.md)
 - [Changelog](docs/Changelog.md)
 - [ChangelogPage](docs/ChangelogPage.md)
 - [CommonApiError](docs/CommonApiError.md)
 - [ConfigState](docs/ConfigState.md)
 - [ConflictDetectionInterval](docs/ConflictDetectionInterval.md)
 - [ConflictDetectionState](docs/ConflictDetectionState.md)
 - [ConnectivityState](docs/ConnectivityState.md)
 - [ConnectorType](docs/ConnectorType.md)
 - [CreateRequest](docs/CreateRequest.md)
 - [Device](docs/Device.md)
 - [DevicePage](docs/DevicePage.md)
 - [DevicePatchInput](docs/DevicePatchInput.md)
 - [DeviceRole](docs/DeviceRole.md)
 - [DuoAdminPanelCreateOrUpdateInput](docs/DuoAdminPanelCreateOrUpdateInput.md)
 - [Entity](docs/Entity.md)
 - [EntityType](docs/EntityType.md)
 - [Event](docs/Event.md)
 - [FtdCreateOrUpdateInput](docs/FtdCreateOrUpdateInput.md)
 - [FtdRegistrationInput](docs/FtdRegistrationInput.md)
 - [GlobalSearchResult](docs/GlobalSearchResult.md)
 - [GroupContent](docs/GroupContent.md)
 - [Icmp4Value](docs/Icmp4Value.md)
 - [Icmp6Value](docs/Icmp6Value.md)
 - [Inventory](docs/Inventory.md)
 - [IosCreateOrUpdateInput](docs/IosCreateOrUpdateInput.md)
 - [IssuesDto](docs/IssuesDto.md)
 - [JsonWebKey](docs/JsonWebKey.md)
 - [JwkSet](docs/JwkSet.md)
 - [Labels](docs/Labels.md)
 - [ListObjectResponse](docs/ListObjectResponse.md)
 - [Location](docs/Location.md)
 - [MerakiDeploymentMode](docs/MerakiDeploymentMode.md)
 - [Meta](docs/Meta.md)
 - [MspAddTenantInput](docs/MspAddTenantInput.md)
 - [Network](docs/Network.md)
 - [NetworkObjectContent](docs/NetworkObjectContent.md)
 - [OS](docs/OS.md)
 - [ObjectContent](docs/ObjectContent.md)
 - [ObjectResponse](docs/ObjectResponse.md)
 - [OnPremFmcInfo](docs/OnPremFmcInfo.md)
 - [Override](docs/Override.md)
 - [Policy](docs/Policy.md)
 - [PortsValue](docs/PortsValue.md)
 - [RaVpnSession](docs/RaVpnSession.md)
 - [RaVpnSessionPage](docs/RaVpnSessionPage.md)
 - [ReferenceInfo](docs/ReferenceInfo.md)
 - [Sdc](docs/Sdc.md)
 - [SdcPage](docs/SdcPage.md)
 - [SdcPublicKey](docs/SdcPublicKey.md)
 - [SdcStatus](docs/SdcStatus.md)
 - [ServiceObjectContent](docs/ServiceObjectContent.md)
 - [ServiceObjectValueContent](docs/ServiceObjectValueContent.md)
 - [SharedObjectValue](docs/SharedObjectValue.md)
 - [SingleContent](docs/SingleContent.md)
 - [StateMachineDetails](docs/StateMachineDetails.md)
 - [StateMachineError](docs/StateMachineError.md)
 - [StatusInfo](docs/StatusInfo.md)
 - [Target](docs/Target.md)
 - [TargetsRequest](docs/TargetsRequest.md)
 - [Tenant](docs/Tenant.md)
 - [TenantPage](docs/TenantPage.md)
 - [TenantPayType](docs/TenantPayType.md)
 - [TenantSettings](docs/TenantSettings.md)
 - [UnifiedObjectListView](docs/UnifiedObjectListView.md)
 - [UpdateRequest](docs/UpdateRequest.md)
 - [UrlObjectContent](docs/UrlObjectContent.md)
 - [User](docs/User.md)
 - [UserCreateOrUpdateInput](docs/UserCreateOrUpdateInput.md)
 - [UserPage](docs/UserPage.md)
 - [UserRole](docs/UserRole.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization


Authentication schemes defined for the API:
<a id="bearerAuth"></a>
### bearerAuth

- **Type**: Bearer authentication (JWT)


## Author

cdo.tac@cisco.com


