# coding: utf-8

"""
    CDO API

    Use the documentation to explore the endpoints CDO has to offer

    The version of the OpenAPI document: 1.0.0
    Contact: cdo.tac@cisco.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import json
import pprint
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Any, List, Optional
from cdo_sdk_python.models.icmp4_value import Icmp4Value
from cdo_sdk_python.models.icmp6_value import Icmp6Value
from cdo_sdk_python.models.ports_value import PortsValue
from cdo_sdk_python.models.protocol_value_content import ProtocolValueContent
from cdo_sdk_python.models.source_destination_ports_value import SourceDestinationPortsValue
from pydantic import StrictStr, Field
from typing import Union, List, Optional, Dict
from typing_extensions import Literal, Self

SERVICEOBJECTVALUECONTENT_ONE_OF_SCHEMAS = ["Icmp4Value", "Icmp6Value", "PortsValue", "ProtocolValueContent", "SourceDestinationPortsValue"]

class ServiceObjectValueContent(BaseModel):
    """
    The value of the service object
    """
    # data type: Icmp4Value
    oneof_schema_1_validator: Optional[Icmp4Value] = None
    # data type: Icmp6Value
    oneof_schema_2_validator: Optional[Icmp6Value] = None
    # data type: SourceDestinationPortsValue
    oneof_schema_3_validator: Optional[SourceDestinationPortsValue] = None
    # data type: PortsValue
    oneof_schema_4_validator: Optional[PortsValue] = None
    # data type: ProtocolValueContent
    oneof_schema_5_validator: Optional[ProtocolValueContent] = None
    actual_instance: Optional[Union[Icmp4Value, Icmp6Value, PortsValue, ProtocolValueContent, SourceDestinationPortsValue]] = None
    one_of_schemas: List[str] = Field(default=Literal["Icmp4Value", "Icmp6Value", "PortsValue", "ProtocolValueContent", "SourceDestinationPortsValue"])

    model_config = ConfigDict(
        validate_assignment=True,
        protected_namespaces=(),
    )


    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_oneof(cls, v):
        instance = ServiceObjectValueContent.model_construct()
        error_messages = []
        match = 0
        # validate data type: Icmp4Value
        if not isinstance(v, Icmp4Value):
            error_messages.append(f"Error! Input type `{type(v)}` is not `Icmp4Value`")
        else:
            match += 1
        # validate data type: Icmp6Value
        if not isinstance(v, Icmp6Value):
            error_messages.append(f"Error! Input type `{type(v)}` is not `Icmp6Value`")
        else:
            match += 1
        # validate data type: SourceDestinationPortsValue
        if not isinstance(v, SourceDestinationPortsValue):
            error_messages.append(f"Error! Input type `{type(v)}` is not `SourceDestinationPortsValue`")
        else:
            match += 1
        # validate data type: PortsValue
        if not isinstance(v, PortsValue):
            error_messages.append(f"Error! Input type `{type(v)}` is not `PortsValue`")
        else:
            match += 1
        # validate data type: ProtocolValueContent
        if not isinstance(v, ProtocolValueContent):
            error_messages.append(f"Error! Input type `{type(v)}` is not `ProtocolValueContent`")
        else:
            match += 1
        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when setting `actual_instance` in ServiceObjectValueContent with oneOf schemas: Icmp4Value, Icmp6Value, PortsValue, ProtocolValueContent, SourceDestinationPortsValue. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when setting `actual_instance` in ServiceObjectValueContent with oneOf schemas: Icmp4Value, Icmp6Value, PortsValue, ProtocolValueContent, SourceDestinationPortsValue. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Union[str, Dict[str, Any]]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        match = 0

        # deserialize data into Icmp4Value
        try:
            instance.actual_instance = Icmp4Value.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into Icmp6Value
        try:
            instance.actual_instance = Icmp6Value.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into SourceDestinationPortsValue
        try:
            instance.actual_instance = SourceDestinationPortsValue.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into PortsValue
        try:
            instance.actual_instance = PortsValue.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into ProtocolValueContent
        try:
            instance.actual_instance = ProtocolValueContent.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))

        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when deserializing the JSON string into ServiceObjectValueContent with oneOf schemas: Icmp4Value, Icmp6Value, PortsValue, ProtocolValueContent, SourceDestinationPortsValue. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when deserializing the JSON string into ServiceObjectValueContent with oneOf schemas: Icmp4Value, Icmp6Value, PortsValue, ProtocolValueContent, SourceDestinationPortsValue. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], Icmp4Value, Icmp6Value, PortsValue, ProtocolValueContent, SourceDestinationPortsValue]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            # primitive type
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


