# coding: utf-8

"""
    Cisco Defense Orchestrator API

    # Cisco Defense Orchestrator (CDO) Python SDK The CDO Python SDK facilitates automated interaction with the Cisco Defense Orchestrator (CDO) API, enabling developers to integrate Cisco's cloud-based security policy and device management into Python applications.  For more information and detailed documentation, visit the [CDO Python SDK documentation](https://github.com/cisco-lockhart/cdo-public-api-docs/tree/main/cdo-sdk/python).  Read more about CDO [here](https://docs.defenseorchestrator.com/).  ## Installation Install the CDO Python SDK package with the following command: ``` pip install cdo-sdk-python ```  ## Getting Started After installation, import the SDK into your Python project and configure your API credentials.  ## Usage Example ```python import cdo_sdk_python, os from cdo_sdk_python.rest import ApiException from pprint import pprint  # See configuration.py for a list of all supported configuration parameters configuration = cdo_sdk_python.Configuration(     host=\"https://edge.staging.cdo.cisco.com/api/rest\" )  # Configure Bearer authorization (JWT) configuration.access_token = os.environ[\"BEARER_TOKEN\"]  with cdo_sdk_python.ApiClient(configuration) as api_client:     # Create an instance of the API class     api_instance = cdo_sdk_python.TenantManagementApi(api_client)      try:         api_response = api_instance.list_tenants()         print(\"The response of TenantManagementApi->list_tenants: \")         pprint(api_response)     except ApiException as e:         print(\"Exception when calling TenantManagementApi->list_tenants: %s \" % e) ```  ## Developer Support If you need technical support, choose from the options below.  ### Consulting/Best Practices Use the DevNet Community for general best practices, help, tips, or examples using Cisco APIs. Free to any DevNet member, log in and post your questions in the [Network Security forum](https://community.cisco.com/t5/network-security/bd-p/disc-network-security) using the `Cisco Defense Orchestrator (CDO)` label.  ### Issues If you identify issues with the CDO Public API, you can contact the [Cisco Technical Assistance Center (TAC)](https://www.cisco.com/c/en/us/support/web/tsd-cisco-worldwide-contacts.html) for support. First time? [Start here](https://www.cisco.com/c/dam/en/us/services/collateral/acquisitions/cjp-tac-support-guide.pdf).  - Internet: https://mycase.cloudapps.cisco.com/ - Worldwide Support Contacts: https://www.cisco.com/c/en/us/support/web/tsd-cisco-worldwide-contacts.html - Webex: tac.connect@webex.bot  ### Enhancement Requests Please file enhancement requests in the [Network Security forum](https://community.cisco.com/t5/network-security/bd-p/disc-network-security) using the `Cisco Defense Orchestrator (CDO)` label.  ### One-on-one Consulting For one-on-one consulting, contact a [Cisco Developer Partner](https://www.cisco.com/c/en/us/partners/connect-with-a-partner.html) or your Cisco Sales Team for professional service options. 

    The version of the OpenAPI document: 0.0.1
    Contact: cdo.tac@cisco.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from setuptools import setup, find_packages  # noqa: H301

# To install the library, run the following
#
# python setup.py install
#
# prerequisite: setuptools
# http://pypi.python.org/pypi/setuptools
NAME = "cdo-sdk-python"
VERSION = "1.0.31"
PYTHON_REQUIRES = ">=3.7"
REQUIRES = [
    "urllib3 >= 1.25.3, < 2.1.0",
    "python-dateutil",
    "pydantic >= 2",
    "typing-extensions >= 4.7.1",
]

setup(
    name=NAME,
    version=VERSION,
    description="Cisco Defense Orchestrator API",
    author="CDO TAC",
    author_email="cdo.tac@cisco.com",
    url="",
    keywords=["OpenAPI", "OpenAPI-Generator", "Cisco Defense Orchestrator API"],
    install_requires=REQUIRES,
    packages=find_packages(exclude=["test", "tests"]),
    include_package_data=True,
    long_description_content_type='text/markdown',
    long_description="""\
    # Cisco Defense Orchestrator (CDO) Python SDK The CDO Python SDK facilitates automated interaction with the Cisco Defense Orchestrator (CDO) API, enabling developers to integrate Cisco&#39;s cloud-based security policy and device management into Python applications.  For more information and detailed documentation, visit the [CDO Python SDK documentation](https://github.com/cisco-lockhart/cdo-public-api-docs/tree/main/cdo-sdk/python).  Read more about CDO [here](https://docs.defenseorchestrator.com/).  ## Installation Install the CDO Python SDK package with the following command: &#x60;&#x60;&#x60; pip install cdo-sdk-python &#x60;&#x60;&#x60;  ## Getting Started After installation, import the SDK into your Python project and configure your API credentials.  ## Usage Example &#x60;&#x60;&#x60;python import cdo_sdk_python, os from cdo_sdk_python.rest import ApiException from pprint import pprint  # See configuration.py for a list of all supported configuration parameters configuration &#x3D; cdo_sdk_python.Configuration(     host&#x3D;\&quot;https://edge.staging.cdo.cisco.com/api/rest\&quot; )  # Configure Bearer authorization (JWT) configuration.access_token &#x3D; os.environ[\&quot;BEARER_TOKEN\&quot;]  with cdo_sdk_python.ApiClient(configuration) as api_client:     # Create an instance of the API class     api_instance &#x3D; cdo_sdk_python.TenantManagementApi(api_client)      try:         api_response &#x3D; api_instance.list_tenants()         print(\&quot;The response of TenantManagementApi-&gt;list_tenants: \&quot;)         pprint(api_response)     except ApiException as e:         print(\&quot;Exception when calling TenantManagementApi-&gt;list_tenants: %s \&quot; % e) &#x60;&#x60;&#x60;  ## Developer Support If you need technical support, choose from the options below.  ### Consulting/Best Practices Use the DevNet Community for general best practices, help, tips, or examples using Cisco APIs. Free to any DevNet member, log in and post your questions in the [Network Security forum](https://community.cisco.com/t5/network-security/bd-p/disc-network-security) using the &#x60;Cisco Defense Orchestrator (CDO)&#x60; label.  ### Issues If you identify issues with the CDO Public API, you can contact the [Cisco Technical Assistance Center (TAC)](https://www.cisco.com/c/en/us/support/web/tsd-cisco-worldwide-contacts.html) for support. First time? [Start here](https://www.cisco.com/c/dam/en/us/services/collateral/acquisitions/cjp-tac-support-guide.pdf).  - Internet: https://mycase.cloudapps.cisco.com/ - Worldwide Support Contacts: https://www.cisco.com/c/en/us/support/web/tsd-cisco-worldwide-contacts.html - Webex: tac.connect@webex.bot  ### Enhancement Requests Please file enhancement requests in the [Network Security forum](https://community.cisco.com/t5/network-security/bd-p/disc-network-security) using the &#x60;Cisco Defense Orchestrator (CDO)&#x60; label.  ### One-on-one Consulting For one-on-one consulting, contact a [Cisco Developer Partner](https://www.cisco.com/c/en/us/partners/connect-with-a-partner.html) or your Cisco Sales Team for professional service options. 
    """,  # noqa: E501
    package_data={"cdo_sdk_python": ["py.typed"]},
)
