# coding: utf-8

"""
    Cisco Defense Orchestrator API

    # Cisco Defense Orchestrator (CDO) Python SDK The CDO Python SDK facilitates automated interaction with the Cisco Defense Orchestrator (CDO) API, enabling developers to integrate Cisco's cloud-based security policy and device management into Python applications.  For more information and detailed documentation, visit the [CDO Python SDK documentation](https://github.com/cisco-lockhart/cdo-public-api-docs/tree/main/cdo-sdk/python).  Read more about CDO [here](https://docs.defenseorchestrator.com/).  ## Installation Install the CDO Python SDK package with the following command: ``` pip install cdo-sdk-python ```  ## Getting Started After installation, import the SDK into your Python project and configure your API credentials.  ## Usage Example ```python import cdo_sdk_python, os from cdo_sdk_python.rest import ApiException from pprint import pprint  # See configuration.py for a list of all supported configuration parameters configuration = cdo_sdk_python.Configuration(     host=\"https://edge.staging.cdo.cisco.com/api/rest\" )  # Configure Bearer authorization (JWT) configuration.access_token = os.environ[\"BEARER_TOKEN\"]  with cdo_sdk_python.ApiClient(configuration) as api_client:     # Create an instance of the API class     api_instance = cdo_sdk_python.TenantManagementApi(api_client)      try:         api_response = api_instance.list_tenants()         print(\"The response of TenantManagementApi->list_tenants: \")         pprint(api_response)     except ApiException as e:         print(\"Exception when calling TenantManagementApi->list_tenants: %s \" % e) ```  ## Developer Support If you need technical support, choose from the options below.  ### Consulting/Best Practices Use the DevNet Community for general best practices, help, tips, or examples using Cisco APIs. Free to any DevNet member, log in and post your questions in the [Network Security forum](https://community.cisco.com/t5/network-security/bd-p/disc-network-security) using the `Cisco Defense Orchestrator (CDO)` label.  ### Issues If you identify issues with the CDO Public API, you can contact the [Cisco Technical Assistance Center (TAC)](https://www.cisco.com/c/en/us/support/web/tsd-cisco-worldwide-contacts.html) for support. First time? [Start here](https://www.cisco.com/c/dam/en/us/services/collateral/acquisitions/cjp-tac-support-guide.pdf).  - Internet: https://mycase.cloudapps.cisco.com/ - Worldwide Support Contacts: https://www.cisco.com/c/en/us/support/web/tsd-cisco-worldwide-contacts.html - Webex: tac.connect@webex.bot  ### Enhancement Requests Please file enhancement requests in the [Network Security forum](https://community.cisco.com/t5/network-security/bd-p/disc-network-security) using the `Cisco Defense Orchestrator (CDO)` label.  ### One-on-one Consulting For one-on-one consulting, contact a [Cisco Developer Partner](https://www.cisco.com/c/en/us/partners/connect-with-a-partner.html) or your Cisco Sales Team for professional service options. 

    The version of the OpenAPI document: 0.0.1
    Contact: cdo.tac@cisco.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from cdo_sdk_python.models.unified_object_list_view import UnifiedObjectListView
from typing import Optional, Set
from typing_extensions import Self

class ListObjectResponse(BaseModel):
    """
    ListObjectResponse
    """ # noqa: E501
    count: Optional[StrictInt] = Field(default=None, description="The total number of results available.")
    limit: Optional[Annotated[int, Field(le=200, strict=True)]] = Field(default=None, description="The number of results retrieved.")
    offset: Optional[StrictInt] = Field(default=None, description="The offset of the results retrieved. The CDO Public API uses the offset field to determine the index of the first result retrieved, and will retrieve `limit` results from the offset specified.")
    items: Optional[List[UnifiedObjectListView]] = Field(default=None, description="The list of objects retrieved.")
    __properties: ClassVar[List[str]] = ["count", "limit", "offset", "items"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ListObjectResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in items (list)
        _items = []
        if self.items:
            for _item in self.items:
                if _item:
                    _items.append(_item.to_dict())
            _dict['items'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ListObjectResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "count": obj.get("count"),
            "limit": obj.get("limit"),
            "offset": obj.get("offset"),
            "items": [UnifiedObjectListView.from_dict(_item) for _item in obj["items"]] if obj.get("items") is not None else None
        })
        return _obj


