# coding: utf-8

"""
    Cisco Defense Orchestrator API

    # Cisco Defense Orchestrator (CDO) Python SDK  The CDO Python SDK facilitates automated interaction with the Cisco Defense Orchestrator (CDO) API, enabling developers to integrate Cisco's cloud-based security policy and device management into Python applications.  For more information and detailed documentation, visit the [CDO Python SDK documentation](https://github.com/cisco-lockhart/cdo-public-api-docs/tree/main/cdo-sdk/python).  Read more about CDO [here](https://docs.defenseorchestrator.com/).  ## Installation  Install the CDO Python SDK package with the following command:  ``` pip install cdo-sdk-python ```  ... (more content following the same pattern) ... 

    The version of the OpenAPI document: 0.0.1
    Contact: cdo.tac@cisco.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import json
import pprint
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Any, List, Optional
from cdo_sdk_python.models.group_content import GroupContent
from cdo_sdk_python.models.network_object_content import NetworkObjectContent
from cdo_sdk_python.models.service_object_content import ServiceObjectContent
from cdo_sdk_python.models.url_object_content import UrlObjectContent
from pydantic import StrictStr, Field
from typing import Union, List, Optional, Dict
from typing_extensions import Literal, Self

OBJECTCONTENT_ONE_OF_SCHEMAS = ["GroupContent", "NetworkObjectContent", "ServiceObjectContent", "UrlObjectContent"]

class ObjectContent(BaseModel):
    """
    The content value of the override. This overrides the object's default content.
    """
    # data type: ServiceObjectContent
    oneof_schema_1_validator: Optional[ServiceObjectContent] = None
    # data type: UrlObjectContent
    oneof_schema_2_validator: Optional[UrlObjectContent] = None
    # data type: GroupContent
    oneof_schema_3_validator: Optional[GroupContent] = None
    # data type: NetworkObjectContent
    oneof_schema_4_validator: Optional[NetworkObjectContent] = None
    actual_instance: Optional[Union[GroupContent, NetworkObjectContent, ServiceObjectContent, UrlObjectContent]] = None
    one_of_schemas: List[str] = Field(default=Literal["GroupContent", "NetworkObjectContent", "ServiceObjectContent", "UrlObjectContent"])

    model_config = ConfigDict(
        validate_assignment=True,
        protected_namespaces=(),
    )


    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_oneof(cls, v):
        instance = ObjectContent.model_construct()
        error_messages = []
        match = 0
        # validate data type: ServiceObjectContent
        if not isinstance(v, ServiceObjectContent):
            error_messages.append(f"Error! Input type `{type(v)}` is not `ServiceObjectContent`")
        else:
            match += 1
        # validate data type: UrlObjectContent
        if not isinstance(v, UrlObjectContent):
            error_messages.append(f"Error! Input type `{type(v)}` is not `UrlObjectContent`")
        else:
            match += 1
        # validate data type: GroupContent
        if not isinstance(v, GroupContent):
            error_messages.append(f"Error! Input type `{type(v)}` is not `GroupContent`")
        else:
            match += 1
        # validate data type: NetworkObjectContent
        if not isinstance(v, NetworkObjectContent):
            error_messages.append(f"Error! Input type `{type(v)}` is not `NetworkObjectContent`")
        else:
            match += 1
        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when setting `actual_instance` in ObjectContent with oneOf schemas: GroupContent, NetworkObjectContent, ServiceObjectContent, UrlObjectContent. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when setting `actual_instance` in ObjectContent with oneOf schemas: GroupContent, NetworkObjectContent, ServiceObjectContent, UrlObjectContent. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Union[str, Dict[str, Any]]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        match = 0

        # deserialize data into ServiceObjectContent
        try:
            instance.actual_instance = ServiceObjectContent.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into UrlObjectContent
        try:
            instance.actual_instance = UrlObjectContent.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into GroupContent
        try:
            instance.actual_instance = GroupContent.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into NetworkObjectContent
        try:
            instance.actual_instance = NetworkObjectContent.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))

        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when deserializing the JSON string into ObjectContent with oneOf schemas: GroupContent, NetworkObjectContent, ServiceObjectContent, UrlObjectContent. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when deserializing the JSON string into ObjectContent with oneOf schemas: GroupContent, NetworkObjectContent, ServiceObjectContent, UrlObjectContent. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], GroupContent, NetworkObjectContent, ServiceObjectContent, UrlObjectContent]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            # primitive type
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


