# coding: utf-8

"""
    Cisco Defense Orchestrator API

    # Cisco Defense Orchestrator (CDO) Python SDK  The CDO Python SDK facilitates automated interaction with the Cisco Defense Orchestrator (CDO) API, enabling developers to integrate Cisco's cloud-based security policy and device management into Python applications.  For more information and detailed documentation, visit the [CDO Python SDK documentation](https://github.com/cisco-lockhart/cdo-public-api-docs/tree/main/cdo-sdk/python).  Read more about CDO [here](https://docs.defenseorchestrator.com/).  ## Installation  Install the CDO Python SDK package with the following command:  ``` pip install cdo-sdk-python ```  ... (more content following the same pattern) ... 

    The version of the OpenAPI document: 0.0.1
    Contact: cdo.tac@cisco.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from cdo_sdk_python.models.location import Location
from cdo_sdk_python.models.os import OS
from typing import Optional, Set
from typing_extensions import Self

class RaVpnSession(BaseModel):
    """
    RaVpnSession
    """ # noqa: E501
    uid: StrictStr = Field(description="The unique identifier of the VPN session.")
    username: StrictStr = Field(description="The name of the user associated with the RA VPN session.")
    status: Optional[StrictStr] = Field(default=None, description="The status of the RA VPN session.")
    device_uid: StrictStr = Field(description="The unique identifier of the device associated with the RA VPN session.", alias="deviceUid")
    assigned_ip_v4: Optional[StrictStr] = Field(default=None, description="The IPv4 address assigned to the RA VPN session.", alias="assignedIpV4")
    assigned_ip_v6: Optional[StrictStr] = Field(default=None, description="The IPv6 address assigned to the RA VPN session.", alias="assignedIpV6")
    public_ip: Optional[StrictStr] = Field(default=None, description="The public IP address of the client that has established this RA VPN session.", alias="publicIp")
    audit_session_id: Optional[StrictStr] = Field(default=None, description="The audit session ID associated with this RA VPN session.", alias="auditSessionId")
    location: Optional[Location] = None
    os: Optional[OS] = None
    bytes_tx: Optional[StrictInt] = Field(default=None, description="The number of bytes transmitted during the RA VPN session.", alias="bytesTx")
    bytes_rx: Optional[StrictInt] = Field(default=None, description="The number of bytes received during the RA VPN session.", alias="bytesRx")
    login_time: Optional[datetime] = Field(default=None, description="The time (in UTC) at which the user logged in to the RA VPN session, represented using the RFC-3339 standard.", alias="loginTime")
    last_active_time: Optional[datetime] = Field(default=None, description="The time (in UTC) at which the user was last active in the RA VPN session, represented using the RFC-3339 standard.", alias="lastActiveTime")
    __properties: ClassVar[List[str]] = ["uid", "username", "status", "deviceUid", "assignedIpV4", "assignedIpV6", "publicIp", "auditSessionId", "location", "os", "bytesTx", "bytesRx", "loginTime", "lastActiveTime"]

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['ACTIVE', 'TERMINATED']):
            raise ValueError("must be one of enum values ('ACTIVE', 'TERMINATED')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RaVpnSession from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of location
        if self.location:
            _dict['location'] = self.location.to_dict()
        # override the default output from pydantic by calling `to_dict()` of os
        if self.os:
            _dict['os'] = self.os.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RaVpnSession from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "uid": obj.get("uid"),
            "username": obj.get("username"),
            "status": obj.get("status"),
            "deviceUid": obj.get("deviceUid"),
            "assignedIpV4": obj.get("assignedIpV4"),
            "assignedIpV6": obj.get("assignedIpV6"),
            "publicIp": obj.get("publicIp"),
            "auditSessionId": obj.get("auditSessionId"),
            "location": Location.from_dict(obj["location"]) if obj.get("location") is not None else None,
            "os": OS.from_dict(obj["os"]) if obj.get("os") is not None else None,
            "bytesTx": obj.get("bytesTx"),
            "bytesRx": obj.get("bytesRx"),
            "loginTime": obj.get("loginTime"),
            "lastActiveTime": obj.get("lastActiveTime")
        })
        return _obj


