# coding: utf-8

"""
    Cisco Defense Orchestrator API

    Use the interactive documentation to explore the endpoints CDO has to offer

    The version of the OpenAPI document: 0.0.1
    Contact: cdo.tac@cisco.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class Event(BaseModel):
    """
    The events recorded in this Change Log.
    """ # noqa: E501
    description: Optional[StrictStr] = Field(default=None, description="A human-readable description of the Change Log event.")
    diff: Optional[StrictStr] = Field(default=None, description="A textual Diff representation of the changes made to the configuration.")
    username: Optional[StrictStr] = Field(default=None, description="The username of the user that triggered the Change Log event.")
    var_date: Optional[datetime] = Field(default=None, description="The time (UTC; represented using the RFC-3339 standard) at which the Change Log Event occurred.", alias="date")
    action: Optional[StrictStr] = Field(default=None, description="The action performed.")
    change_request_uid: Optional[StrictStr] = Field(default=None, description="The unique Identifier of the Change Request associated with the Change Log event.", alias="changeRequestUid")
    change_request_name: Optional[StrictStr] = Field(default=None, description="The name of the Change Request associated with the Change Log event.", alias="changeRequestName")
    __properties: ClassVar[List[str]] = ["description", "diff", "username", "date", "action", "changeRequestUid", "changeRequestName"]

    @field_validator('action')
    def action_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['CREATE', 'UPDATE', 'DELETE', 'ERROR', 'UNKNOWN']):
            raise ValueError("must be one of enum values ('CREATE', 'UPDATE', 'DELETE', 'ERROR', 'UNKNOWN')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Event from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Event from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "description": obj.get("description"),
            "diff": obj.get("diff"),
            "username": obj.get("username"),
            "date": obj.get("date"),
            "action": obj.get("action"),
            "changeRequestUid": obj.get("changeRequestUid"),
            "changeRequestName": obj.get("changeRequestName")
        })
        return _obj


