# coding: utf-8

"""
    CDO API

    Use the documentation to explore the endpoints CDO has to offer

    The version of the OpenAPI document: 0.1.0
    Contact: cdo.tac@cisco.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from cdo_sdk_python.models.service_object_value_content import ServiceObjectValueContent
from typing import Optional, Set
from typing_extensions import Self

class ServiceObjectContent(BaseModel):
    """
    ServiceObjectContent
    """ # noqa: E501
    protocol: Optional[StrictStr] = Field(default=None, description="The service object protocol")
    service_value: Optional[ServiceObjectValueContent] = Field(default=None, alias="serviceValue")
    __properties: ClassVar[List[str]] = ["protocol", "serviceValue"]

    @field_validator('protocol')
    def protocol_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['TCP', 'UDP', 'ICMP4', 'ICMP6', 'TCP_UDP', 'IGMP', 'GGP', 'ST2', 'CBT', 'EGP', 'IGP', 'BBNRCCMON', 'NVP2', 'PUP', 'ARGUS', 'EMCON', 'XNET', 'CHAOS', 'MUX', 'DCNMEAS', 'HMP', 'PRM', 'XNSIDP', 'TRUNK1', 'TRUNK2', 'LEAF1', 'LEAF2', 'RDP', 'IRTP', 'ISOTP4', 'NETBLT', 'MFENSP', 'MERITINP', 'SEP', 'THREEPC', 'IDPR', 'XTP', 'DDP', 'IDPRCMTP', 'TPPLUSPLUS', 'IL', 'SDRP', 'IDRP', 'RSVP', 'GRE', 'MHRP', 'BNA', 'ESP', 'AH', 'INLSP', 'SWIPE', 'NARP', 'MOBILE', 'TLSP', 'SKIP', 'IPv6NONXT', 'CFTP', 'SATEXPAK', 'KRYPTOLAN', 'RVD', 'IPPC', 'SATMON', 'VISA', 'IPCV', 'CPNX', 'CPHB', 'WSN', 'PVP', 'BRSATMON', 'SUNND', 'WBMON', 'WBEXPAK', 'ISOIP', 'VMTP', 'SECUREVMTP', 'VINES', 'TTP', 'NSFNETIGP', 'DGP', 'TCF', 'EIGRP', 'OSPFIGP', 'SPRITERPC', 'LARP', 'MTP', 'AX25', 'IPIP', 'MICP', 'SCCSP', 'ETHERIP', 'ENCAP', 'GMTP', 'IFMP', 'PNNI', 'PIM', 'ARIS', 'SCPS', 'QNX', 'AN', 'IPCOMP', 'SNP', 'COMPAQPEER', 'IPXINIP', 'VRRP', 'PGM', 'L2TP', 'DDX', 'IATP', 'ST', 'SRP', 'UTI', 'SMP', 'SM', 'PTP', 'ISIS', 'FIRE', 'CRTP', 'CRUDP', 'SSCOPMCE', 'IPLT', 'SPS', 'PIPE', 'SCTP', 'FC', 'DIVERT']):
            raise ValueError("must be one of enum values ('TCP', 'UDP', 'ICMP4', 'ICMP6', 'TCP_UDP', 'IGMP', 'GGP', 'ST2', 'CBT', 'EGP', 'IGP', 'BBNRCCMON', 'NVP2', 'PUP', 'ARGUS', 'EMCON', 'XNET', 'CHAOS', 'MUX', 'DCNMEAS', 'HMP', 'PRM', 'XNSIDP', 'TRUNK1', 'TRUNK2', 'LEAF1', 'LEAF2', 'RDP', 'IRTP', 'ISOTP4', 'NETBLT', 'MFENSP', 'MERITINP', 'SEP', 'THREEPC', 'IDPR', 'XTP', 'DDP', 'IDPRCMTP', 'TPPLUSPLUS', 'IL', 'SDRP', 'IDRP', 'RSVP', 'GRE', 'MHRP', 'BNA', 'ESP', 'AH', 'INLSP', 'SWIPE', 'NARP', 'MOBILE', 'TLSP', 'SKIP', 'IPv6NONXT', 'CFTP', 'SATEXPAK', 'KRYPTOLAN', 'RVD', 'IPPC', 'SATMON', 'VISA', 'IPCV', 'CPNX', 'CPHB', 'WSN', 'PVP', 'BRSATMON', 'SUNND', 'WBMON', 'WBEXPAK', 'ISOIP', 'VMTP', 'SECUREVMTP', 'VINES', 'TTP', 'NSFNETIGP', 'DGP', 'TCF', 'EIGRP', 'OSPFIGP', 'SPRITERPC', 'LARP', 'MTP', 'AX25', 'IPIP', 'MICP', 'SCCSP', 'ETHERIP', 'ENCAP', 'GMTP', 'IFMP', 'PNNI', 'PIM', 'ARIS', 'SCPS', 'QNX', 'AN', 'IPCOMP', 'SNP', 'COMPAQPEER', 'IPXINIP', 'VRRP', 'PGM', 'L2TP', 'DDX', 'IATP', 'ST', 'SRP', 'UTI', 'SMP', 'SM', 'PTP', 'ISIS', 'FIRE', 'CRTP', 'CRUDP', 'SSCOPMCE', 'IPLT', 'SPS', 'PIPE', 'SCTP', 'FC', 'DIVERT')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ServiceObjectContent from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of service_value
        if self.service_value:
            _dict['serviceValue'] = self.service_value.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ServiceObjectContent from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "protocol": obj.get("protocol"),
            "serviceValue": ServiceObjectValueContent.from_dict(obj["serviceValue"]) if obj.get("serviceValue") is not None else None
        })
        return _obj


