# cdo-sdk-python
Use the documentation to explore the endpoints CDO has to offer

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 0.1.0
- Package version: 1.0.99
- Generator version: 7.4.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 3.7+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import cdo_sdk_python
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import cdo_sdk_python
```

### Tests

Execute `pytest` to run the tests.

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import cdo_sdk_python
from cdo_sdk_python.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://edge.us.cdo.cisco.com/api/rest
# See configuration.py for a list of all supported configuration parameters.
configuration = cdo_sdk_python.Configuration(
    host = "https://edge.us.cdo.cisco.com/api/rest"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure Bearer authorization (JWT): bearerAuth
configuration = cdo_sdk_python.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)


# Enter a context with an instance of the API client
with cdo_sdk_python.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = cdo_sdk_python.ChangeRequestsApi(api_client)
    change_request_create_input = cdo_sdk_python.ChangeRequestCreateInput() # ChangeRequestCreateInput | 

    try:
        # Create Change Request
        api_response = api_instance.create_change_request(change_request_create_input)
        print("The response of ChangeRequestsApi->create_change_request:\n")
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling ChangeRequestsApi->create_change_request: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *https://edge.us.cdo.cisco.com/api/rest*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*ChangeRequestsApi* | [**create_change_request**](docs/ChangeRequestsApi.md#create_change_request) | **POST** /v1/changeRequests | Create Change Request
*ChangeRequestsApi* | [**delete_change_request**](docs/ChangeRequestsApi.md#delete_change_request) | **DELETE** /v1/changeRequests/{changeRequestUid} | Delete Change Request
*ChangeRequestsApi* | [**get_change_request**](docs/ChangeRequestsApi.md#get_change_request) | **GET** /v1/changeRequests/{changeRequestUid} | Get Change Request
*ChangeRequestsApi* | [**get_change_requests**](docs/ChangeRequestsApi.md#get_change_requests) | **GET** /v1/changeRequests | Get Change Requests
*ChangelogsApi* | [**get_changelog**](docs/ChangelogsApi.md#get_changelog) | **GET** /v1/changelogs/{changelogUid} | Get Change Log
*ChangelogsApi* | [**get_changelogs**](docs/ChangelogsApi.md#get_changelogs) | **GET** /v1/changelogs | Get Change Logs
*CloudDeliveredFMCApi* | [**proxy_fmc_request**](docs/CloudDeliveredFMCApi.md#proxy_fmc_request) | **GET** /v1/cdfmc/** | Proxy Request To Cloud-Delivered FMC
*CloudDeliveredFMCApi* | [**proxy_fmc_request1**](docs/CloudDeliveredFMCApi.md#proxy_fmc_request1) | **POST** /v1/cdfmc/** | Proxy Request To Cloud-Delivered FMC
*CloudDeliveredFMCApi* | [**proxy_fmc_request2**](docs/CloudDeliveredFMCApi.md#proxy_fmc_request2) | **PUT** /v1/cdfmc/** | Proxy Request To Cloud-Delivered FMC
*CloudDeliveredFMCApi* | [**proxy_fmc_request3**](docs/CloudDeliveredFMCApi.md#proxy_fmc_request3) | **PATCH** /v1/cdfmc/** | Proxy Request To Cloud-Delivered FMC
*CloudDeliveredFMCApi* | [**proxy_fmc_request4**](docs/CloudDeliveredFMCApi.md#proxy_fmc_request4) | **DELETE** /v1/cdfmc/** | Proxy Request To Cloud-Delivered FMC
*CommandLineInterfaceApi* | [**create_cli_macro**](docs/CommandLineInterfaceApi.md#create_cli_macro) | **POST** /cli/macros | Create CLI Macro
*CommandLineInterfaceApi* | [**get_cli_macro**](docs/CommandLineInterfaceApi.md#get_cli_macro) | **GET** /cli/macros/{macroUid} | Get CLI Macro
*CommandLineInterfaceApi* | [**get_cli_macros**](docs/CommandLineInterfaceApi.md#get_cli_macros) | **GET** /cli/macros | Get CLI Macros
*CommandLineInterfaceApi* | [**get_cli_result**](docs/CommandLineInterfaceApi.md#get_cli_result) | **GET** /cli/results/{cliResultUid} | Get CLI Result
*CommandLineInterfaceApi* | [**get_cli_results**](docs/CommandLineInterfaceApi.md#get_cli_results) | **GET** /cli/results | Get CLI Results
*ConnectorsApi* | [**create_sdc**](docs/ConnectorsApi.md#create_sdc) | **POST** /v1/connectors/sdcs | Create SDC
*ConnectorsApi* | [**delete_sdc**](docs/ConnectorsApi.md#delete_sdc) | **DELETE** /v1/connectors/sdcs/{sdcUid} | Delete SDC
*ConnectorsApi* | [**get_sdc**](docs/ConnectorsApi.md#get_sdc) | **GET** /v1/connectors/sdcs/{sdcUid} | Get SDC
*ConnectorsApi* | [**get_sdcs**](docs/ConnectorsApi.md#get_sdcs) | **GET** /v1/connectors/sdcs | Get SDCs
*ConnectorsApi* | [**modify_sdc**](docs/ConnectorsApi.md#modify_sdc) | **PATCH** /v1/connectors/sdcs/{sdcUid} | Modify SDC
*InventoryApi* | [**create_duo_admin_panel**](docs/InventoryApi.md#create_duo_admin_panel) | **POST** /v1/inventory/devices/duoAdminPanels | Onboard Duo Admin Panel
*InventoryApi* | [**create_ftd_device**](docs/InventoryApi.md#create_ftd_device) | **POST** /v1/inventory/devices/ftds | Create FTD device.
*InventoryApi* | [**delete_cd_fmc_managed_ftd_device**](docs/InventoryApi.md#delete_cd_fmc_managed_ftd_device) | **POST** /v1/inventory/devices/ftds/cdfmcManaged/{deviceUid}/delete | Delete cdFMC managed FTD device
*InventoryApi* | [**delete_cloud_service**](docs/InventoryApi.md#delete_cloud_service) | **DELETE** /v1/inventory/services/{cloudServiceUid} | Delete Cloud Service
*InventoryApi* | [**delete_device**](docs/InventoryApi.md#delete_device) | **DELETE** /v1/inventory/devices/{deviceUid} | Delete Device
*InventoryApi* | [**delete_device_manager**](docs/InventoryApi.md#delete_device_manager) | **DELETE** /v1/inventory/managers/{deviceManagerUid} | Delete Device Manager
*InventoryApi* | [**delete_template_device**](docs/InventoryApi.md#delete_template_device) | **DELETE** /v1/inventory/templates/{templateDeviceUid} | Delete Template Device
*InventoryApi* | [**deploy_asa_device_changes**](docs/InventoryApi.md#deploy_asa_device_changes) | **POST** /v1/inventory/devices/asas/{deviceUid}/deploy | Deploy ASA device changes
*InventoryApi* | [**execute_cli_command**](docs/InventoryApi.md#execute_cli_command) | **POST** /v1/inventory/devices/asas/cli/execute | Execute CLI Command
*InventoryApi* | [**finish_onboarding_ftd_device**](docs/InventoryApi.md#finish_onboarding_ftd_device) | **POST** /v1/inventory/devices/ftds/register | Register FTD device.
*InventoryApi* | [**get_cloud_service**](docs/InventoryApi.md#get_cloud_service) | **GET** /v1/inventory/services/{cloudServiceUid} | Get Cloud Service
*InventoryApi* | [**get_cloud_services**](docs/InventoryApi.md#get_cloud_services) | **GET** /v1/inventory/services | Get Cloud Services
*InventoryApi* | [**get_device**](docs/InventoryApi.md#get_device) | **GET** /v1/inventory/devices/{deviceUid} | Get Device
*InventoryApi* | [**get_device_manager**](docs/InventoryApi.md#get_device_manager) | **GET** /v1/inventory/managers/{deviceManagerUid} | Get Device Manager
*InventoryApi* | [**get_device_managers**](docs/InventoryApi.md#get_device_managers) | **GET** /v1/inventory/managers | Get Device Managers
*InventoryApi* | [**get_devices**](docs/InventoryApi.md#get_devices) | **GET** /v1/inventory/devices | Get Devices
*InventoryApi* | [**get_template_device**](docs/InventoryApi.md#get_template_device) | **GET** /v1/inventory/templates/{templateDeviceUid} | Get Template Device
*InventoryApi* | [**get_template_devices**](docs/InventoryApi.md#get_template_devices) | **GET** /v1/inventory/templates | Get Template Devices
*InventoryApi* | [**modify_cloud_service**](docs/InventoryApi.md#modify_cloud_service) | **PATCH** /v1/inventory/services/{cloudServiceUid} | Modify Cloud Service
*InventoryApi* | [**modify_device**](docs/InventoryApi.md#modify_device) | **PATCH** /v1/inventory/devices/{deviceUid} | Modify Device
*InventoryApi* | [**modify_device_manager**](docs/InventoryApi.md#modify_device_manager) | **PATCH** /v1/inventory/managers/{deviceManagerUid} | Modify Device Manager
*InventoryApi* | [**modify_template_device**](docs/InventoryApi.md#modify_template_device) | **PATCH** /v1/inventory/templates/{templateDeviceUid} | Modify Template Device
*InventoryApi* | [**onboard_asa_device**](docs/InventoryApi.md#onboard_asa_device) | **POST** /v1/inventory/devices/asas | Onboard ASA device
*InventoryApi* | [**onboard_ios_device**](docs/InventoryApi.md#onboard_ios_device) | **POST** /v1/inventory/devices/ios | Onboard IOS Device
*InventoryApi* | [**read_asa_device_configuration**](docs/InventoryApi.md#read_asa_device_configuration) | **POST** /v1/inventory/devices/asas/{deviceUid}/read | Read ASA device configuration
*InventoryApi* | [**reconnect_asa_device**](docs/InventoryApi.md#reconnect_asa_device) | **POST** /v1/inventory/devices/asas/{deviceUid}/reconnect | Reconnect ASA device
*MetaApi* | [**get_jwks**](docs/MetaApi.md#get_jwks) | **GET** /.well-known/jwks.json | Fetch JSON Web Key Set
*MetaApi* | [**get_meta**](docs/MetaApi.md#get_meta) | **GET** /v1/meta | Get Meta information
*MetaApi* | [**get_regions**](docs/MetaApi.md#get_regions) | **GET** /v1/regions | Get CDO Regions
*ObjectManagementApi* | [**create_object**](docs/ObjectManagementApi.md#create_object) | **POST** /v0/objects | Create Object
*ObjectManagementApi* | [**create_targets**](docs/ObjectManagementApi.md#create_targets) | **POST** /v0/objects/{uid}/targets | Create Targets
*ObjectManagementApi* | [**delete_object**](docs/ObjectManagementApi.md#delete_object) | **DELETE** /v0/objects/{uid} | Delete Object
*ObjectManagementApi* | [**delete_targets**](docs/ObjectManagementApi.md#delete_targets) | **DELETE** /v0/objects/{uid}/targets | Delete Targets
*ObjectManagementApi* | [**get_duplicate_objects**](docs/ObjectManagementApi.md#get_duplicate_objects) | **GET** /v0/objects/{uid}/duplicates | Get Duplicate Objects
*ObjectManagementApi* | [**get_issues_count**](docs/ObjectManagementApi.md#get_issues_count) | **GET** /v0/objects/issues-count | Get Issues Count
*ObjectManagementApi* | [**get_object**](docs/ObjectManagementApi.md#get_object) | **GET** /v0/objects/{uid} | Get Object
*ObjectManagementApi* | [**get_object_usages**](docs/ObjectManagementApi.md#get_object_usages) | **GET** /v0/objects/{uid}/usage | Get Object Usages
*ObjectManagementApi* | [**get_objects**](docs/ObjectManagementApi.md#get_objects) | **GET** /v0/objects | Get Objects
*ObjectManagementApi* | [**modify_object**](docs/ObjectManagementApi.md#modify_object) | **PATCH** /v0/objects/{uid} | Modify Object
*RemoteAccessMonitoringApi* | [**get_mfa_event**](docs/RemoteAccessMonitoringApi.md#get_mfa_event) | **GET** /v1/mfaevents/{mfaEventUid} | Get MFA Event
*RemoteAccessMonitoringApi* | [**get_mfa_events**](docs/RemoteAccessMonitoringApi.md#get_mfa_events) | **GET** /v1/mfaevents | Get MFA Events
*RemoteAccessMonitoringApi* | [**get_ra_vpn_session**](docs/RemoteAccessMonitoringApi.md#get_ra_vpn_session) | **GET** /v1/vpnsessions/{raVpnSessionUid} | Get RA VPN Session
*RemoteAccessMonitoringApi* | [**get_ra_vpn_sessions**](docs/RemoteAccessMonitoringApi.md#get_ra_vpn_sessions) | **GET** /v1/vpnsessions | Get RA VPN Sessions
*RemoteAccessMonitoringApi* | [**refresh_ra_vpn_sessions_by_device**](docs/RemoteAccessMonitoringApi.md#refresh_ra_vpn_sessions_by_device) | **POST** /v1/vpnsessions/refresh | Refresh RA VPN Sessions
*RemoteAccessMonitoringApi* | [**terminate_ra_vpn_sessions_by_device**](docs/RemoteAccessMonitoringApi.md#terminate_ra_vpn_sessions_by_device) | **POST** /v1/vpnsessions/{deviceUid}/terminate | Terminate RA VPN Sessions
*RemoteAccessMonitoringApi* | [**terminate_ra_vpn_sessions_by_device_and_user_name**](docs/RemoteAccessMonitoringApi.md#terminate_ra_vpn_sessions_by_device_and_user_name) | **POST** /v1/vpnsessions/{deviceUid}/terminate/{userName} | Terminate User&#39;s RA VPN Sessions
*SearchApi* | [**initiate_full_indexing**](docs/SearchApi.md#initiate_full_indexing) | **POST** /v1/search/index | Rebuild search index
*SearchApi* | [**search**](docs/SearchApi.md#search) | **GET** /v1/search | Search
*TenantManagementApi* | [**add_msp_tenant**](docs/TenantManagementApi.md#add_msp_tenant) | **POST** /v1/msp/tenants | Add Tenant to MSP Portal
*TenantManagementApi* | [**get_feature_flags**](docs/TenantManagementApi.md#get_feature_flags) | **GET** /v1/features | Get Feature Flags
*TenantManagementApi* | [**get_tenant**](docs/TenantManagementApi.md#get_tenant) | **GET** /v1/tenants/{tenantUid} | Get Tenant
*TenantManagementApi* | [**get_tenant_settings**](docs/TenantManagementApi.md#get_tenant_settings) | **GET** /v1/settings/tenant | Get Tenant Settings
*TenantManagementApi* | [**get_tenants**](docs/TenantManagementApi.md#get_tenants) | **GET** /v1/tenants | Get Tenants
*TenantManagementApi* | [**modify_tenant_settings**](docs/TenantManagementApi.md#modify_tenant_settings) | **PATCH** /v1/settings/tenant | Modify Tenant Settings
*TransactionsApi* | [**get_transaction**](docs/TransactionsApi.md#get_transaction) | **GET** /v1/transactions/{transactionUid} | Get Transaction
*UsersApi* | [**create_user**](docs/UsersApi.md#create_user) | **POST** /v1/users | Create User in CDO Tenant
*UsersApi* | [**delete_user**](docs/UsersApi.md#delete_user) | **DELETE** /v1/users/{userUid} | Remove User from CDO Tenant
*UsersApi* | [**generate_api_token**](docs/UsersApi.md#generate_api_token) | **POST** /v1/users/{apiUserId}/apiToken/generate | Generate Token for API-only user
*UsersApi* | [**get_token**](docs/UsersApi.md#get_token) | **GET** /v1/token | Get Token Info
*UsersApi* | [**get_user**](docs/UsersApi.md#get_user) | **GET** /v1/users/{userUid} | Get Tenant User
*UsersApi* | [**get_users**](docs/UsersApi.md#get_users) | **GET** /v1/users | Get Tenant Users
*UsersApi* | [**revoke_api_token**](docs/UsersApi.md#revoke_api_token) | **POST** /v1/users/{apiUserId}/apiToken/revoke | Revoke API-only User&#39;s Token
*UsersApi* | [**revoke_token**](docs/UsersApi.md#revoke_token) | **POST** /v1/token/revoke | Revoke Token


## Documentation For Models

 - [ApiTokenInfo](docs/ApiTokenInfo.md)
 - [AsaCreateOrUpdateInput](docs/AsaCreateOrUpdateInput.md)
 - [AsaFailoverMate](docs/AsaFailoverMate.md)
 - [AsaFailoverMode](docs/AsaFailoverMode.md)
 - [AuthenticationError](docs/AuthenticationError.md)
 - [Browser](docs/Browser.md)
 - [CdFmcInfo](docs/CdFmcInfo.md)
 - [CdFmcObject](docs/CdFmcObject.md)
 - [CdFmcResult](docs/CdFmcResult.md)
 - [CdoCliMacro](docs/CdoCliMacro.md)
 - [CdoCliMacroPage](docs/CdoCliMacroPage.md)
 - [CdoCliResult](docs/CdoCliResult.md)
 - [CdoCliResultPage](docs/CdoCliResultPage.md)
 - [CdoRegion](docs/CdoRegion.md)
 - [CdoRegionList](docs/CdoRegionList.md)
 - [CdoTokenInfo](docs/CdoTokenInfo.md)
 - [CdoTransaction](docs/CdoTransaction.md)
 - [CdoTransactionStatus](docs/CdoTransactionStatus.md)
 - [CdoTransactionType](docs/CdoTransactionType.md)
 - [ChangeRequest](docs/ChangeRequest.md)
 - [ChangeRequestCreateInput](docs/ChangeRequestCreateInput.md)
 - [ChangeRequestPage](docs/ChangeRequestPage.md)
 - [Changelog](docs/Changelog.md)
 - [ChangelogPage](docs/ChangelogPage.md)
 - [CliCommandInput](docs/CliCommandInput.md)
 - [CliMacroCreateInput](docs/CliMacroCreateInput.md)
 - [ClientDevice](docs/ClientDevice.md)
 - [CommonApiError](docs/CommonApiError.md)
 - [ConfigState](docs/ConfigState.md)
 - [ConflictDetectionInterval](docs/ConflictDetectionInterval.md)
 - [ConflictDetectionState](docs/ConflictDetectionState.md)
 - [ConnectivityState](docs/ConnectivityState.md)
 - [ConnectorType](docs/ConnectorType.md)
 - [CreateRequest](docs/CreateRequest.md)
 - [Device](docs/Device.md)
 - [DevicePage](docs/DevicePage.md)
 - [DevicePatchInput](docs/DevicePatchInput.md)
 - [DeviceRole](docs/DeviceRole.md)
 - [DuoAdminPanelCreateOrUpdateInput](docs/DuoAdminPanelCreateOrUpdateInput.md)
 - [DuplicateGroupDto](docs/DuplicateGroupDto.md)
 - [Entity](docs/Entity.md)
 - [EntityType](docs/EntityType.md)
 - [Event](docs/Event.md)
 - [FtdCreateOrUpdateInput](docs/FtdCreateOrUpdateInput.md)
 - [FtdRegistrationInput](docs/FtdRegistrationInput.md)
 - [GlobalSearchResult](docs/GlobalSearchResult.md)
 - [GroupContent](docs/GroupContent.md)
 - [Icmp4Value](docs/Icmp4Value.md)
 - [Icmp6Value](docs/Icmp6Value.md)
 - [Inventory](docs/Inventory.md)
 - [IosCreateOrUpdateInput](docs/IosCreateOrUpdateInput.md)
 - [IssuesCount](docs/IssuesCount.md)
 - [IssuesDto](docs/IssuesDto.md)
 - [JsonWebKey](docs/JsonWebKey.md)
 - [JwkSet](docs/JwkSet.md)
 - [Labels](docs/Labels.md)
 - [ListObjectResponse](docs/ListObjectResponse.md)
 - [Location](docs/Location.md)
 - [MerakiDeploymentMode](docs/MerakiDeploymentMode.md)
 - [Meta](docs/Meta.md)
 - [MfaEvent](docs/MfaEvent.md)
 - [MfaEventPage](docs/MfaEventPage.md)
 - [MspAddTenantInput](docs/MspAddTenantInput.md)
 - [Network](docs/Network.md)
 - [NetworkObjectContent](docs/NetworkObjectContent.md)
 - [OS](docs/OS.md)
 - [ObjectContent](docs/ObjectContent.md)
 - [ObjectResponse](docs/ObjectResponse.md)
 - [OnPremFmcInfo](docs/OnPremFmcInfo.md)
 - [Override](docs/Override.md)
 - [Policy](docs/Policy.md)
 - [PortsValue](docs/PortsValue.md)
 - [PublicKey](docs/PublicKey.md)
 - [RaVpnDeviceInput](docs/RaVpnDeviceInput.md)
 - [RaVpnSession](docs/RaVpnSession.md)
 - [RaVpnSessionPage](docs/RaVpnSessionPage.md)
 - [ReferenceInfo](docs/ReferenceInfo.md)
 - [Sdc](docs/Sdc.md)
 - [SdcCreateInput](docs/SdcCreateInput.md)
 - [SdcPage](docs/SdcPage.md)
 - [SdcPatchInput](docs/SdcPatchInput.md)
 - [ServiceObjectContent](docs/ServiceObjectContent.md)
 - [ServiceObjectValueContent](docs/ServiceObjectValueContent.md)
 - [SharedObjectValue](docs/SharedObjectValue.md)
 - [SingleContent](docs/SingleContent.md)
 - [StateMachineDetails](docs/StateMachineDetails.md)
 - [StateMachineError](docs/StateMachineError.md)
 - [Status](docs/Status.md)
 - [StatusInfo](docs/StatusInfo.md)
 - [Target](docs/Target.md)
 - [TargetsRequest](docs/TargetsRequest.md)
 - [Tenant](docs/Tenant.md)
 - [TenantPage](docs/TenantPage.md)
 - [TenantPayType](docs/TenantPayType.md)
 - [TenantSettings](docs/TenantSettings.md)
 - [UnifiedObjectListView](docs/UnifiedObjectListView.md)
 - [UpdateRequest](docs/UpdateRequest.md)
 - [UrlObjectContent](docs/UrlObjectContent.md)
 - [User](docs/User.md)
 - [UserCreateOrUpdateInput](docs/UserCreateOrUpdateInput.md)
 - [UserPage](docs/UserPage.md)
 - [UserRole](docs/UserRole.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization


Authentication schemes defined for the API:
<a id="bearerAuth"></a>
### bearerAuth

- **Type**: Bearer authentication (JWT)


## Author

cdo.tac@cisco.com


