# coding: utf-8

"""
    CDO API

    Use the documentation to explore the endpoints CDO has to offer

    The version of the OpenAPI document: 1.4.0
    Contact: cdo.tac@cisco.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from cdo_sdk_python.models.browser import Browser
from cdo_sdk_python.models.location import Location
from cdo_sdk_python.models.os import OS
from typing import Optional, Set
from typing_extensions import Self

class ClientDevice(BaseModel):
    """
    The client device that triggered this MFA event.
    """ # noqa: E501
    uid: StrictStr = Field(description="The unique identifier, represented as a UUID, of the device.")
    location: Optional[Location] = None
    ip_address: Optional[StrictStr] = Field(default=None, description="The IP address of the client device that has triggered this MFA event.", alias="ipAddress")
    password_set: Optional[StrictBool] = Field(default=None, description="Indicates whether a password is set on the client device.", alias="passwordSet")
    encrypted: Optional[StrictBool] = Field(default=None, description="Indicates whether encryption is enabled on the client device.")
    firewalled: Optional[StrictBool] = Field(default=None, description="Indicates whether a firewall is enabled on the client device.")
    os: Optional[OS] = None
    browser: Optional[Browser] = None
    __properties: ClassVar[List[str]] = ["uid", "location", "ipAddress", "passwordSet", "encrypted", "firewalled", "os", "browser"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ClientDevice from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of location
        if self.location:
            _dict['location'] = self.location.to_dict()
        # override the default output from pydantic by calling `to_dict()` of os
        if self.os:
            _dict['os'] = self.os.to_dict()
        # override the default output from pydantic by calling `to_dict()` of browser
        if self.browser:
            _dict['browser'] = self.browser.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ClientDevice from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "uid": obj.get("uid"),
            "location": Location.from_dict(obj["location"]) if obj.get("location") is not None else None,
            "ipAddress": obj.get("ipAddress"),
            "passwordSet": obj.get("passwordSet"),
            "encrypted": obj.get("encrypted"),
            "firewalled": obj.get("firewalled"),
            "os": OS.from_dict(obj["os"]) if obj.get("os") is not None else None,
            "browser": Browser.from_dict(obj["browser"]) if obj.get("browser") is not None else None
        })
        return _obj


