# coding: utf-8

"""
    CDO API

    Use the documentation to explore the endpoints CDO has to offer

    The version of the OpenAPI document: 1.5.0
    Contact: cdo.tac@cisco.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from cdo_sdk_python.models.chassis_stats_health_metrics import ChassisStatsHealthMetrics
from cdo_sdk_python.models.cpu_health_metrics import CpuHealthMetrics
from cdo_sdk_python.models.disk_health_metrics import DiskHealthMetrics
from cdo_sdk_python.models.ha_health_metrics import HaHealthMetrics
from cdo_sdk_python.models.interface_health_metrics import InterfaceHealthMetrics
from cdo_sdk_python.models.memory_health_metrics import MemoryHealthMetrics
from typing import Optional, Set
from typing_extensions import Self

class FmcHealthMetrics(BaseModel):
    """
    FmcHealthMetrics
    """ # noqa: E501
    device_uid: Optional[StrictStr] = Field(default=None, description="The unique identifier, represented as a UUID, of the device in CDO.", alias="deviceUid")
    device_name: Optional[StrictStr] = Field(default=None, description="The name of the device in CDO.", alias="deviceName")
    start_time: Optional[datetime] = Field(default=None, description="The start of the time period (inclusive) for which the health metrics were retrieved for this device.", alias="startTime")
    end_time: Optional[datetime] = Field(default=None, description="The end of the time period (inclusive) for which the health metrics were retrieved for this device.", alias="endTime")
    cpu_health_metrics: Optional[CpuHealthMetrics] = Field(default=None, alias="cpuHealthMetrics")
    memory_health_metrics: Optional[MemoryHealthMetrics] = Field(default=None, alias="memoryHealthMetrics")
    disk_health_metrics: Optional[DiskHealthMetrics] = Field(default=None, alias="diskHealthMetrics")
    chassis_stats_health_metrics: Optional[ChassisStatsHealthMetrics] = Field(default=None, alias="chassisStatsHealthMetrics")
    interface_health_metrics: Optional[List[InterfaceHealthMetrics]] = Field(default=None, description="The interface health metrics for the device.", alias="interfaceHealthMetrics")
    ha_health_metrics: Optional[HaHealthMetrics] = Field(default=None, alias="haHealthMetrics")
    __properties: ClassVar[List[str]] = ["deviceUid", "deviceName", "startTime", "endTime", "cpuHealthMetrics", "memoryHealthMetrics", "diskHealthMetrics", "chassisStatsHealthMetrics", "interfaceHealthMetrics", "haHealthMetrics"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of FmcHealthMetrics from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of cpu_health_metrics
        if self.cpu_health_metrics:
            _dict['cpuHealthMetrics'] = self.cpu_health_metrics.to_dict()
        # override the default output from pydantic by calling `to_dict()` of memory_health_metrics
        if self.memory_health_metrics:
            _dict['memoryHealthMetrics'] = self.memory_health_metrics.to_dict()
        # override the default output from pydantic by calling `to_dict()` of disk_health_metrics
        if self.disk_health_metrics:
            _dict['diskHealthMetrics'] = self.disk_health_metrics.to_dict()
        # override the default output from pydantic by calling `to_dict()` of chassis_stats_health_metrics
        if self.chassis_stats_health_metrics:
            _dict['chassisStatsHealthMetrics'] = self.chassis_stats_health_metrics.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in interface_health_metrics (list)
        _items = []
        if self.interface_health_metrics:
            for _item in self.interface_health_metrics:
                if _item:
                    _items.append(_item.to_dict())
            _dict['interfaceHealthMetrics'] = _items
        # override the default output from pydantic by calling `to_dict()` of ha_health_metrics
        if self.ha_health_metrics:
            _dict['haHealthMetrics'] = self.ha_health_metrics.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of FmcHealthMetrics from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "deviceUid": obj.get("deviceUid"),
            "deviceName": obj.get("deviceName"),
            "startTime": obj.get("startTime"),
            "endTime": obj.get("endTime"),
            "cpuHealthMetrics": CpuHealthMetrics.from_dict(obj["cpuHealthMetrics"]) if obj.get("cpuHealthMetrics") is not None else None,
            "memoryHealthMetrics": MemoryHealthMetrics.from_dict(obj["memoryHealthMetrics"]) if obj.get("memoryHealthMetrics") is not None else None,
            "diskHealthMetrics": DiskHealthMetrics.from_dict(obj["diskHealthMetrics"]) if obj.get("diskHealthMetrics") is not None else None,
            "chassisStatsHealthMetrics": ChassisStatsHealthMetrics.from_dict(obj["chassisStatsHealthMetrics"]) if obj.get("chassisStatsHealthMetrics") is not None else None,
            "interfaceHealthMetrics": [InterfaceHealthMetrics.from_dict(_item) for _item in obj["interfaceHealthMetrics"]] if obj.get("interfaceHealthMetrics") is not None else None,
            "haHealthMetrics": HaHealthMetrics.from_dict(obj["haHealthMetrics"]) if obj.get("haHealthMetrics") is not None else None
        })
        return _obj


