# coding: utf-8

"""
    CDO API

    Use the documentation to explore the endpoints CDO has to offer

    The version of the OpenAPI document: 1.5.0
    Contact: cdo.tac@cisco.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from cdo_sdk_python.models.application_context import ApplicationContext
from cdo_sdk_python.models.redirect_view_servlet_context import RedirectViewServletContext
from typing import Optional, Set
from typing_extensions import Self

class RedirectView(BaseModel):
    """
    RedirectView
    """ # noqa: E501
    application_context: Optional[ApplicationContext] = Field(default=None, alias="applicationContext")
    servlet_context: Optional[RedirectViewServletContext] = Field(default=None, alias="servletContext")
    content_type: Optional[StrictStr] = Field(default=None, alias="contentType")
    request_context_attribute: Optional[StrictStr] = Field(default=None, alias="requestContextAttribute")
    static_attributes: Optional[Dict[str, Dict[str, Any]]] = Field(default=None, alias="staticAttributes")
    expose_path_variables: Optional[StrictBool] = Field(default=None, alias="exposePathVariables")
    expose_context_beans_as_attributes: Optional[StrictBool] = Field(default=None, alias="exposeContextBeansAsAttributes")
    exposed_context_bean_names: Optional[List[StrictStr]] = Field(default=None, alias="exposedContextBeanNames")
    bean_name: Optional[StrictStr] = Field(default=None, alias="beanName")
    url: Optional[StrictStr] = None
    context_relative: Optional[StrictBool] = Field(default=None, alias="contextRelative")
    http10_compatible: Optional[StrictBool] = Field(default=None, alias="http10Compatible")
    expose_model_attributes: Optional[StrictBool] = Field(default=None, alias="exposeModelAttributes")
    encoding_scheme: Optional[StrictStr] = Field(default=None, alias="encodingScheme")
    status_code: Optional[StrictStr] = Field(default=None, alias="statusCode")
    expand_uri_template_variables: Optional[StrictBool] = Field(default=None, alias="expandUriTemplateVariables")
    propagate_query_params: Optional[StrictBool] = Field(default=None, alias="propagateQueryParams")
    hosts: Optional[List[StrictStr]] = None
    redirect_view: Optional[StrictBool] = Field(default=None, alias="redirectView")
    propagate_query_properties: Optional[StrictBool] = Field(default=None, alias="propagateQueryProperties")
    attributes: Optional[Dict[str, StrictStr]] = None
    attributes_map: Optional[Dict[str, Dict[str, Any]]] = Field(default=None, alias="attributesMap")
    attributes_csv: Optional[StrictStr] = Field(default=None, alias="attributesCSV")
    __properties: ClassVar[List[str]] = ["applicationContext", "servletContext", "contentType", "requestContextAttribute", "staticAttributes", "exposePathVariables", "exposeContextBeansAsAttributes", "exposedContextBeanNames", "beanName", "url", "contextRelative", "http10Compatible", "exposeModelAttributes", "encodingScheme", "statusCode", "expandUriTemplateVariables", "propagateQueryParams", "hosts", "redirectView", "propagateQueryProperties", "attributes", "attributesMap", "attributesCSV"]

    @field_validator('status_code')
    def status_code_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['100 CONTINUE', '101 SWITCHING_PROTOCOLS', '102 PROCESSING', '103 CHECKPOINT', '200 OK', '201 CREATED', '202 ACCEPTED', '203 NON_AUTHORITATIVE_INFORMATION', '204 NO_CONTENT', '205 RESET_CONTENT', '206 PARTIAL_CONTENT', '207 MULTI_STATUS', '208 ALREADY_REPORTED', '226 IM_USED', '300 MULTIPLE_CHOICES', '301 MOVED_PERMANENTLY', '302 FOUND', '302 MOVED_TEMPORARILY', '303 SEE_OTHER', '304 NOT_MODIFIED', '305 USE_PROXY', '307 TEMPORARY_REDIRECT', '308 PERMANENT_REDIRECT', '400 BAD_REQUEST', '401 UNAUTHORIZED', '402 PAYMENT_REQUIRED', '403 FORBIDDEN', '404 NOT_FOUND', '405 METHOD_NOT_ALLOWED', '406 NOT_ACCEPTABLE', '407 PROXY_AUTHENTICATION_REQUIRED', '408 REQUEST_TIMEOUT', '409 CONFLICT', '410 GONE', '411 LENGTH_REQUIRED', '412 PRECONDITION_FAILED', '413 PAYLOAD_TOO_LARGE', '413 REQUEST_ENTITY_TOO_LARGE', '414 URI_TOO_LONG', '414 REQUEST_URI_TOO_LONG', '415 UNSUPPORTED_MEDIA_TYPE', '416 REQUESTED_RANGE_NOT_SATISFIABLE', '417 EXPECTATION_FAILED', '418 I_AM_A_TEAPOT', '419 INSUFFICIENT_SPACE_ON_RESOURCE', '420 METHOD_FAILURE', '421 DESTINATION_LOCKED', '422 UNPROCESSABLE_ENTITY', '423 LOCKED', '424 FAILED_DEPENDENCY', '425 TOO_EARLY', '426 UPGRADE_REQUIRED', '428 PRECONDITION_REQUIRED', '429 TOO_MANY_REQUESTS', '431 REQUEST_HEADER_FIELDS_TOO_LARGE', '451 UNAVAILABLE_FOR_LEGAL_REASONS', '500 INTERNAL_SERVER_ERROR', '501 NOT_IMPLEMENTED', '502 BAD_GATEWAY', '503 SERVICE_UNAVAILABLE', '504 GATEWAY_TIMEOUT', '505 HTTP_VERSION_NOT_SUPPORTED', '506 VARIANT_ALSO_NEGOTIATES', '507 INSUFFICIENT_STORAGE', '508 LOOP_DETECTED', '509 BANDWIDTH_LIMIT_EXCEEDED', '510 NOT_EXTENDED', '511 NETWORK_AUTHENTICATION_REQUIRED']):
            raise ValueError("must be one of enum values ('100 CONTINUE', '101 SWITCHING_PROTOCOLS', '102 PROCESSING', '103 CHECKPOINT', '200 OK', '201 CREATED', '202 ACCEPTED', '203 NON_AUTHORITATIVE_INFORMATION', '204 NO_CONTENT', '205 RESET_CONTENT', '206 PARTIAL_CONTENT', '207 MULTI_STATUS', '208 ALREADY_REPORTED', '226 IM_USED', '300 MULTIPLE_CHOICES', '301 MOVED_PERMANENTLY', '302 FOUND', '302 MOVED_TEMPORARILY', '303 SEE_OTHER', '304 NOT_MODIFIED', '305 USE_PROXY', '307 TEMPORARY_REDIRECT', '308 PERMANENT_REDIRECT', '400 BAD_REQUEST', '401 UNAUTHORIZED', '402 PAYMENT_REQUIRED', '403 FORBIDDEN', '404 NOT_FOUND', '405 METHOD_NOT_ALLOWED', '406 NOT_ACCEPTABLE', '407 PROXY_AUTHENTICATION_REQUIRED', '408 REQUEST_TIMEOUT', '409 CONFLICT', '410 GONE', '411 LENGTH_REQUIRED', '412 PRECONDITION_FAILED', '413 PAYLOAD_TOO_LARGE', '413 REQUEST_ENTITY_TOO_LARGE', '414 URI_TOO_LONG', '414 REQUEST_URI_TOO_LONG', '415 UNSUPPORTED_MEDIA_TYPE', '416 REQUESTED_RANGE_NOT_SATISFIABLE', '417 EXPECTATION_FAILED', '418 I_AM_A_TEAPOT', '419 INSUFFICIENT_SPACE_ON_RESOURCE', '420 METHOD_FAILURE', '421 DESTINATION_LOCKED', '422 UNPROCESSABLE_ENTITY', '423 LOCKED', '424 FAILED_DEPENDENCY', '425 TOO_EARLY', '426 UPGRADE_REQUIRED', '428 PRECONDITION_REQUIRED', '429 TOO_MANY_REQUESTS', '431 REQUEST_HEADER_FIELDS_TOO_LARGE', '451 UNAVAILABLE_FOR_LEGAL_REASONS', '500 INTERNAL_SERVER_ERROR', '501 NOT_IMPLEMENTED', '502 BAD_GATEWAY', '503 SERVICE_UNAVAILABLE', '504 GATEWAY_TIMEOUT', '505 HTTP_VERSION_NOT_SUPPORTED', '506 VARIANT_ALSO_NEGOTIATES', '507 INSUFFICIENT_STORAGE', '508 LOOP_DETECTED', '509 BANDWIDTH_LIMIT_EXCEEDED', '510 NOT_EXTENDED', '511 NETWORK_AUTHENTICATION_REQUIRED')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RedirectView from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of application_context
        if self.application_context:
            _dict['applicationContext'] = self.application_context.to_dict()
        # override the default output from pydantic by calling `to_dict()` of servlet_context
        if self.servlet_context:
            _dict['servletContext'] = self.servlet_context.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RedirectView from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "applicationContext": ApplicationContext.from_dict(obj["applicationContext"]) if obj.get("applicationContext") is not None else None,
            "servletContext": RedirectViewServletContext.from_dict(obj["servletContext"]) if obj.get("servletContext") is not None else None,
            "contentType": obj.get("contentType"),
            "requestContextAttribute": obj.get("requestContextAttribute"),
            "staticAttributes": obj.get("staticAttributes"),
            "exposePathVariables": obj.get("exposePathVariables"),
            "exposeContextBeansAsAttributes": obj.get("exposeContextBeansAsAttributes"),
            "exposedContextBeanNames": obj.get("exposedContextBeanNames"),
            "beanName": obj.get("beanName"),
            "url": obj.get("url"),
            "contextRelative": obj.get("contextRelative"),
            "http10Compatible": obj.get("http10Compatible"),
            "exposeModelAttributes": obj.get("exposeModelAttributes"),
            "encodingScheme": obj.get("encodingScheme"),
            "statusCode": obj.get("statusCode"),
            "expandUriTemplateVariables": obj.get("expandUriTemplateVariables"),
            "propagateQueryParams": obj.get("propagateQueryParams"),
            "hosts": obj.get("hosts"),
            "redirectView": obj.get("redirectView"),
            "propagateQueryProperties": obj.get("propagateQueryProperties"),
            "attributes": obj.get("attributes"),
            "attributesMap": obj.get("attributesMap"),
            "attributesCSV": obj.get("attributesCSV")
        })
        return _obj


