# coding: utf-8

"""
    CDO API

    Use the documentation to explore the endpoints CDO has to offer

    The version of the OpenAPI document: 1.3.0
    Contact: cdo.tac@cisco.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from cdo_sdk_python.models.cpu_health_metrics import CpuHealthMetrics
from cdo_sdk_python.models.memory_health_metrics import MemoryHealthMetrics
from typing import Optional, Set
from typing_extensions import Self

class FmcHealthMetrics(BaseModel):
    """
    FmcHealthMetrics
    """ # noqa: E501
    device_uid: Optional[StrictStr] = Field(default=None, description="The unique identifier of the device in CDO.", alias="deviceUid")
    device_name: Optional[StrictStr] = Field(default=None, description="The name of the device in CDO.", alias="deviceName")
    cpu_health_metrics: Optional[CpuHealthMetrics] = Field(default=None, alias="cpuHealthMetrics")
    memory_health_metrics: Optional[MemoryHealthMetrics] = Field(default=None, alias="memoryHealthMetrics")
    __properties: ClassVar[List[str]] = ["deviceUid", "deviceName", "cpuHealthMetrics", "memoryHealthMetrics"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of FmcHealthMetrics from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of cpu_health_metrics
        if self.cpu_health_metrics:
            _dict['cpuHealthMetrics'] = self.cpu_health_metrics.to_dict()
        # override the default output from pydantic by calling `to_dict()` of memory_health_metrics
        if self.memory_health_metrics:
            _dict['memoryHealthMetrics'] = self.memory_health_metrics.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of FmcHealthMetrics from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "deviceUid": obj.get("deviceUid"),
            "deviceName": obj.get("deviceName"),
            "cpuHealthMetrics": CpuHealthMetrics.from_dict(obj["cpuHealthMetrics"]) if obj.get("cpuHealthMetrics") is not None else None,
            "memoryHealthMetrics": MemoryHealthMetrics.from_dict(obj["memoryHealthMetrics"]) if obj.get("memoryHealthMetrics") is not None else None
        })
        return _obj


