# coding: utf-8

"""
    CDO API

    Use the documentation to explore the endpoints CDO has to offer

    The version of the OpenAPI document: 1.5.0
    Contact: cdo.tac@cisco.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class ZtpOnboardingInput(BaseModel):
    """
    ZtpOnboardingInput
    """ # noqa: E501
    name: StrictStr = Field(description="Specify a human-readable name for the device.")
    serial_number: StrictStr = Field(description="Specify the serial number of the FTD device to be onboarded. When a device with this serial number is plugged in and connected to the Internet, it will automatically be registered to this CDO tenant.", alias="serialNumber")
    admin_password: Optional[StrictStr] = Field(default=None, description="Specify the initial provisioning password. This is required for setting up the FTD, and can be ignored if password is already set on the device.", alias="adminPassword")
    fmc_access_policy_uid: StrictStr = Field(description="Specify the unique identifier, represented as a UUID, of the FMC access policy to apply to this device.", alias="fmcAccessPolicyUid")
    licenses: List[StrictStr] = Field(description="Specify a set of licenses to apply to the device.")
    device_group_uid: Optional[StrictStr] = Field(default=None, description="Specify the unique identifier, represented as a UUID, of the device group which the device will be a part of after it finishes registering with CDO.", alias="deviceGroupUid")
    __properties: ClassVar[List[str]] = ["name", "serialNumber", "adminPassword", "fmcAccessPolicyUid", "licenses", "deviceGroupUid"]

    @field_validator('licenses')
    def licenses_validate_enum(cls, value):
        """Validates the enum"""
        for i in value:
            if i not in set(['BASE', 'CARRIER', 'THREAT', 'MALWARE', 'URLFilter', 'BASE', 'CARRIER', 'MALWARE', 'THREAT', 'URLFilter']):
                raise ValueError("each list item must be one of ('BASE', 'CARRIER', 'THREAT', 'MALWARE', 'URLFilter', 'BASE', 'CARRIER', 'MALWARE', 'THREAT', 'URLFilter')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ZtpOnboardingInput from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ZtpOnboardingInput from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "serialNumber": obj.get("serialNumber"),
            "adminPassword": obj.get("adminPassword"),
            "fmcAccessPolicyUid": obj.get("fmcAccessPolicyUid"),
            "licenses": obj.get("licenses"),
            "deviceGroupUid": obj.get("deviceGroupUid")
        })
        return _obj


