# coding: utf-8

"""
    CDO API

    Use the documentation to explore the endpoints CDO has to offer

    The version of the OpenAPI document: 1.5.0
    Contact: cdo.tac@cisco.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class CdoTransaction(BaseModel):
    """
    CdoTransaction
    """ # noqa: E501
    tenant_uid: Optional[StrictStr] = Field(default=None, description="The unique identifier of the tenant that the transaction triggered on.", alias="tenantUid")
    transaction_uid: Optional[StrictStr] = Field(default=None, description="The unique identifier of the transaction triggered.", alias="transactionUid")
    entity_uid: Optional[StrictStr] = Field(default=None, description="The unique identifier of the entity that the transaction is triggered on. This can be empty, for a transaction that is not tied to an entity, such as transactions which refresh RA VPN sessions.", alias="entityUid")
    entity_url: Optional[StrictStr] = Field(default=None, description="A URL to access the entity that the transaction is triggered on. This can also be empty", alias="entityUrl")
    transaction_polling_url: Optional[StrictStr] = Field(default=None, description="The URL to poll to track the progress of the transaction.", alias="transactionPollingUrl")
    submission_time: Optional[datetime] = Field(default=None, description="The time (UTC; represented using the RFC-3339 standard) at which the transaction was triggered", alias="submissionTime")
    last_updated_time: Optional[datetime] = Field(default=None, description="The time (UTC; represented using the RFC-3339 standard) at which the transaction status was last updated", alias="lastUpdatedTime")
    transaction_details: Optional[Dict[str, StrictStr]] = Field(default=None, description="Transaction details, if any", alias="transactionDetails")
    error_message: Optional[StrictStr] = Field(default=None, description="Transaction error message, if any", alias="errorMessage")
    error_details: Optional[Dict[str, StrictStr]] = Field(default=None, description="Transaction error details, if any", alias="errorDetails")
    transaction_type: Optional[StrictStr] = Field(default=None, description="the type of the transaction", alias="transactionType")
    cdo_transaction_status: Optional[StrictStr] = Field(default=None, description="The status of the CDO transaction", alias="cdoTransactionStatus")
    __properties: ClassVar[List[str]] = ["tenantUid", "transactionUid", "entityUid", "entityUrl", "transactionPollingUrl", "submissionTime", "lastUpdatedTime", "transactionDetails", "errorMessage", "errorDetails", "transactionType", "cdoTransactionStatus"]

    @field_validator('transaction_type')
    def transaction_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['ONBOARD_ASA', 'ONBOARD_IOS', 'ONBOARD_DUO_ADMIN_PANEL', 'CREATE_FTD', 'ONBOARD_FTD_ZTP', 'REGISTER_FTD', 'DELETE_CDFMC_MANAGED_FTD', 'RECONNECT_ASA', 'READ_ASA', 'EXECUTE_CLI_COMMAND', 'DEPLOY_ASA_DEVICE_CHANGES', 'INDEX_TENANT', 'TERMINATE_DEVICE_RA_VPN_SESSIONS', 'REFRESH_RA_VPN_SESSIONS', 'TERMINATE_USER_RA_VPN_SESSIONS', 'DEVICE_UPGRADE', 'UPGRADE_ASA', 'UPGRADE_FTD', 'CREATE_SDC', 'SEND_AI_ASSISTANT_MESSAGE', 'MSP_CREATE_TENANT', 'MSP_ADD_USERS_TO_TENANT', 'MSP_ADD_USER_GROUPS_TO_TENANT', 'MSP_DELETE_USERS_FROM_TENANT', 'MSP_DELETE_USER_GROUPS_FROM_TENANT', 'MSP_ADD_EXISTING_TENANT', 'MSP_ENABLE_MULTICLOUD_DEFENSE', 'MSP_PROVISION_CDFMC']):
            raise ValueError("must be one of enum values ('ONBOARD_ASA', 'ONBOARD_IOS', 'ONBOARD_DUO_ADMIN_PANEL', 'CREATE_FTD', 'ONBOARD_FTD_ZTP', 'REGISTER_FTD', 'DELETE_CDFMC_MANAGED_FTD', 'RECONNECT_ASA', 'READ_ASA', 'EXECUTE_CLI_COMMAND', 'DEPLOY_ASA_DEVICE_CHANGES', 'INDEX_TENANT', 'TERMINATE_DEVICE_RA_VPN_SESSIONS', 'REFRESH_RA_VPN_SESSIONS', 'TERMINATE_USER_RA_VPN_SESSIONS', 'DEVICE_UPGRADE', 'UPGRADE_ASA', 'UPGRADE_FTD', 'CREATE_SDC', 'SEND_AI_ASSISTANT_MESSAGE', 'MSP_CREATE_TENANT', 'MSP_ADD_USERS_TO_TENANT', 'MSP_ADD_USER_GROUPS_TO_TENANT', 'MSP_DELETE_USERS_FROM_TENANT', 'MSP_DELETE_USER_GROUPS_FROM_TENANT', 'MSP_ADD_EXISTING_TENANT', 'MSP_ENABLE_MULTICLOUD_DEFENSE', 'MSP_PROVISION_CDFMC')")
        return value

    @field_validator('cdo_transaction_status')
    def cdo_transaction_status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['PENDING', 'IN_PROGRESS', 'DONE', 'ERROR']):
            raise ValueError("must be one of enum values ('PENDING', 'IN_PROGRESS', 'DONE', 'ERROR')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CdoTransaction from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CdoTransaction from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "tenantUid": obj.get("tenantUid"),
            "transactionUid": obj.get("transactionUid"),
            "entityUid": obj.get("entityUid"),
            "entityUrl": obj.get("entityUrl"),
            "transactionPollingUrl": obj.get("transactionPollingUrl"),
            "submissionTime": obj.get("submissionTime"),
            "lastUpdatedTime": obj.get("lastUpdatedTime"),
            "transactionDetails": obj.get("transactionDetails"),
            "errorMessage": obj.get("errorMessage"),
            "errorDetails": obj.get("errorDetails"),
            "transactionType": obj.get("transactionType"),
            "cdoTransactionStatus": obj.get("cdoTransactionStatus")
        })
        return _obj


