# coding: utf-8

"""
    Cisco Security Cloud Control API

    Use the documentation to explore the endpoints SCC has to offer

    The version of the OpenAPI document: 1.5.0
    Contact: cdo.tac@cisco.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from cdo_sdk_python.models.public_key import PublicKey
from cdo_sdk_python.models.status import Status
from typing import Optional, Set
from typing_extensions import Self

class Sdc(BaseModel):
    """
    Sdc
    """ # noqa: E501
    public_key: Optional[PublicKey] = Field(default=None, alias="publicKey")
    uid: Optional[StrictStr] = Field(default=None, description="The unique identifier, represented as a UUID, of the SDC in SCC.")
    name: StrictStr = Field(description="The name of the SDC in CDO. SDC names are unique in SCC.")
    software_version: Optional[StrictStr] = Field(default=None, description="The software version running on the SDC.", alias="softwareVersion")
    ip_address: Optional[StrictStr] = Field(default=None, description="The IP address of the SDC.", alias="ipAddress")
    status: Optional[Status] = None
    last_heartbeat: Optional[datetime] = Field(default=None, description="The time (UTC; represented using the RFC-3339 standard) that a heartbeat was last received from the SDC. This serves as an indicator of the health of the SDC.", alias="lastHeartbeat")
    bootstrap_data: Optional[StrictStr] = Field(default=None, description="The bootstrap data is information used to automatically configure the SDC during its initial setup. This data is base64 encoded and includes essential details like the unique registration token and customer-specific settings that enable the SDC to communicate with and send data to SCC. This field is populated only if the SDC is not onboarded.", alias="bootstrapData")
    __properties: ClassVar[List[str]] = ["publicKey", "uid", "name", "softwareVersion", "ipAddress", "status", "lastHeartbeat", "bootstrapData"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Sdc from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of public_key
        if self.public_key:
            _dict['publicKey'] = self.public_key.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Sdc from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "publicKey": PublicKey.from_dict(obj["publicKey"]) if obj.get("publicKey") is not None else None,
            "uid": obj.get("uid"),
            "name": obj.get("name"),
            "softwareVersion": obj.get("softwareVersion"),
            "ipAddress": obj.get("ipAddress"),
            "status": obj.get("status"),
            "lastHeartbeat": obj.get("lastHeartbeat"),
            "bootstrapData": obj.get("bootstrapData")
        })
        return _obj


