# coding: utf-8

"""
    Cisco Security Cloud Control API

    Use the documentation to explore the endpoints SCC has to offer

    The version of the OpenAPI document: 1.5.0
    Contact: cdo.tac@cisco.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from cdo_sdk_python.models.asa_failover_mate import AsaFailoverMate
from cdo_sdk_python.models.asa_failover_mode import AsaFailoverMode
from cdo_sdk_python.models.cd_fmc_info import CdFmcInfo
from cdo_sdk_python.models.config_state import ConfigState
from cdo_sdk_python.models.conflict_detection_state import ConflictDetectionState
from cdo_sdk_python.models.connectivity_state import ConnectivityState
from cdo_sdk_python.models.connector_type import ConnectorType
from cdo_sdk_python.models.device_role import DeviceRole
from cdo_sdk_python.models.entity_type import EntityType
from cdo_sdk_python.models.ftd_cluster_info import FtdClusterInfo
from cdo_sdk_python.models.ftd_ha_info import FtdHaInfo
from cdo_sdk_python.models.labels import Labels
from cdo_sdk_python.models.meraki_deployment_mode import MerakiDeploymentMode
from cdo_sdk_python.models.network import Network
from cdo_sdk_python.models.on_prem_fmc_info import OnPremFmcInfo
from cdo_sdk_python.models.sse_device_data import SseDeviceData
from cdo_sdk_python.models.state_machine_details import StateMachineDetails
from typing import Optional, Set
from typing_extensions import Self

class Device(BaseModel):
    """
    Device
    """ # noqa: E501
    uid: Optional[StrictStr] = Field(default=None, description="The unique identifier, represented as a UUID, of the device in SCC.")
    name: StrictStr = Field(description="The name of the device in CDO. Device names are unique in SCC.")
    device_type: EntityType = Field(alias="deviceType")
    connector_type: Optional[ConnectorType] = Field(default=None, alias="connectorType")
    connector_uid: Optional[StrictStr] = Field(default=None, description="The unique identifier, represented as a UUID, of the Secure Device Connector (SDC) that will be used to communicate with the device. This value is not required if the connector type selected is Cloud Connector (CDG)The name of the Secure Device Connector (SDC) that will be used to communicate with the device. This value is not required if the connector type selected is Cloud Connector (CDG).", alias="connectorUid")
    address: Optional[StrictStr] = Field(default=None, description="The address of the device, in `host:port` format. SCC connects to the device at this address.")
    device_role: Optional[DeviceRole] = Field(default=None, alias="deviceRole")
    serial: Optional[StrictStr] = Field(default=None, description="The serial number of the device. This is typically used for licensing, and is not the same as the chassis' serial number.")
    chassis_serial: Optional[StrictStr] = Field(default=None, description="The serial number on the chassis of the device (ASA-only). This is typically used to type up to Cisco SmartNet, and is not the same as the serial number.", alias="chassisSerial")
    software_version: Optional[StrictStr] = Field(default=None, description="The version of the software running on the device.", alias="softwareVersion")
    connectivity_state: Optional[ConnectivityState] = Field(default=None, alias="connectivityState")
    config_state: Optional[ConfigState] = Field(default=None, alias="configState")
    conflict_detection_state: Optional[ConflictDetectionState] = Field(default=None, alias="conflictDetectionState")
    notes: Optional[StrictStr] = Field(default=None, description="Free-form notes on the device.")
    asdm_version: Optional[StrictStr] = Field(default=None, description="(ASAs only) Version of the ASDM device manager running on the device.", alias="asdmVersion")
    asa_failover_mode: Optional[AsaFailoverMode] = Field(default=None, alias="asaFailoverMode")
    asa_failover_state: Optional[StrictStr] = Field(default=None, description="(High Availability ASAs only) Failover state of this device.", alias="asaFailoverState")
    asa_failover_mate: Optional[AsaFailoverMate] = Field(default=None, alias="asaFailoverMate")
    asa_license_entitlements: Optional[Dict[str, StrictStr]] = Field(default=None, description="(ASAs only) Map of ASA License entitlements.", alias="asaLicenseEntitlements")
    ftd_licenses: Optional[List[StrictStr]] = Field(default=None, description="(FTDs only) List of FTD License entitlements.", alias="ftdLicenses")
    snort_version: Optional[StrictStr] = Field(default=None, description="(FTDs only) List of FTD License entitlements.", alias="snortVersion")
    ftd_performance_tier: Optional[StrictStr] = Field(default=None, description="(FTDvs only) The FTDv supports performance-tiered licensing that provides different throughput levels and VPN connection limits based on deployment requirements. This field specifies the performance tier of the FTD.", alias="ftdPerformanceTier")
    redundancy_mode: Optional[StrictStr] = Field(default=None, description="The redundancy mode this firewall is running in. Note: for High Availability pairs and clusters, SCC represents all of the devices as part of one record.", alias="redundancyMode")
    cd_fmc_info: Optional[CdFmcInfo] = Field(default=None, alias="cdFmcInfo")
    sse_device_data: Optional[SseDeviceData] = Field(default=None, alias="sseDeviceData")
    on_prem_fmc_info: Optional[OnPremFmcInfo] = Field(default=None, alias="onPremFmcInfo")
    ftd_cluster_info: Optional[FtdClusterInfo] = Field(default=None, alias="ftdClusterInfo")
    ftd_ha_info: Optional[FtdHaInfo] = Field(default=None, alias="ftdHaInfo")
    meraki_deployment_mode: Optional[MerakiDeploymentMode] = Field(default=None, alias="merakiDeploymentMode")
    meraki_network: Optional[Network] = Field(default=None, alias="merakiNetwork")
    state: Optional[StrictStr] = Field(default=None, description="The device state.")
    state_machine_details: Optional[StateMachineDetails] = Field(default=None, alias="stateMachineDetails")
    labels: Optional[Labels] = None
    fmc_domain_uid: Optional[StrictStr] = Field(default=None, description="(FMC device managers only) The unique identifier, represented as a UUID, of the [FMC domain](https://www.cisco.com/c/en/us/td/docs/security/secure-firewall/management-center/admin/740/management-center-admin-74/system-domains.html).", alias="fmcDomainUid")
    uid_on_fmc: Optional[StrictStr] = Field(default=None, description="(cdFMC-managed FTDs only) The unique identifier, represented as a UUID, of the device on a cdFMC.", alias="uidOnFmc")
    model_number: Optional[StrictStr] = Field(default=None, description="The hardware, or virtualized hardware platform, that the device is running on (ASA-only). This field can be missing in the case of a partially onboarded device.", alias="modelNumber")
    __properties: ClassVar[List[str]] = ["uid", "name", "deviceType", "connectorType", "connectorUid", "address", "deviceRole", "serial", "chassisSerial", "softwareVersion", "connectivityState", "configState", "conflictDetectionState", "notes", "asdmVersion", "asaFailoverMode", "asaFailoverState", "asaFailoverMate", "asaLicenseEntitlements", "ftdLicenses", "snortVersion", "ftdPerformanceTier", "redundancyMode", "cdFmcInfo", "sseDeviceData", "onPremFmcInfo", "ftdClusterInfo", "ftdHaInfo", "merakiDeploymentMode", "merakiNetwork", "state", "stateMachineDetails", "labels", "fmcDomainUid", "uidOnFmc", "modelNumber"]

    @field_validator('redundancy_mode')
    def redundancy_mode_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['HA', 'CLUSTER', 'STANDALONE']):
            raise ValueError("must be one of enum values ('HA', 'CLUSTER', 'STANDALONE')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Device from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of asa_failover_mate
        if self.asa_failover_mate:
            _dict['asaFailoverMate'] = self.asa_failover_mate.to_dict()
        # override the default output from pydantic by calling `to_dict()` of cd_fmc_info
        if self.cd_fmc_info:
            _dict['cdFmcInfo'] = self.cd_fmc_info.to_dict()
        # override the default output from pydantic by calling `to_dict()` of sse_device_data
        if self.sse_device_data:
            _dict['sseDeviceData'] = self.sse_device_data.to_dict()
        # override the default output from pydantic by calling `to_dict()` of on_prem_fmc_info
        if self.on_prem_fmc_info:
            _dict['onPremFmcInfo'] = self.on_prem_fmc_info.to_dict()
        # override the default output from pydantic by calling `to_dict()` of ftd_cluster_info
        if self.ftd_cluster_info:
            _dict['ftdClusterInfo'] = self.ftd_cluster_info.to_dict()
        # override the default output from pydantic by calling `to_dict()` of ftd_ha_info
        if self.ftd_ha_info:
            _dict['ftdHaInfo'] = self.ftd_ha_info.to_dict()
        # override the default output from pydantic by calling `to_dict()` of meraki_network
        if self.meraki_network:
            _dict['merakiNetwork'] = self.meraki_network.to_dict()
        # override the default output from pydantic by calling `to_dict()` of state_machine_details
        if self.state_machine_details:
            _dict['stateMachineDetails'] = self.state_machine_details.to_dict()
        # override the default output from pydantic by calling `to_dict()` of labels
        if self.labels:
            _dict['labels'] = self.labels.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Device from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "uid": obj.get("uid"),
            "name": obj.get("name"),
            "deviceType": obj.get("deviceType"),
            "connectorType": obj.get("connectorType"),
            "connectorUid": obj.get("connectorUid"),
            "address": obj.get("address"),
            "deviceRole": obj.get("deviceRole"),
            "serial": obj.get("serial"),
            "chassisSerial": obj.get("chassisSerial"),
            "softwareVersion": obj.get("softwareVersion"),
            "connectivityState": obj.get("connectivityState"),
            "configState": obj.get("configState"),
            "conflictDetectionState": obj.get("conflictDetectionState"),
            "notes": obj.get("notes"),
            "asdmVersion": obj.get("asdmVersion"),
            "asaFailoverMode": obj.get("asaFailoverMode"),
            "asaFailoverState": obj.get("asaFailoverState"),
            "asaFailoverMate": AsaFailoverMate.from_dict(obj["asaFailoverMate"]) if obj.get("asaFailoverMate") is not None else None,
            "asaLicenseEntitlements": obj.get("asaLicenseEntitlements"),
            "ftdLicenses": obj.get("ftdLicenses"),
            "snortVersion": obj.get("snortVersion"),
            "ftdPerformanceTier": obj.get("ftdPerformanceTier"),
            "redundancyMode": obj.get("redundancyMode"),
            "cdFmcInfo": CdFmcInfo.from_dict(obj["cdFmcInfo"]) if obj.get("cdFmcInfo") is not None else None,
            "sseDeviceData": SseDeviceData.from_dict(obj["sseDeviceData"]) if obj.get("sseDeviceData") is not None else None,
            "onPremFmcInfo": OnPremFmcInfo.from_dict(obj["onPremFmcInfo"]) if obj.get("onPremFmcInfo") is not None else None,
            "ftdClusterInfo": FtdClusterInfo.from_dict(obj["ftdClusterInfo"]) if obj.get("ftdClusterInfo") is not None else None,
            "ftdHaInfo": FtdHaInfo.from_dict(obj["ftdHaInfo"]) if obj.get("ftdHaInfo") is not None else None,
            "merakiDeploymentMode": obj.get("merakiDeploymentMode"),
            "merakiNetwork": Network.from_dict(obj["merakiNetwork"]) if obj.get("merakiNetwork") is not None else None,
            "state": obj.get("state"),
            "stateMachineDetails": StateMachineDetails.from_dict(obj["stateMachineDetails"]) if obj.get("stateMachineDetails") is not None else None,
            "labels": Labels.from_dict(obj["labels"]) if obj.get("labels") is not None else None,
            "fmcDomainUid": obj.get("fmcDomainUid"),
            "uidOnFmc": obj.get("uidOnFmc"),
            "modelNumber": obj.get("modelNumber")
        })
        return _obj


