# coding: utf-8

"""
    Cisco Security Cloud Control API

    Use the documentation to explore the endpoints SCC has to offer

    The version of the OpenAPI document: 1.5.0
    Contact: cdo.tac@cisco.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class MemoryHealthMetrics(BaseModel):
    """
    The memory health metrics for the device.
    """ # noqa: E501
    lina_usage_avg: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Average memory utilisation by the LINA process. Expressed as a percentage value between 0 and 100.", alias="linaUsageAvg")
    snort_usage_avg: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Average memory usage by the Snort engine. Expressed as a percentage value between 0 and 100.", alias="snortUsageAvg")
    system_usage_avg: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Provides an overview of the overall memory usage by the FTD system, useful for monitoring system health and detecting potential resource bottlenecks. Expressed as a percentage value between 0 and 100.", alias="systemUsageAvg")
    __properties: ClassVar[List[str]] = ["linaUsageAvg", "snortUsageAvg", "systemUsageAvg"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of MemoryHealthMetrics from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of MemoryHealthMetrics from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "linaUsageAvg": obj.get("linaUsageAvg"),
            "snortUsageAvg": obj.get("snortUsageAvg"),
            "systemUsageAvg": obj.get("systemUsageAvg")
        })
        return _obj


