# coding: utf-8

"""
    Cisco Security Cloud Control API

    Use the documentation to explore the endpoints SCC has to offer

    The version of the OpenAPI document: 1.5.0
    Contact: cdo.tac@cisco.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from cdo_sdk_python.models.client_device import ClientDevice
from typing import Optional, Set
from typing_extensions import Self

class MfaEvent(BaseModel):
    """
    MfaEvent
    """ # noqa: E501
    uid: StrictStr = Field(description="The unique identifier, represented as a UUID, of the MFA event.")
    username: StrictStr = Field(description="The name of the user associated with the MFA event.")
    timestamp: Optional[datetime] = Field(default=None, description="The time (in UTC) at which the user logged in to the MFA event, represented using the RFC-3339 standard.")
    application: Optional[StrictStr] = Field(default=None, description="The name of the application associated with the MFA event.")
    result: Optional[StrictStr] = Field(default=None, description="The result of the MFA event.")
    reason: Optional[StrictStr] = Field(default=None, description="The reason for the result of the MFA event. When the `result` is `DENIED`, this field contains information on why the MFA event failed.")
    second_factor: Optional[StrictStr] = Field(default=None, description="The second factor used for the MFA event.", alias="secondFactor")
    client_device: Optional[ClientDevice] = Field(default=None, alias="clientDevice")
    __properties: ClassVar[List[str]] = ["uid", "username", "timestamp", "application", "result", "reason", "secondFactor", "clientDevice"]

    @field_validator('result')
    def result_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['DENIED', 'GRANTED']):
            raise ValueError("must be one of enum values ('DENIED', 'GRANTED')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of MfaEvent from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of client_device
        if self.client_device:
            _dict['clientDevice'] = self.client_device.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of MfaEvent from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "uid": obj.get("uid"),
            "username": obj.get("username"),
            "timestamp": obj.get("timestamp"),
            "application": obj.get("application"),
            "result": obj.get("result"),
            "reason": obj.get("reason"),
            "secondFactor": obj.get("secondFactor"),
            "clientDevice": ClientDevice.from_dict(obj["clientDevice"]) if obj.get("clientDevice") is not None else None
        })
        return _obj


