# coding: utf-8

"""
    CDO API

    Use the documentation to explore the endpoints CDO has to offer

    The version of the OpenAPI document: 1.3.0
    Contact: cdo.tac@cisco.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class InterfaceHealthMetrics(BaseModel):
    """
    The interface health metrics for the device.
    """ # noqa: E501
    status: Optional[StrictStr] = None
    buffer_underruns_avg: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="bufferUnderrunsAvg")
    buffer_overruns_avg: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="bufferOverrunsAvg")
    drop_packets_avg: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="dropPacketsAvg")
    l2_decode_drops_avg: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="l2DecodeDropsAvg")
    oper_status: Optional[StrictStr] = Field(default=None, alias="operStatus")
    input_errors_avg: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="inputErrorsAvg")
    output_errors_avg: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="outputErrorsAvg")
    input_bytes: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="inputBytes")
    output_bytes: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="outputBytes")
    input_packet_size_avg: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="inputPacketSizeAvg")
    output_packet_size_avg: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="outputPacketSizeAvg")
    duplex_mode: Optional[StrictStr] = Field(default=None, alias="duplexMode")
    interface_type: Optional[StrictStr] = Field(default=None, alias="interfaceType")
    interface: Optional[StrictStr] = None
    interface_name: Optional[StrictStr] = Field(default=None, alias="interfaceName")
    __properties: ClassVar[List[str]] = ["status", "bufferUnderrunsAvg", "bufferOverrunsAvg", "dropPacketsAvg", "l2DecodeDropsAvg", "operStatus", "inputErrorsAvg", "outputErrorsAvg", "inputBytes", "outputBytes", "inputPacketSizeAvg", "outputPacketSizeAvg", "duplexMode", "interfaceType", "interface", "interfaceName"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of InterfaceHealthMetrics from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of InterfaceHealthMetrics from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "status": obj.get("status"),
            "bufferUnderrunsAvg": obj.get("bufferUnderrunsAvg"),
            "bufferOverrunsAvg": obj.get("bufferOverrunsAvg"),
            "dropPacketsAvg": obj.get("dropPacketsAvg"),
            "l2DecodeDropsAvg": obj.get("l2DecodeDropsAvg"),
            "operStatus": obj.get("operStatus"),
            "inputErrorsAvg": obj.get("inputErrorsAvg"),
            "outputErrorsAvg": obj.get("outputErrorsAvg"),
            "inputBytes": obj.get("inputBytes"),
            "outputBytes": obj.get("outputBytes"),
            "inputPacketSizeAvg": obj.get("inputPacketSizeAvg"),
            "outputPacketSizeAvg": obj.get("outputPacketSizeAvg"),
            "duplexMode": obj.get("duplexMode"),
            "interfaceType": obj.get("interfaceType"),
            "interface": obj.get("interface"),
            "interfaceName": obj.get("interfaceName")
        })
        return _obj


