# coding: utf-8

"""
    Cisco Security Cloud Control API

    Use the documentation to explore the endpoints Security Cloud Control has to offer

    The version of the OpenAPI document: 1.5.0
    Contact: cdo.tac@cisco.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from cdo_sdk_python.models.application_context import ApplicationContext
from cdo_sdk_python.models.http_status_code import HttpStatusCode
from cdo_sdk_python.models.servlet_context import ServletContext
from typing import Optional, Set
from typing_extensions import Self

class RedirectView(BaseModel):
    """
    RedirectView
    """ # noqa: E501
    application_context: Optional[ApplicationContext] = Field(default=None, alias="applicationContext")
    servlet_context: Optional[ServletContext] = Field(default=None, alias="servletContext")
    content_type: Optional[StrictStr] = Field(default=None, alias="contentType")
    request_context_attribute: Optional[StrictStr] = Field(default=None, alias="requestContextAttribute")
    static_attributes: Optional[Dict[str, Dict[str, Any]]] = Field(default=None, alias="staticAttributes")
    expose_path_variables: Optional[StrictBool] = Field(default=None, alias="exposePathVariables")
    expose_context_beans_as_attributes: Optional[StrictBool] = Field(default=None, alias="exposeContextBeansAsAttributes")
    exposed_context_bean_names: Optional[List[StrictStr]] = Field(default=None, alias="exposedContextBeanNames")
    bean_name: Optional[StrictStr] = Field(default=None, alias="beanName")
    url: Optional[StrictStr] = None
    context_relative: Optional[StrictBool] = Field(default=None, alias="contextRelative")
    http10_compatible: Optional[StrictBool] = Field(default=None, alias="http10Compatible")
    expose_model_attributes: Optional[StrictBool] = Field(default=None, alias="exposeModelAttributes")
    encoding_scheme: Optional[StrictStr] = Field(default=None, alias="encodingScheme")
    status_code: Optional[HttpStatusCode] = Field(default=None, alias="statusCode")
    expand_uri_template_variables: Optional[StrictBool] = Field(default=None, alias="expandUriTemplateVariables")
    propagate_query_params: Optional[StrictBool] = Field(default=None, alias="propagateQueryParams")
    hosts: Optional[List[StrictStr]] = None
    propagate_query_properties: Optional[StrictBool] = Field(default=None, alias="propagateQueryProperties")
    redirect_view: Optional[StrictBool] = Field(default=None, alias="redirectView")
    attributes_map: Optional[Dict[str, Dict[str, Any]]] = Field(default=None, alias="attributesMap")
    attributes_csv: Optional[StrictStr] = Field(default=None, alias="attributesCSV")
    attributes: Optional[Dict[str, StrictStr]] = None
    __properties: ClassVar[List[str]] = ["applicationContext", "servletContext", "contentType", "requestContextAttribute", "staticAttributes", "exposePathVariables", "exposeContextBeansAsAttributes", "exposedContextBeanNames", "beanName", "url", "contextRelative", "http10Compatible", "exposeModelAttributes", "encodingScheme", "statusCode", "expandUriTemplateVariables", "propagateQueryParams", "hosts", "propagateQueryProperties", "redirectView", "attributesMap", "attributesCSV", "attributes"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RedirectView from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of application_context
        if self.application_context:
            _dict['applicationContext'] = self.application_context.to_dict()
        # override the default output from pydantic by calling `to_dict()` of servlet_context
        if self.servlet_context:
            _dict['servletContext'] = self.servlet_context.to_dict()
        # override the default output from pydantic by calling `to_dict()` of status_code
        if self.status_code:
            _dict['statusCode'] = self.status_code.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RedirectView from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "applicationContext": ApplicationContext.from_dict(obj["applicationContext"]) if obj.get("applicationContext") is not None else None,
            "servletContext": ServletContext.from_dict(obj["servletContext"]) if obj.get("servletContext") is not None else None,
            "contentType": obj.get("contentType"),
            "requestContextAttribute": obj.get("requestContextAttribute"),
            "staticAttributes": obj.get("staticAttributes"),
            "exposePathVariables": obj.get("exposePathVariables"),
            "exposeContextBeansAsAttributes": obj.get("exposeContextBeansAsAttributes"),
            "exposedContextBeanNames": obj.get("exposedContextBeanNames"),
            "beanName": obj.get("beanName"),
            "url": obj.get("url"),
            "contextRelative": obj.get("contextRelative"),
            "http10Compatible": obj.get("http10Compatible"),
            "exposeModelAttributes": obj.get("exposeModelAttributes"),
            "encodingScheme": obj.get("encodingScheme"),
            "statusCode": HttpStatusCode.from_dict(obj["statusCode"]) if obj.get("statusCode") is not None else None,
            "expandUriTemplateVariables": obj.get("expandUriTemplateVariables"),
            "propagateQueryParams": obj.get("propagateQueryParams"),
            "hosts": obj.get("hosts"),
            "propagateQueryProperties": obj.get("propagateQueryProperties"),
            "redirectView": obj.get("redirectView"),
            "attributesMap": obj.get("attributesMap"),
            "attributesCSV": obj.get("attributesCSV"),
            "attributes": obj.get("attributes")
        })
        return _obj


