# coding: utf-8

"""
    Cisco Security Cloud Control API

    Use the documentation to explore the endpoints Security Cloud Control has to offer

    The version of the OpenAPI document: 1.5.0
    Contact: cdo.tac@cisco.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class MspCreateTenantInput(BaseModel):
    """
    MspCreateTenantInput
    """ # noqa: E501
    display_name: Optional[StrictStr] = Field(default=None, description="A human-readable display name of the tenant to create. Use this field only if you want the display name to be different from the name of the tenant.", alias="displayName")
    sales_order_number: Optional[StrictStr] = Field(default=None, description="The sales order number. If this value is not provided, the tenant will be created as a trial tenant.", alias="salesOrderNumber")
    tenant_name: Annotated[str, Field(strict=True)] = Field(description="The name of the tenant to create. The tenant name can only contain alphabets, numbers, -, and _, and is limited to 50 characters.", alias="tenantName")
    __properties: ClassVar[List[str]] = ["displayName", "salesOrderNumber", "tenantName"]

    @field_validator('tenant_name')
    def tenant_name_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"[a-zA-Z0-9-_]{1,50}", value):
            raise ValueError(r"must validate the regular expression /[a-zA-Z0-9-_]{1,50}/")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of MspCreateTenantInput from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of MspCreateTenantInput from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "displayName": obj.get("displayName"),
            "salesOrderNumber": obj.get("salesOrderNumber"),
            "tenantName": obj.get("tenantName")
        })
        return _obj


