# coding: utf-8

"""
    Cisco Security Cloud Control API

    Use the documentation to explore the endpoints Security Cloud Control has to offer

    The version of the OpenAPI document: 1.5.0
    Contact: cdo.tac@cisco.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from cdo-sdk-python.models.asa_failover_mate import AsaFailoverMate
from cdo-sdk-python.models.asa_failover_mode import AsaFailoverMode
from cdo-sdk-python.models.cd_fmc_info import CdFmcInfo
from cdo-sdk-python.models.config_state import ConfigState
from cdo-sdk-python.models.conflict_detection_state import ConflictDetectionState
from cdo-sdk-python.models.connectivity_state import ConnectivityState
from cdo-sdk-python.models.connector_type import ConnectorType
from cdo-sdk-python.models.device_role import DeviceRole
from cdo-sdk-python.models.entity_type import EntityType
from cdo-sdk-python.models.fmc_access_policy_reference import FmcAccessPolicyReference
from cdo-sdk-python.models.fmc_device_record import FmcDeviceRecord
from cdo-sdk-python.models.ftd_cluster_info import FtdClusterInfo
from cdo-sdk-python.models.ftd_ha_info import FtdHaInfo
from cdo-sdk-python.models.labels import Labels
from cdo-sdk-python.models.meraki_deployment_mode import MerakiDeploymentMode
from cdo-sdk-python.models.network import Network
from cdo-sdk-python.models.on_prem_fmc_info import OnPremFmcInfo
from cdo-sdk-python.models.sse_device_data import SseDeviceData
from cdo-sdk-python.models.state_machine_details import StateMachineDetails
from cdo-sdk-python.models.universal_ztna_settings import UniversalZtnaSettings
from typing import Optional, Set
from typing_extensions import Self

class Device(BaseModel):
    """
    Device
    """ # noqa: E501
    address: Optional[StrictStr] = Field(default=None, description="The address of the device, in `host:port` format. Security Cloud Control connects to the device at this address.")
    asa_failover_mate: Optional[AsaFailoverMate] = Field(default=None, alias="asaFailoverMate")
    asa_failover_mode: Optional[AsaFailoverMode] = Field(default=None, alias="asaFailoverMode")
    asa_failover_state: Optional[StrictStr] = Field(default=None, description="(High Availability ASAs only) Failover state of this device.", alias="asaFailoverState")
    asa_license_entitlements: Optional[Dict[str, StrictStr]] = Field(default=None, description="(ASAs only) Map of ASA License entitlements.", alias="asaLicenseEntitlements")
    asdm_version: Optional[StrictStr] = Field(default=None, description="(ASAs only) Version of the ASDM device manager running on the device.", alias="asdmVersion")
    cd_fmc_info: Optional[CdFmcInfo] = Field(default=None, alias="cdFmcInfo")
    chassis_serial: Optional[StrictStr] = Field(default=None, description="The serial number on the chassis of the device (ASA-only). This is typically used to type up to Cisco SmartNet, and is not the same as the serial number.", alias="chassisSerial")
    config_state: Optional[ConfigState] = Field(default=None, alias="configState")
    conflict_detection_state: Optional[ConflictDetectionState] = Field(default=None, alias="conflictDetectionState")
    connectivity_state: Optional[ConnectivityState] = Field(default=None, alias="connectivityState")
    connector_type: Optional[ConnectorType] = Field(default=None, alias="connectorType")
    connector_uid: Optional[StrictStr] = Field(default=None, description="The unique identifier, represented as a UUID, of the Secure Device Connector (SDC) that will be used to communicate with the device. This value is not required if the connector type selected is Cloud Connector (CDG)The name of the Secure Device Connector (SDC) that will be used to communicate with the device. This value is not required if the connector type selected is Cloud Connector (CDG).", alias="connectorUid")
    device_record_on_fmc: Optional[FmcDeviceRecord] = Field(default=None, alias="deviceRecordOnFmc")
    device_role: Optional[DeviceRole] = Field(default=None, alias="deviceRole")
    device_roles: Optional[List[DeviceRole]] = Field(default=None, description="The roles that this device performs on the network.", alias="deviceRoles")
    device_type: EntityType = Field(alias="deviceType")
    fmc_access_policy: Optional[FmcAccessPolicyReference] = Field(default=None, alias="fmcAccessPolicy")
    fmc_domain_uid: Optional[StrictStr] = Field(default=None, description="(FMC device managers only) The unique identifier, represented as a UUID, of the [FMC domain](https://www.cisco.com/c/en/us/td/docs/security/secure-firewall/management-center/admin/740/management-center-admin-74/system-domains.html).", alias="fmcDomainUid")
    ftd_cluster_info: Optional[FtdClusterInfo] = Field(default=None, alias="ftdClusterInfo")
    ftd_ha_info: Optional[FtdHaInfo] = Field(default=None, alias="ftdHaInfo")
    ftd_licenses: Optional[List[StrictStr]] = Field(default=None, description="(FTDs only) List of FTD License entitlements.", alias="ftdLicenses")
    ftd_performance_tier: Optional[StrictStr] = Field(default=None, description="(FTDvs only) The FTDv supports performance-tiered licensing that provides different throughput levels and VPN connection limits based on deployment requirements. This field specifies the performance tier of the FTD.", alias="ftdPerformanceTier")
    hardware_model: Optional[StrictStr] = Field(default=None, description="(ASAs, FDM-managed FTDs, and FMC-managed FTDs only) The hardware model of the device", alias="hardwareModel")
    labels: Optional[Labels] = None
    meraki_deployment_mode: Optional[MerakiDeploymentMode] = Field(default=None, alias="merakiDeploymentMode")
    meraki_network: Optional[Network] = Field(default=None, alias="merakiNetwork")
    model_number: Optional[StrictStr] = Field(default=None, description="The hardware, or virtualized hardware platform, that the device is running on (ASA-only). This field can be missing in the case of a partially onboarded device.", alias="modelNumber")
    name: StrictStr = Field(description="The name of the device in CDO. Device names are unique in Security Cloud Control.")
    notes: Optional[StrictStr] = Field(default=None, description="Free-form notes on the device.")
    on_prem_fmc_info: Optional[OnPremFmcInfo] = Field(default=None, alias="onPremFmcInfo")
    redundancy_mode: Optional[StrictStr] = Field(default=None, description="The redundancy mode this firewall is running in. Note: for High Availability pairs and clusters, Security Cloud Control represents all of the devices as part of one record.", alias="redundancyMode")
    serial: Optional[StrictStr] = Field(default=None, description="The serial number of the device. This is typically used for licensing, and is not the same as the chassis' serial number.")
    snort_version: Optional[StrictStr] = Field(default=None, description="(FTDs only) List of FTD License entitlements.", alias="snortVersion")
    software_version: Optional[StrictStr] = Field(default=None, description="The version of the software running on the device.", alias="softwareVersion")
    sse_device_data: Optional[SseDeviceData] = Field(default=None, alias="sseDeviceData")
    state: Optional[StrictStr] = Field(default=None, description="The device state.")
    state_machine_details: Optional[StateMachineDetails] = Field(default=None, alias="stateMachineDetails")
    uid: Optional[StrictStr] = Field(default=None, description="The unique identifier, represented as a UUID, of the device in Security Cloud Control.")
    uid_on_fmc: Optional[StrictStr] = Field(default=None, description="(FMC-managed FTDs only) The unique identifier, represented as a UUID, of the device on a cdFMC. This field is deprecated. Please see `cdFmcInfo.deviceRecordOnFmc` or `onPremFmcInfo.deviceRecordOnFmc`.", alias="uidOnFmc")
    universal_ztna_settings: Optional[UniversalZtnaSettings] = Field(default=None, alias="universalZtnaSettings")
    ztp_onboarding_job_id: Optional[StrictStr] = Field(default=None, description="The unique identifier, represented as a UUID, for an internal job that orchestrates the onboarding of devices through Zero-Touch Provisioning. This applies to devices managed by both on-premises and Cloud-delivered FMC.", alias="ztpOnboardingJobId")
    __properties: ClassVar[List[str]] = ["address", "asaFailoverMate", "asaFailoverMode", "asaFailoverState", "asaLicenseEntitlements", "asdmVersion", "cdFmcInfo", "chassisSerial", "configState", "conflictDetectionState", "connectivityState", "connectorType", "connectorUid", "deviceRecordOnFmc", "deviceRole", "deviceRoles", "deviceType", "fmcAccessPolicy", "fmcDomainUid", "ftdClusterInfo", "ftdHaInfo", "ftdLicenses", "ftdPerformanceTier", "hardwareModel", "labels", "merakiDeploymentMode", "merakiNetwork", "modelNumber", "name", "notes", "onPremFmcInfo", "redundancyMode", "serial", "snortVersion", "softwareVersion", "sseDeviceData", "state", "stateMachineDetails", "uid", "uidOnFmc", "universalZtnaSettings", "ztpOnboardingJobId"]

    @field_validator('redundancy_mode')
    def redundancy_mode_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['HA', 'CLUSTER', 'STANDALONE']):
            raise ValueError("must be one of enum values ('HA', 'CLUSTER', 'STANDALONE')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Device from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of asa_failover_mate
        if self.asa_failover_mate:
            _dict['asaFailoverMate'] = self.asa_failover_mate.to_dict()
        # override the default output from pydantic by calling `to_dict()` of cd_fmc_info
        if self.cd_fmc_info:
            _dict['cdFmcInfo'] = self.cd_fmc_info.to_dict()
        # override the default output from pydantic by calling `to_dict()` of device_record_on_fmc
        if self.device_record_on_fmc:
            _dict['deviceRecordOnFmc'] = self.device_record_on_fmc.to_dict()
        # override the default output from pydantic by calling `to_dict()` of fmc_access_policy
        if self.fmc_access_policy:
            _dict['fmcAccessPolicy'] = self.fmc_access_policy.to_dict()
        # override the default output from pydantic by calling `to_dict()` of ftd_cluster_info
        if self.ftd_cluster_info:
            _dict['ftdClusterInfo'] = self.ftd_cluster_info.to_dict()
        # override the default output from pydantic by calling `to_dict()` of ftd_ha_info
        if self.ftd_ha_info:
            _dict['ftdHaInfo'] = self.ftd_ha_info.to_dict()
        # override the default output from pydantic by calling `to_dict()` of labels
        if self.labels:
            _dict['labels'] = self.labels.to_dict()
        # override the default output from pydantic by calling `to_dict()` of meraki_network
        if self.meraki_network:
            _dict['merakiNetwork'] = self.meraki_network.to_dict()
        # override the default output from pydantic by calling `to_dict()` of on_prem_fmc_info
        if self.on_prem_fmc_info:
            _dict['onPremFmcInfo'] = self.on_prem_fmc_info.to_dict()
        # override the default output from pydantic by calling `to_dict()` of sse_device_data
        if self.sse_device_data:
            _dict['sseDeviceData'] = self.sse_device_data.to_dict()
        # override the default output from pydantic by calling `to_dict()` of state_machine_details
        if self.state_machine_details:
            _dict['stateMachineDetails'] = self.state_machine_details.to_dict()
        # override the default output from pydantic by calling `to_dict()` of universal_ztna_settings
        if self.universal_ztna_settings:
            _dict['universalZtnaSettings'] = self.universal_ztna_settings.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Device from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "address": obj.get("address"),
            "asaFailoverMate": AsaFailoverMate.from_dict(obj["asaFailoverMate"]) if obj.get("asaFailoverMate") is not None else None,
            "asaFailoverMode": obj.get("asaFailoverMode"),
            "asaFailoverState": obj.get("asaFailoverState"),
            "asaLicenseEntitlements": obj.get("asaLicenseEntitlements"),
            "asdmVersion": obj.get("asdmVersion"),
            "cdFmcInfo": CdFmcInfo.from_dict(obj["cdFmcInfo"]) if obj.get("cdFmcInfo") is not None else None,
            "chassisSerial": obj.get("chassisSerial"),
            "configState": obj.get("configState"),
            "conflictDetectionState": obj.get("conflictDetectionState"),
            "connectivityState": obj.get("connectivityState"),
            "connectorType": obj.get("connectorType"),
            "connectorUid": obj.get("connectorUid"),
            "deviceRecordOnFmc": FmcDeviceRecord.from_dict(obj["deviceRecordOnFmc"]) if obj.get("deviceRecordOnFmc") is not None else None,
            "deviceRole": obj.get("deviceRole"),
            "deviceRoles": obj.get("deviceRoles"),
            "deviceType": obj.get("deviceType"),
            "fmcAccessPolicy": FmcAccessPolicyReference.from_dict(obj["fmcAccessPolicy"]) if obj.get("fmcAccessPolicy") is not None else None,
            "fmcDomainUid": obj.get("fmcDomainUid"),
            "ftdClusterInfo": FtdClusterInfo.from_dict(obj["ftdClusterInfo"]) if obj.get("ftdClusterInfo") is not None else None,
            "ftdHaInfo": FtdHaInfo.from_dict(obj["ftdHaInfo"]) if obj.get("ftdHaInfo") is not None else None,
            "ftdLicenses": obj.get("ftdLicenses"),
            "ftdPerformanceTier": obj.get("ftdPerformanceTier"),
            "hardwareModel": obj.get("hardwareModel"),
            "labels": Labels.from_dict(obj["labels"]) if obj.get("labels") is not None else None,
            "merakiDeploymentMode": obj.get("merakiDeploymentMode"),
            "merakiNetwork": Network.from_dict(obj["merakiNetwork"]) if obj.get("merakiNetwork") is not None else None,
            "modelNumber": obj.get("modelNumber"),
            "name": obj.get("name"),
            "notes": obj.get("notes"),
            "onPremFmcInfo": OnPremFmcInfo.from_dict(obj["onPremFmcInfo"]) if obj.get("onPremFmcInfo") is not None else None,
            "redundancyMode": obj.get("redundancyMode"),
            "serial": obj.get("serial"),
            "snortVersion": obj.get("snortVersion"),
            "softwareVersion": obj.get("softwareVersion"),
            "sseDeviceData": SseDeviceData.from_dict(obj["sseDeviceData"]) if obj.get("sseDeviceData") is not None else None,
            "state": obj.get("state"),
            "stateMachineDetails": StateMachineDetails.from_dict(obj["stateMachineDetails"]) if obj.get("stateMachineDetails") is not None else None,
            "uid": obj.get("uid"),
            "uidOnFmc": obj.get("uidOnFmc"),
            "universalZtnaSettings": UniversalZtnaSettings.from_dict(obj["universalZtnaSettings"]) if obj.get("universalZtnaSettings") is not None else None,
            "ztpOnboardingJobId": obj.get("ztpOnboardingJobId")
        })
        return _obj


