# coding: utf-8

"""
    Cisco Security Cloud Control API

    Use the documentation to explore the endpoints Security Cloud Control has to offer

    The version of the OpenAPI document: 1.5.0
    Contact: cdo.tac@cisco.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from cdo_sdk_python.models.fmc_object_override import FmcObjectOverride
from cdo_sdk_python.models.fmc_template_variable import FmcTemplateVariable
from typing import Optional, Set
from typing_extensions import Self

class ZtpOnboardingTemplateConfiguration(BaseModel):
    """
    Specify the template to apply to this device. If this field is specified, the 'fmcAccessPolicyUid' field must remain unspecified. Note: If both 'fmcAccessPolicyUid' and 'template' fields are unspecified, the operation will fail.
    """ # noqa: E501
    object_overrides: Optional[List[FmcObjectOverride]] = Field(default=None, description="Specify a list of objects to override. All objects that have been marked as overridable in the template must be defined here. Note: Any overrides defined here that are not present in the template configuration will be ignored.", alias="objectOverrides")
    template_variables: Optional[List[FmcTemplateVariable]] = Field(default=None, description="Specify the list of template variables configured on the template. All required template variables must be defined here, and should have values valid for the type of the variable. Any invalid input will result in the template not being applied to the device upon onboarding. Note: Any variables defined here that are not present in the template will be ignored.", alias="templateVariables")
    uid: StrictStr = Field(description="Specify the unique identifier, represented as a UUID, of the template to apply to the onboarded device.")
    __properties: ClassVar[List[str]] = ["objectOverrides", "templateVariables", "uid"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ZtpOnboardingTemplateConfiguration from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in object_overrides (list)
        _items = []
        if self.object_overrides:
            for _item in self.object_overrides:
                if _item:
                    _items.append(_item.to_dict())
            _dict['objectOverrides'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in template_variables (list)
        _items = []
        if self.template_variables:
            for _item in self.template_variables:
                if _item:
                    _items.append(_item.to_dict())
            _dict['templateVariables'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ZtpOnboardingTemplateConfiguration from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "objectOverrides": [FmcObjectOverride.from_dict(_item) for _item in obj["objectOverrides"]] if obj.get("objectOverrides") is not None else None,
            "templateVariables": [FmcTemplateVariable.from_dict(_item) for _item in obj["templateVariables"]] if obj.get("templateVariables") is not None else None,
            "uid": obj.get("uid")
        })
        return _obj


