# coding: utf-8

"""
    Cisco Security Cloud Control API

    Use the documentation to explore the endpoints Security Cloud Control has to offer

    The version of the OpenAPI document: 1.5.0
    Contact: cdo.tac@cisco.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class Cause(BaseModel):
    """
    Represents a specific cause for an access rule issue.
    """ # noqa: E501
    cause_types: Optional[List[StrictStr]] = Field(default=None, description="A set of cause types for the issue.", alias="causeTypes")
    causing_rule: Optional[StrictStr] = Field(default=None, description="The rule that is causing the issue.", alias="causingRule")
    causing_rule_idx: Optional[StrictInt] = Field(default=None, description="The index of the causing rule.", alias="causingRuleIdx")
    __properties: ClassVar[List[str]] = ["causeTypes", "causingRule", "causingRuleIdx"]

    @field_validator('cause_types')
    def cause_types_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        for i in value:
            if i not in set(['SHADOWED_BY_NETWORK_ADDRESS', 'SHADOWED_BY_PORT', 'SHADOWED_BY_ICMP', 'SHADOWED_BY_ACTION', 'UNKNOWN']):
                raise ValueError("each list item must be one of ('SHADOWED_BY_NETWORK_ADDRESS', 'SHADOWED_BY_PORT', 'SHADOWED_BY_ICMP', 'SHADOWED_BY_ACTION', 'UNKNOWN')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Cause from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Cause from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "causeTypes": obj.get("causeTypes"),
            "causingRule": obj.get("causingRule"),
            "causingRuleIdx": obj.get("causingRuleIdx")
        })
        return _obj


