# coding: utf-8

"""
    Cisco Security Cloud Control API

    Use the documentation to explore the endpoints Security Cloud Control has to offer

    The version of the OpenAPI document: 1.9.0
    Contact: cdo.tac@cisco.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from cdo_sdk_python.models.issues_dto import IssuesDto
from cdo_sdk_python.models.reference_info import ReferenceInfo
from cdo_sdk_python.models.shared_object_value import SharedObjectValue
from cdo_sdk_python.models.target import Target
from typing import Optional, Set
from typing_extensions import Self

class ObjectResponse(BaseModel):
    """
    ObjectResponse
    """ # noqa: E501
    description: Optional[StrictStr] = Field(default=None, description="The human-readable description of the object")
    elements: Optional[List[StrictStr]] = Field(default=None, description="A flattened list of the content value of the object")
    issues: Optional[IssuesDto] = None
    labels: Optional[List[StrictStr]] = Field(default=None, description="The labels for the object")
    name: Optional[StrictStr] = Field(default=None, description="The name of the object")
    references_info_from_default_and_overrides: Optional[List[ReferenceInfo]] = Field(default=None, description="List of objects referenced in the default content or in any of the overrides.", alias="referencesInfoFromDefaultAndOverrides")
    tags: Optional[Dict[str, List[StrictStr]]] = Field(default=None, description="The tags for the object")
    targets: Optional[List[Target]] = Field(default=None, description="Set of targets that contain the object. A target can be, for example, a device, service, or a shared policy (Ruleset).")
    uid: Optional[StrictStr] = Field(default=None, description="The unique identifier of the object")
    value: Optional[SharedObjectValue] = None
    __properties: ClassVar[List[str]] = ["description", "elements", "issues", "labels", "name", "referencesInfoFromDefaultAndOverrides", "tags", "targets", "uid", "value"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ObjectResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of issues
        if self.issues:
            _dict['issues'] = self.issues.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in references_info_from_default_and_overrides (list)
        _items = []
        if self.references_info_from_default_and_overrides:
            for _item in self.references_info_from_default_and_overrides:
                if _item:
                    _items.append(_item.to_dict())
            _dict['referencesInfoFromDefaultAndOverrides'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in targets (list)
        _items = []
        if self.targets:
            for _item in self.targets:
                if _item:
                    _items.append(_item.to_dict())
            _dict['targets'] = _items
        # override the default output from pydantic by calling `to_dict()` of value
        if self.value:
            _dict['value'] = self.value.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ObjectResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "description": obj.get("description"),
            "elements": obj.get("elements"),
            "issues": IssuesDto.from_dict(obj["issues"]) if obj.get("issues") is not None else None,
            "labels": obj.get("labels"),
            "name": obj.get("name"),
            "referencesInfoFromDefaultAndOverrides": [ReferenceInfo.from_dict(_item) for _item in obj["referencesInfoFromDefaultAndOverrides"]] if obj.get("referencesInfoFromDefaultAndOverrides") is not None else None,
            "tags": obj.get("tags"),
            "targets": [Target.from_dict(_item) for _item in obj["targets"]] if obj.get("targets") is not None else None,
            "uid": obj.get("uid"),
            "value": SharedObjectValue.from_dict(obj["value"]) if obj.get("value") is not None else None
        })
        return _obj


