# coding: utf-8

"""
    Cisco Security Cloud Control API

    Use the documentation to explore the endpoints Security Cloud Control has to offer

    The version of the OpenAPI document: 1.9.0
    Contact: cdo.tac@cisco.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from cdo_sdk_python.models.access_rule_details_content import AccessRuleDetailsContent
from cdo_sdk_python.models.log_settings import LogSettings
from typing import Optional, Set
from typing_extensions import Self

class AccessRuleCreateInput(BaseModel):
    """
    AccessRuleCreateInput
    """ # noqa: E501
    access_group_uid: StrictStr = Field(description="The unique identifier, represented as a UUID, of the Access Group associated with the Access Rule.", alias="accessGroupUid")
    active_rule: Optional[StrictBool] = Field(default=None, alias="activeRule")
    destination_dynamic_object: Optional[AccessRuleDetailsContent] = Field(default=None, alias="destinationDynamicObject")
    destination_network: Optional[AccessRuleDetailsContent] = Field(default=None, alias="destinationNetwork")
    destination_port: Optional[AccessRuleDetailsContent] = Field(default=None, alias="destinationPort")
    entity_uid: StrictStr = Field(description="The unique identifier, represented as a UUID, of the device/manager associated with the Access Rule. Points to the shared Access Group in the case of a shared Access Rule being created.", alias="entityUid")
    index: StrictInt = Field(description="The position of the Access Rule in the orded list of rules in an Access Group.")
    log_settings: Optional[LogSettings] = Field(default=None, alias="logSettings")
    protocol: Optional[AccessRuleDetailsContent] = None
    remark: Optional[StrictStr] = Field(default=None, description="A human-readable remark. This is typically used to describe the intentions of the access rule.")
    rule_action: Optional[StrictStr] = Field(default=None, description="The rule's action.", alias="ruleAction")
    rule_time_range: Optional[AccessRuleDetailsContent] = Field(default=None, alias="ruleTimeRange")
    source_dynamic_object: Optional[AccessRuleDetailsContent] = Field(default=None, alias="sourceDynamicObject")
    source_network: Optional[AccessRuleDetailsContent] = Field(default=None, alias="sourceNetwork")
    source_port: Optional[AccessRuleDetailsContent] = Field(default=None, alias="sourcePort")
    __properties: ClassVar[List[str]] = ["accessGroupUid", "activeRule", "destinationDynamicObject", "destinationNetwork", "destinationPort", "entityUid", "index", "logSettings", "protocol", "remark", "ruleAction", "ruleTimeRange", "sourceDynamicObject", "sourceNetwork", "sourcePort"]

    @field_validator('rule_action')
    def rule_action_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['PERMIT', 'DENY']):
            raise ValueError("must be one of enum values ('PERMIT', 'DENY')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AccessRuleCreateInput from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of destination_dynamic_object
        if self.destination_dynamic_object:
            _dict['destinationDynamicObject'] = self.destination_dynamic_object.to_dict()
        # override the default output from pydantic by calling `to_dict()` of destination_network
        if self.destination_network:
            _dict['destinationNetwork'] = self.destination_network.to_dict()
        # override the default output from pydantic by calling `to_dict()` of destination_port
        if self.destination_port:
            _dict['destinationPort'] = self.destination_port.to_dict()
        # override the default output from pydantic by calling `to_dict()` of log_settings
        if self.log_settings:
            _dict['logSettings'] = self.log_settings.to_dict()
        # override the default output from pydantic by calling `to_dict()` of protocol
        if self.protocol:
            _dict['protocol'] = self.protocol.to_dict()
        # override the default output from pydantic by calling `to_dict()` of rule_time_range
        if self.rule_time_range:
            _dict['ruleTimeRange'] = self.rule_time_range.to_dict()
        # override the default output from pydantic by calling `to_dict()` of source_dynamic_object
        if self.source_dynamic_object:
            _dict['sourceDynamicObject'] = self.source_dynamic_object.to_dict()
        # override the default output from pydantic by calling `to_dict()` of source_network
        if self.source_network:
            _dict['sourceNetwork'] = self.source_network.to_dict()
        # override the default output from pydantic by calling `to_dict()` of source_port
        if self.source_port:
            _dict['sourcePort'] = self.source_port.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AccessRuleCreateInput from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "accessGroupUid": obj.get("accessGroupUid"),
            "activeRule": obj.get("activeRule"),
            "destinationDynamicObject": AccessRuleDetailsContent.from_dict(obj["destinationDynamicObject"]) if obj.get("destinationDynamicObject") is not None else None,
            "destinationNetwork": AccessRuleDetailsContent.from_dict(obj["destinationNetwork"]) if obj.get("destinationNetwork") is not None else None,
            "destinationPort": AccessRuleDetailsContent.from_dict(obj["destinationPort"]) if obj.get("destinationPort") is not None else None,
            "entityUid": obj.get("entityUid"),
            "index": obj.get("index"),
            "logSettings": LogSettings.from_dict(obj["logSettings"]) if obj.get("logSettings") is not None else None,
            "protocol": AccessRuleDetailsContent.from_dict(obj["protocol"]) if obj.get("protocol") is not None else None,
            "remark": obj.get("remark"),
            "ruleAction": obj.get("ruleAction"),
            "ruleTimeRange": AccessRuleDetailsContent.from_dict(obj["ruleTimeRange"]) if obj.get("ruleTimeRange") is not None else None,
            "sourceDynamicObject": AccessRuleDetailsContent.from_dict(obj["sourceDynamicObject"]) if obj.get("sourceDynamicObject") is not None else None,
            "sourceNetwork": AccessRuleDetailsContent.from_dict(obj["sourceNetwork"]) if obj.get("sourceNetwork") is not None else None,
            "sourcePort": AccessRuleDetailsContent.from_dict(obj["sourcePort"]) if obj.get("sourcePort") is not None else None
        })
        return _obj


