# coding: utf-8

"""
    Cisco Security Cloud Control API

    Use the documentation to explore the endpoints Security Cloud Control has to offer

    The version of the OpenAPI document: 1.9.0
    Contact: cdo.tac@cisco.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class InterfaceHealthMetrics(BaseModel):
    """
    The interface health metrics for the device.
    """ # noqa: E501
    buffer_overruns_avg: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Monitors the average number of times where incoming data exceeded buffer capacity, potentially leading to data loss.", alias="bufferOverrunsAvg")
    buffer_underruns_avg: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Tracks the average number of times the data buffer was insufficient to handle outgoing traffic, possibly causing transmission delays.", alias="bufferUnderrunsAvg")
    drop_packets_avg: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Average number of packets dropped by the interface due to network congestion, buffer overflow, or errors.", alias="dropPacketsAvg")
    duplex_mode: Optional[StrictStr] = Field(default=None, description="Configuration of the interface regarding data transmission, indicating whether it is set to full, half, or auto-duplex.", alias="duplexMode")
    input_bytes_avg: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Total amount of data received through the interface, providing insights into the volume of inbound traffic.", alias="inputBytesAvg")
    input_errors_avg: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The average rate of erroneous packets received, indicative of issues like corruption or transmission errors.", alias="inputErrorsAvg")
    input_packet_size_avg: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Average size of packets received, useful for analysing the nature of inbound traffic.", alias="inputPacketSizeAvg")
    interface: Optional[StrictStr] = Field(default=None, description="Identifier for a specific network interface on the FTD device, used for network traffic management and monitoring.")
    interface_name: Optional[StrictStr] = Field(default=None, description="The name assigned to the interface, facilitating easier identification and configuration.", alias="interfaceName")
    interface_type: Optional[StrictStr] = Field(default=None, description="The physical or logical type of the interface (e.g., Ethernet, virtual, management).", alias="interfaceType")
    l2_decode_drops_avg: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The average number of packets that could not be processed due to issues at the Data Link layer, including protocol mismatches or corruption.", alias="l2DecodeDropsAvg")
    link_status: Optional[StrictStr] = Field(default=None, description="Indicates whether the physical link of the network interface is active (UP) or inactive (DOWN). The interface will be marked as DOWN if there is no traffic through the interface.", alias="linkStatus")
    operational_status: Optional[StrictStr] = Field(default=None, description="Current state of the interface from a functional standpoint, influenced by both administrative settings and physical connectivity.", alias="operationalStatus")
    output_bytes_avg: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Total data sent out through the interface, useful for tracking outbound traffic levels.", alias="outputBytesAvg")
    output_errors_avg: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Average count of error-ridden packets sent from the device, pointing to problems in packet formation or hardware issues.", alias="outputErrorsAvg")
    output_packet_size_avg: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Average size of packets sent. Helps in understanding the traffic distribution and network load.", alias="outputPacketSizeAvg")
    __properties: ClassVar[List[str]] = ["bufferOverrunsAvg", "bufferUnderrunsAvg", "dropPacketsAvg", "duplexMode", "inputBytesAvg", "inputErrorsAvg", "inputPacketSizeAvg", "interface", "interfaceName", "interfaceType", "l2DecodeDropsAvg", "linkStatus", "operationalStatus", "outputBytesAvg", "outputErrorsAvg", "outputPacketSizeAvg"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of InterfaceHealthMetrics from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of InterfaceHealthMetrics from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "bufferOverrunsAvg": obj.get("bufferOverrunsAvg"),
            "bufferUnderrunsAvg": obj.get("bufferUnderrunsAvg"),
            "dropPacketsAvg": obj.get("dropPacketsAvg"),
            "duplexMode": obj.get("duplexMode"),
            "inputBytesAvg": obj.get("inputBytesAvg"),
            "inputErrorsAvg": obj.get("inputErrorsAvg"),
            "inputPacketSizeAvg": obj.get("inputPacketSizeAvg"),
            "interface": obj.get("interface"),
            "interfaceName": obj.get("interfaceName"),
            "interfaceType": obj.get("interfaceType"),
            "l2DecodeDropsAvg": obj.get("l2DecodeDropsAvg"),
            "linkStatus": obj.get("linkStatus"),
            "operationalStatus": obj.get("operationalStatus"),
            "outputBytesAvg": obj.get("outputBytesAvg"),
            "outputErrorsAvg": obj.get("outputErrorsAvg"),
            "outputPacketSizeAvg": obj.get("outputPacketSizeAvg")
        })
        return _obj


