# coding: utf-8

"""
    Cisco Security Cloud Control API

    Use the documentation to explore the endpoints Security Cloud Control has to offer

    The version of the OpenAPI document: 1.9.0
    Contact: cdo.tac@cisco.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class CdoCliResult(BaseModel):
    """
    CdoCliResult
    """ # noqa: E501
    device_uid: StrictStr = Field(description="The unique identifier, represented as a UUID, of the device.", alias="deviceUid")
    error_msg: Optional[StrictStr] = Field(default=None, description="The error message, if any.", alias="errorMsg")
    result: Optional[StrictStr] = Field(default=None, description="The result of the CLI execution.")
    script: Optional[StrictStr] = Field(default=None, description="The script executed to generate the CLI result.")
    start_time: Optional[datetime] = Field(default=None, description="The time (in UTC) at which the user run the CLI execution, represented using the RFC-3339 standard.", alias="startTime")
    uid: StrictStr = Field(description="The unique identifier, represented as a UUID, of the CLI execution result.")
    __properties: ClassVar[List[str]] = ["deviceUid", "errorMsg", "result", "script", "startTime", "uid"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CdoCliResult from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CdoCliResult from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "deviceUid": obj.get("deviceUid"),
            "errorMsg": obj.get("errorMsg"),
            "result": obj.get("result"),
            "script": obj.get("script"),
            "startTime": obj.get("startTime"),
            "uid": obj.get("uid")
        })
        return _obj


