# coding: utf-8

"""
    Cisco Security Cloud Control API

    Use the documentation to explore the endpoints Security Cloud Control has to offer

    The version of the OpenAPI document: 1.9.0
    Contact: cdo.tac@cisco.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from cdo_sdk_python.models.location import Location
from cdo_sdk_python.models.os import OS
from typing import Optional, Set
from typing_extensions import Self

class RaVpnSession(BaseModel):
    """
    RaVpnSession
    """ # noqa: E501
    assigned_ip_v4: Optional[StrictStr] = Field(default=None, description="The IPv4 address assigned to the RA VPN session.", alias="assignedIpV4")
    assigned_ip_v6: Optional[StrictStr] = Field(default=None, description="The IPv6 address assigned to the RA VPN session.", alias="assignedIpV6")
    audit_session_id: Optional[StrictStr] = Field(default=None, description="The audit session ID associated with this RA VPN session.", alias="auditSessionId")
    bytes_rx: Optional[StrictInt] = Field(default=None, description="The number of bytes received during the RA VPN session.", alias="bytesRx")
    bytes_tx: Optional[StrictInt] = Field(default=None, description="The number of bytes transmitted during the RA VPN session.", alias="bytesTx")
    device_uid: StrictStr = Field(description="The unique identifier, represented as a UUID, of the device associated with the RA VPN session.", alias="deviceUid")
    last_active_time: Optional[datetime] = Field(default=None, description="The time (in UTC) at which the user was last active in the RA VPN session, represented using the RFC-3339 standard.", alias="lastActiveTime")
    location: Optional[Location] = None
    login_time: Optional[datetime] = Field(default=None, description="The time (in UTC) at which the user logged in to the RA VPN session, represented using the RFC-3339 standard.", alias="loginTime")
    os: Optional[OS] = None
    public_ip: Optional[StrictStr] = Field(default=None, description="The public IP address of the client that has established this RA VPN session.", alias="publicIp")
    status: Optional[StrictStr] = Field(default=None, description="The status of the RA VPN session.")
    uid: StrictStr = Field(description="The unique identifier, represented as a UUID, of the VPN session.")
    username: StrictStr = Field(description="The name of the user associated with the RA VPN session.")
    __properties: ClassVar[List[str]] = ["assignedIpV4", "assignedIpV6", "auditSessionId", "bytesRx", "bytesTx", "deviceUid", "lastActiveTime", "location", "loginTime", "os", "publicIp", "status", "uid", "username"]

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['ACTIVE', 'TERMINATED']):
            raise ValueError("must be one of enum values ('ACTIVE', 'TERMINATED')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RaVpnSession from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of location
        if self.location:
            _dict['location'] = self.location.to_dict()
        # override the default output from pydantic by calling `to_dict()` of os
        if self.os:
            _dict['os'] = self.os.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RaVpnSession from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "assignedIpV4": obj.get("assignedIpV4"),
            "assignedIpV6": obj.get("assignedIpV6"),
            "auditSessionId": obj.get("auditSessionId"),
            "bytesRx": obj.get("bytesRx"),
            "bytesTx": obj.get("bytesTx"),
            "deviceUid": obj.get("deviceUid"),
            "lastActiveTime": obj.get("lastActiveTime"),
            "location": Location.from_dict(obj["location"]) if obj.get("location") is not None else None,
            "loginTime": obj.get("loginTime"),
            "os": OS.from_dict(obj["os"]) if obj.get("os") is not None else None,
            "publicIp": obj.get("publicIp"),
            "status": obj.get("status"),
            "uid": obj.get("uid"),
            "username": obj.get("username")
        })
        return _obj


