# coding: utf-8

"""
    Cisco Security Cloud Control API

    Use the documentation to explore the endpoints Security Cloud Control has to offer

    The version of the OpenAPI document: 1.9.0
    Contact: cdo.tac@cisco.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from cdo_sdk_python.models.application_context import ApplicationContext
from cdo_sdk_python.models.http_status_code import HttpStatusCode
from cdo_sdk_python.models.servlet_context import ServletContext
from typing import Optional, Set
from typing_extensions import Self

class RedirectView(BaseModel):
    """
    RedirectView
    """ # noqa: E501
    application_context: Optional[ApplicationContext] = Field(default=None, alias="applicationContext")
    attributes: Optional[Dict[str, StrictStr]] = None
    attributes_csv: Optional[StrictStr] = Field(default=None, alias="attributesCSV")
    attributes_map: Optional[Dict[str, Dict[str, Any]]] = Field(default=None, alias="attributesMap")
    bean_name: Optional[StrictStr] = Field(default=None, alias="beanName")
    content_type: Optional[StrictStr] = Field(default=None, alias="contentType")
    context_relative: Optional[StrictBool] = Field(default=None, alias="contextRelative")
    encoding_scheme: Optional[StrictStr] = Field(default=None, alias="encodingScheme")
    expand_uri_template_variables: Optional[StrictBool] = Field(default=None, alias="expandUriTemplateVariables")
    expose_context_beans_as_attributes: Optional[StrictBool] = Field(default=None, alias="exposeContextBeansAsAttributes")
    expose_model_attributes: Optional[StrictBool] = Field(default=None, alias="exposeModelAttributes")
    expose_path_variables: Optional[StrictBool] = Field(default=None, alias="exposePathVariables")
    exposed_context_bean_names: Optional[List[StrictStr]] = Field(default=None, alias="exposedContextBeanNames")
    hosts: Optional[List[StrictStr]] = None
    http10_compatible: Optional[StrictBool] = Field(default=None, alias="http10Compatible")
    propagate_query_params: Optional[StrictBool] = Field(default=None, alias="propagateQueryParams")
    propagate_query_properties: Optional[StrictBool] = Field(default=None, alias="propagateQueryProperties")
    redirect_view: Optional[StrictBool] = Field(default=None, alias="redirectView")
    request_context_attribute: Optional[StrictStr] = Field(default=None, alias="requestContextAttribute")
    servlet_context: Optional[ServletContext] = Field(default=None, alias="servletContext")
    static_attributes: Optional[Dict[str, Dict[str, Any]]] = Field(default=None, alias="staticAttributes")
    status_code: Optional[HttpStatusCode] = Field(default=None, alias="statusCode")
    url: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["applicationContext", "attributes", "attributesCSV", "attributesMap", "beanName", "contentType", "contextRelative", "encodingScheme", "expandUriTemplateVariables", "exposeContextBeansAsAttributes", "exposeModelAttributes", "exposePathVariables", "exposedContextBeanNames", "hosts", "http10Compatible", "propagateQueryParams", "propagateQueryProperties", "redirectView", "requestContextAttribute", "servletContext", "staticAttributes", "statusCode", "url"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RedirectView from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of application_context
        if self.application_context:
            _dict['applicationContext'] = self.application_context.to_dict()
        # override the default output from pydantic by calling `to_dict()` of servlet_context
        if self.servlet_context:
            _dict['servletContext'] = self.servlet_context.to_dict()
        # override the default output from pydantic by calling `to_dict()` of status_code
        if self.status_code:
            _dict['statusCode'] = self.status_code.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RedirectView from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "applicationContext": ApplicationContext.from_dict(obj["applicationContext"]) if obj.get("applicationContext") is not None else None,
            "attributes": obj.get("attributes"),
            "attributesCSV": obj.get("attributesCSV"),
            "attributesMap": obj.get("attributesMap"),
            "beanName": obj.get("beanName"),
            "contentType": obj.get("contentType"),
            "contextRelative": obj.get("contextRelative"),
            "encodingScheme": obj.get("encodingScheme"),
            "expandUriTemplateVariables": obj.get("expandUriTemplateVariables"),
            "exposeContextBeansAsAttributes": obj.get("exposeContextBeansAsAttributes"),
            "exposeModelAttributes": obj.get("exposeModelAttributes"),
            "exposePathVariables": obj.get("exposePathVariables"),
            "exposedContextBeanNames": obj.get("exposedContextBeanNames"),
            "hosts": obj.get("hosts"),
            "http10Compatible": obj.get("http10Compatible"),
            "propagateQueryParams": obj.get("propagateQueryParams"),
            "propagateQueryProperties": obj.get("propagateQueryProperties"),
            "redirectView": obj.get("redirectView"),
            "requestContextAttribute": obj.get("requestContextAttribute"),
            "servletContext": ServletContext.from_dict(obj["servletContext"]) if obj.get("servletContext") is not None else None,
            "staticAttributes": obj.get("staticAttributes"),
            "statusCode": HttpStatusCode.from_dict(obj["statusCode"]) if obj.get("statusCode") is not None else None,
            "url": obj.get("url")
        })
        return _obj


