/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin.rose;

import net.sourceforge.plantuml.klimt.Fashion;
import net.sourceforge.plantuml.klimt.UStroke;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.Colors;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.shape.URectangle;
import net.sourceforge.plantuml.skin.AbstractTextualComponent;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.style.ISkinParam;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.Style;

public final class ComponentRoseNoteBox
extends AbstractTextualComponent {
    private final Fashion symbolContext;
    private final double roundCorner;

    public ComponentRoseNoteBox(Style style, Display strings, ISkinParam skinParam, Colors colors) {
        super(style, style.wrapWidth(), 4, 4, 4, skinParam, strings, false);
        this.symbolContext = style.getSymbolContext(this.getIHtmlColorSet(), colors);
        this.roundCorner = style.value(PName.RoundCorner).asInt(false);
    }

    @Override
    public final double getPreferredWidth(StringBounder stringBounder) {
        double result = this.getTextWidth(stringBounder) + 2.0 * this.getPaddingX();
        return result;
    }

    @Override
    public final double getPreferredHeight(StringBounder stringBounder) {
        return this.getTextHeight(stringBounder) + 2.0 * this.getPaddingY();
    }

    @Override
    public double getPaddingX() {
        return 5.0;
    }

    @Override
    public double getPaddingY() {
        return 5.0;
    }

    @Override
    protected void drawInternalU(UGraphic ug, Area area) {
        StringBounder stringBounder = ug.getStringBounder();
        int textHeight = (int)this.getTextHeight(stringBounder);
        int x2 = (int)this.getTextWidth(stringBounder);
        double diffX = area.getDimensionToUse().getWidth() - this.getPreferredWidth(stringBounder);
        if (diffX < 0.0) {
            throw new IllegalArgumentException();
        }
        if (area.getDimensionToUse().getWidth() > this.getPreferredWidth(stringBounder)) {
            x2 = (int)(area.getDimensionToUse().getWidth() - 2.0 * this.getPaddingX());
        }
        ug = this.symbolContext.apply(ug);
        URectangle rect = URectangle.build(x2, textHeight).rounded(this.roundCorner);
        rect.setDeltaShadow(this.symbolContext.getDeltaShadow());
        ug.draw(rect);
        ug = ug.apply(UStroke.simple());
        this.getTextBlock().drawU(ug.apply(new UTranslate((double)this.getMarginX1() + diffX / 2.0, this.getMarginY())));
    }
}

