/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.syntax;

import java.io.PrintStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import net.sourceforge.plantuml.klimt.color.HColorSet;
import net.sourceforge.plantuml.skin.SkinParam;
import net.sourceforge.plantuml.utils.Cypher;

public class LanguageDescriptor {
    private final Set<String> type = new TreeSet<String>();
    private final Set<String> keyword = new TreeSet<String>();
    private final Set<String> preproc = new TreeSet<String>();

    public LanguageDescriptor() {
        this.addArobase("board");
        this.addArobase("bpm");
        this.addArobase("chen");
        this.addArobase("chronology");
        this.addArobase("creole");
        this.addArobase("cute");
        this.addArobase("def");
        this.addArobase("ditaa");
        this.addArobase("dot");
        this.addArobase("ebnf");
        this.addArobase("files");
        this.addArobase("flow");
        this.addArobase("gantt");
        this.addArobase("git");
        this.addArobase("hcl");
        this.addArobase("jcckit");
        this.addArobase("json");
        this.addArobase("latex");
        this.addArobase("math");
        this.addArobase("mindmap");
        this.addArobase("nwdiag");
        this.addArobase("project");
        this.addArobase("regex");
        this.addArobase("salt");
        this.addArobase("tree");
        this.addArobase("uml");
        this.addArobase("wbs");
        this.addArobase("wire");
        this.addArobase("yaml");
        this.type.add("abstract");
        this.type.add("action");
        this.type.add("actor");
        this.type.add("agent");
        this.type.add("annotation");
        this.type.add("archimate");
        this.type.add("artifact");
        this.type.add("boundary");
        this.type.add("card");
        this.type.add("class");
        this.type.add("cloud");
        this.type.add("collections");
        this.type.add("component");
        this.type.add("control");
        this.type.add("database");
        this.type.add("diamond");
        this.type.add("entity");
        this.type.add("enum");
        this.type.add("exception");
        this.type.add("file");
        this.type.add("folder");
        this.type.add("frame");
        this.type.add("hexagon");
        this.type.add("interface");
        this.type.add("json");
        this.type.add("label");
        this.type.add("map");
        this.type.add("metaclass");
        this.type.add("node");
        this.type.add("object");
        this.type.add("package");
        this.type.add("participant");
        this.type.add("person");
        this.type.add("process");
        this.type.add("protocol");
        this.type.add("queue");
        this.type.add("rectangle");
        this.type.add("relationship");
        this.type.add("stack");
        this.type.add("state");
        this.type.add("storage");
        this.type.add("struct");
        this.type.add("usecase");
        this.keyword.add("across");
        this.keyword.add("activate");
        this.keyword.add("again");
        this.keyword.add("allow_mixing");
        this.keyword.add("allowmixing");
        this.keyword.add("also");
        this.keyword.add("alt");
        this.keyword.add("as");
        this.keyword.add("attribute");
        this.keyword.add("attributes");
        this.keyword.add("autonumber");
        this.keyword.add("bold");
        this.keyword.add("bold");
        this.keyword.add("bottom");
        this.keyword.add("box");
        this.keyword.add("break");
        this.keyword.add("caption");
        this.keyword.add("center");
        this.keyword.add("circle");
        this.keyword.add("circled");
        this.keyword.add("circles");
        this.keyword.add("color");
        this.keyword.add("create");
        this.keyword.add("critical");
        this.keyword.add("dashed");
        this.keyword.add("deactivate");
        this.keyword.add("description");
        this.keyword.add("destroy");
        this.keyword.add("detach");
        this.keyword.add("dotted");
        this.keyword.add("down");
        this.keyword.add("else");
        this.keyword.add("else");
        this.keyword.add("elseif");
        this.keyword.add("empty");
        this.keyword.add("end");
        this.keyword.add("endcaption");
        this.keyword.add("endfooter");
        this.keyword.add("endheader");
        this.keyword.add("endif");
        this.keyword.add("endlegend");
        this.keyword.add("endtitle");
        this.keyword.add("endwhile");
        this.keyword.add("false");
        this.keyword.add("field");
        this.keyword.add("fields");
        this.keyword.add("footbox");
        this.keyword.add("footer");
        this.keyword.add("fork");
        this.keyword.add("group");
        this.keyword.add("header");
        this.keyword.add("hide");
        this.keyword.add("hnote");
        this.keyword.add("if");
        this.keyword.add("is");
        this.keyword.add("italic");
        this.keyword.add("kill");
        this.keyword.add("left");
        this.keyword.add("left to right direction");
        this.keyword.add("legend");
        this.keyword.add("link");
        this.keyword.add("loop");
        this.keyword.add("mainframe");
        this.keyword.add("member");
        this.keyword.add("members");
        this.keyword.add("method");
        this.keyword.add("methods");
        this.keyword.add("namespace");
        this.keyword.add("newpage");
        this.keyword.add("normal");
        this.keyword.add("note");
        this.keyword.add("of");
        this.keyword.add("on");
        this.keyword.add("opt");
        this.keyword.add("order");
        this.keyword.add("over");
        this.keyword.add("package");
        this.keyword.add("page");
        this.keyword.add("par");
        this.keyword.add("partition");
        this.keyword.add("plain");
        this.keyword.add("private");
        this.keyword.add("protected");
        this.keyword.add("public");
        this.keyword.add("ref");
        this.keyword.add("repeat");
        this.keyword.add("return");
        this.keyword.add("right");
        this.keyword.add("rnote");
        this.keyword.add("rotate");
        this.keyword.add("show");
        this.keyword.add("skin");
        this.keyword.add("skinparam");
        this.keyword.add("split");
        this.keyword.add("sprite");
        this.keyword.add("start");
        this.keyword.add("stereotype");
        this.keyword.add("stereotypes");
        this.keyword.add("stop");
        this.keyword.add("style");
        this.keyword.add("then");
        this.keyword.add("title");
        this.keyword.add("together");
        this.keyword.add("top");
        this.keyword.add("top to bottom direction");
        this.keyword.add("true");
        this.keyword.add("up");
        this.keyword.add("while");
        this.preproc.add("!assert");
        this.preproc.add("!define");
        this.preproc.add("!definelong");
        this.preproc.add("!dump_memory");
        this.preproc.add("!else");
        this.preproc.add("!enddefinelong");
        this.preproc.add("!endfunction");
        this.preproc.add("!endif");
        this.preproc.add("!endprocedure");
        this.preproc.add("!endsub");
        this.preproc.add("!exit");
        this.preproc.add("!function");
        this.preproc.add("!if");
        this.preproc.add("!ifdef");
        this.preproc.add("!ifndef");
        this.preproc.add("!import");
        this.preproc.add("!include");
        this.preproc.add("!local");
        this.preproc.add("!log");
        this.preproc.add("!pragma");
        this.preproc.add("!procedure");
        this.preproc.add("!return");
        this.preproc.add("!startsub");
        this.preproc.add("!theme");
        this.preproc.add("!undef");
        this.preproc.add("!unquoted");
    }

    private void addArobase(String type) {
        this.keyword.add("@start" + type);
        this.keyword.add("@end" + type);
    }

    public Cypher getCypher() {
        Cypher cypher = new Cypher();
        for (String s : this.type) {
            cypher.addException(s);
        }
        for (String s : this.keyword) {
            cypher.addException(s.replace("@", ""));
        }
        for (String s : this.preproc) {
            cypher.addException(s.substring(1));
        }
        for (String s : SkinParam.getPossibleValues()) {
            cypher.addException(s);
        }
        for (String s : HColorSet.instance().names()) {
            cypher.addException(s);
        }
        cypher.addException("o");
        return cypher;
    }

    public void print(PrintStream ps) {
        LanguageDescriptor.print(ps, "type", this.type);
        LanguageDescriptor.print(ps, "keyword", this.keyword);
        LanguageDescriptor.print(ps, "preprocessor", this.preproc);
        LanguageDescriptor.print(ps, "skinparameter", SkinParam.getPossibleValues());
        LanguageDescriptor.print(ps, "color", HColorSet.instance().names());
        ps.println(";EOF");
    }

    private static void print(PrintStream ps, String name, Collection<String> data) {
        ps.println(";" + name);
        ps.println(";" + data.size());
        for (String k : data) {
            ps.println(k);
        }
        ps.println();
    }

    public final Set<String> getType() {
        return Collections.unmodifiableSet(this.type);
    }

    public final Set<String> getKeyword() {
        return Collections.unmodifiableSet(this.keyword);
    }

    public final Set<String> getPreproc() {
        return Collections.unmodifiableSet(this.preproc);
    }

    public static void main(String[] args) {
        LanguageDescriptor languageDescriptor = new LanguageDescriptor();
        for (String s : languageDescriptor.type) {
            System.out.print(s);
            System.out.print("|");
        }
        System.out.println();
        for (String s : languageDescriptor.keyword) {
            if (s.startsWith("@")) continue;
            System.out.print(s);
            System.out.print("|");
        }
    }
}

