/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.timingdiagram.command;

import java.util.StringTokenizer;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.ParserPass;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.regex.IRegex;
import net.sourceforge.plantuml.regex.RegexConcat;
import net.sourceforge.plantuml.regex.RegexLeaf;
import net.sourceforge.plantuml.regex.RegexResult;
import net.sourceforge.plantuml.timingdiagram.Player;
import net.sourceforge.plantuml.timingdiagram.TimingDiagram;
import net.sourceforge.plantuml.utils.LineLocation;

public class CommandDefineStateShort
extends SingleLineCommand2<TimingDiagram> {
    public CommandDefineStateShort() {
        super(CommandDefineStateShort.getRegexConcat());
    }

    private static IRegex getRegexConcat() {
        return RegexConcat.build(CommandDefineStateShort.class.getName(), RegexLeaf.start(), new RegexLeaf("PLAYER", "([%pLN_.@]+)"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("has"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("STATE", "([-%pLN_.@]+)"), new RegexLeaf("STATES", "((,([-%pLN_.@]+))*)"), RegexLeaf.end());
    }

    @Override
    protected final CommandExecutionResult executeArg(TimingDiagram diagram, LineLocation location, RegexResult arg, ParserPass currentPass) {
        String playerCode = arg.get("PLAYER", 0);
        Player player = diagram.getPlayer(playerCode);
        if (player == null) {
            return CommandExecutionResult.error("Unknown " + playerCode);
        }
        String stateCode = arg.get("STATE", 0);
        player.defineState(stateCode, stateCode);
        String states = arg.get("STATES", 0);
        if (states != null) {
            StringTokenizer st = new StringTokenizer(states, ",");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                player.defineState(token, token);
            }
        }
        return CommandExecutionResult.ok();
    }
}

