/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.TitledDiagram;
import net.sourceforge.plantuml.activitydiagram3.ftile.BoxStyleAcceptEvent;
import net.sourceforge.plantuml.activitydiagram3.ftile.BoxStyleContinuous;
import net.sourceforge.plantuml.activitydiagram3.ftile.BoxStyleInput;
import net.sourceforge.plantuml.activitydiagram3.ftile.BoxStyleLoad;
import net.sourceforge.plantuml.activitydiagram3.ftile.BoxStyleObject;
import net.sourceforge.plantuml.activitydiagram3.ftile.BoxStyleObjectSignal;
import net.sourceforge.plantuml.activitydiagram3.ftile.BoxStyleOutput;
import net.sourceforge.plantuml.activitydiagram3.ftile.BoxStylePlain;
import net.sourceforge.plantuml.activitydiagram3.ftile.BoxStyleProcedure;
import net.sourceforge.plantuml.activitydiagram3.ftile.BoxStyleSave;
import net.sourceforge.plantuml.activitydiagram3.ftile.BoxStyleSendSignal;
import net.sourceforge.plantuml.activitydiagram3.ftile.BoxStyleTask;
import net.sourceforge.plantuml.activitydiagram3.ftile.BoxStyleTimeEvent;
import net.sourceforge.plantuml.activitydiagram3.ftile.BoxStyleTrigger;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.stereo.Stereotype;
import net.sourceforge.plantuml.warning.Warning;

public abstract class BoxStyle {
    private static final List<BoxStyle> values = new ArrayList<BoxStyle>();
    public static final BoxStyle PLAIN = new BoxStylePlain(null, '\u0000', 0.0);
    public static final BoxStyle SDL_INPUT = new BoxStyleInput("input", '<', 10.0);
    public static final BoxStyle SDL_OUTPUT = new BoxStyleOutput("output", '>', 10.0);
    public static final BoxStyle SDL_PROCEDURE = new BoxStyleProcedure("procedure", '|', 0.0);
    public static final BoxStyle SDL_LOAD = new BoxStyleLoad("load", '\\', 0.0);
    public static final BoxStyle SDL_SAVE = new BoxStyleSave("save", '/', 0.0);
    public static final BoxStyle SDL_CONTINUOUS = new BoxStyleContinuous("continuous", '}', 0.0);
    public static final BoxStyle SDL_TASK = new BoxStyleTask("task", ']', 0.0);
    public static final BoxStyle UML_OBJECT = new BoxStyleObject("object", ']', 0.0);
    public static final BoxStyle UML_OBJECT_SIGNAL = new BoxStyleObjectSignal("objectSignal", '\u0000', 10.0);
    public static final BoxStyle UML_TRIGGER = new BoxStyleTrigger("trigger", '\u0000', 10.0);
    public static final BoxStyle UML_SEND_SIGNAL = new BoxStyleSendSignal("sendSignal", '\u0000', 10.0);
    public static final BoxStyle UML_ACCEPT_EVENT = new BoxStyleAcceptEvent("acceptEvent", '\u0000', 10.0);
    public static final BoxStyle UML_TIME_EVENT = new BoxStyleTimeEvent("timeEvent", '\u0000', 10.0);
    protected final String stereotype;
    protected final char style;
    protected final double shield;
    protected static int DELTA_INPUT_OUTPUT = 10;
    protected static double DELTA_CONTINUOUS = 5.0;
    protected static int PADDING = 5;

    public abstract void drawMe(UGraphic var1, double var2, double var4, double var6, double var8);

    protected BoxStyle(String stereotype, char style, double shield) {
        this.stereotype = stereotype;
        this.style = style;
        this.shield = shield;
        values.add(this);
    }

    public double getShield() {
        return this.shield;
    }

    public static BoxStyle fromString(String style) {
        if (style != null) {
            if (style.length() == 1) {
                for (BoxStyle bs : values) {
                    if (bs.style != style.charAt(0)) continue;
                    return bs;
                }
            }
            for (String s : style.split("\\s")) {
                s = s.replaceAll("\\W", "");
                for (BoxStyle bs : values) {
                    if (!s.equalsIgnoreCase(bs.stereotype)) continue;
                    return bs;
                }
            }
        }
        return PLAIN;
    }

    public static void checkDeprecatedWarning(TitledDiagram diagram, String style) {
        BoxStyle boxStyle;
        if (style != null && style.length() == 1 && (boxStyle = BoxStyle.fromString(style)) != PLAIN) {
            diagram.addWarning(new Warning("The syntax using the " + boxStyle.style + " character is now obsolete.", "Please use the <<" + boxStyle.stereotype + ">> stereotype instead.", "For more details, visit https://plantuml.com/activity-diagram-beta"));
        }
    }

    public Stereotype getStereotype() {
        if (this.stereotype == null) {
            return null;
        }
        return Stereotype.build("<<" + this.stereotype + ">>");
    }
}

