#!/usr/bin/env python
# -*- coding: utf-8 -*-
# Copyright 2023 The OpenRL Authors.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

""""""

from abc import ABC, abstractmethod

from ChatAgent.agents.base_agent import BaseAgent


class BaseAPIAgent(BaseAgent, ABC):
    def __init__(self, api_base="", api_key="sk-", model_name="", api_type="open_ai", api_version=None,
                 deployment_name=None, stop_tokens=None,max_tokens=None):
        self.api_base = api_base
        self.api_key = api_key
        self.model_name = model_name
        self.deployment_name = deployment_name
        self.api_type = api_type
        self.api_version = api_version

        if stop_tokens is None:
            stop_tokens = []
        self.stop_tokens = stop_tokens
        self.max_tokens = max_tokens

        self.client = None

    def act(self, observation):
        request = observation
        response = self.complete(request)
        return response

    def complete(self, request):
        raise NotImplementedError
