# coding: utf-8

"""
    Chatwoot

    This is the API documentation for Chatwoot server.  # noqa: E501

    OpenAPI spec version: 1.0.0
    Contact: hello@chatwoot.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from chatwoot_client.api_client import ApiClient


class CustomAttributesApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def add_new_custom_attribute_to_account(self, body, account_id, **kwargs):  # noqa: E501
        """Add a new custom attribute  # noqa: E501

        Add a new custom attribute to account  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_new_custom_attribute_to_account(body, account_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CustomAttributeCreateUpdatePayload body: (required)
        :param int account_id: The numeric ID of the account (required)
        :return: CustomAttribute
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_new_custom_attribute_to_account_with_http_info(body, account_id, **kwargs)  # noqa: E501
        else:
            (data) = self.add_new_custom_attribute_to_account_with_http_info(body, account_id, **kwargs)  # noqa: E501
            return data

    def add_new_custom_attribute_to_account_with_http_info(self, body, account_id, **kwargs):  # noqa: E501
        """Add a new custom attribute  # noqa: E501

        Add a new custom attribute to account  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_new_custom_attribute_to_account_with_http_info(body, account_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CustomAttributeCreateUpdatePayload body: (required)
        :param int account_id: The numeric ID of the account (required)
        :return: CustomAttribute
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'account_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_new_custom_attribute_to_account" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `add_new_custom_attribute_to_account`")  # noqa: E501
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params or
                params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `add_new_custom_attribute_to_account`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'account_id' in params:
            path_params['account_id'] = params['account_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json; charset=utf-8'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json; charset=utf-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['userApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/accounts/{account_id}/custom_attribute_definitions', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CustomAttribute',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_custom_attribute_from_account(self, account_id, id, **kwargs):  # noqa: E501
        """Remove a custom attribute from account  # noqa: E501

        Remove a custom attribute from account  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_custom_attribute_from_account(account_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int account_id: The numeric ID of the account (required)
        :param int id: The ID of the custom attribute to be deleted (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_custom_attribute_from_account_with_http_info(account_id, id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_custom_attribute_from_account_with_http_info(account_id, id, **kwargs)  # noqa: E501
            return data

    def delete_custom_attribute_from_account_with_http_info(self, account_id, id, **kwargs):  # noqa: E501
        """Remove a custom attribute from account  # noqa: E501

        Remove a custom attribute from account  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_custom_attribute_from_account_with_http_info(account_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int account_id: The numeric ID of the account (required)
        :param int id: The ID of the custom attribute to be deleted (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_custom_attribute_from_account" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params or
                params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `delete_custom_attribute_from_account`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `delete_custom_attribute_from_account`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'account_id' in params:
            path_params['account_id'] = params['account_id']  # noqa: E501
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['userApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/accounts/{account_id}/custom_attribute_definitions/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_account_custom_attribute(self, account_id, attribute_model, **kwargs):  # noqa: E501
        """List all custom attributes in an account  # noqa: E501

        Get details of custom attributes in an Account  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_account_custom_attribute(account_id, attribute_model, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int account_id: The numeric ID of the account (required)
        :param str attribute_model: conversation_attribute(0)/contact_attribute(1) (required)
        :return: list[CustomAttribute]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_account_custom_attribute_with_http_info(account_id, attribute_model, **kwargs)  # noqa: E501
        else:
            (data) = self.get_account_custom_attribute_with_http_info(account_id, attribute_model, **kwargs)  # noqa: E501
            return data

    def get_account_custom_attribute_with_http_info(self, account_id, attribute_model, **kwargs):  # noqa: E501
        """List all custom attributes in an account  # noqa: E501

        Get details of custom attributes in an Account  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_account_custom_attribute_with_http_info(account_id, attribute_model, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int account_id: The numeric ID of the account (required)
        :param str attribute_model: conversation_attribute(0)/contact_attribute(1) (required)
        :return: list[CustomAttribute]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'attribute_model']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_account_custom_attribute" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params or
                params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `get_account_custom_attribute`")  # noqa: E501
        # verify the required parameter 'attribute_model' is set
        if ('attribute_model' not in params or
                params['attribute_model'] is None):
            raise ValueError("Missing the required parameter `attribute_model` when calling `get_account_custom_attribute`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'account_id' in params:
            path_params['account_id'] = params['account_id']  # noqa: E501

        query_params = []
        if 'attribute_model' in params:
            query_params.append(('attribute_model', params['attribute_model']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json; charset=utf-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['userApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/accounts/{account_id}/custom_attribute_definitions', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[CustomAttribute]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_details_of_a_single_custom_attribute(self, account_id, id, **kwargs):  # noqa: E501
        """Get a custom attribute details  # noqa: E501

        Get the details of a custom attribute in the account  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_details_of_a_single_custom_attribute(account_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int account_id: The numeric ID of the account (required)
        :param int id: The ID of the custom attribute to be updated. (required)
        :return: CustomAttribute
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_details_of_a_single_custom_attribute_with_http_info(account_id, id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_details_of_a_single_custom_attribute_with_http_info(account_id, id, **kwargs)  # noqa: E501
            return data

    def get_details_of_a_single_custom_attribute_with_http_info(self, account_id, id, **kwargs):  # noqa: E501
        """Get a custom attribute details  # noqa: E501

        Get the details of a custom attribute in the account  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_details_of_a_single_custom_attribute_with_http_info(account_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int account_id: The numeric ID of the account (required)
        :param int id: The ID of the custom attribute to be updated. (required)
        :return: CustomAttribute
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_details_of_a_single_custom_attribute" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params or
                params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `get_details_of_a_single_custom_attribute`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_details_of_a_single_custom_attribute`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'account_id' in params:
            path_params['account_id'] = params['account_id']  # noqa: E501
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json; charset=utf-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['userApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/accounts/{account_id}/custom_attribute_definitions/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CustomAttribute',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_custom_attribute_in_account(self, body, account_id, id, **kwargs):  # noqa: E501
        """Update custom attribute in Account  # noqa: E501

        Update a custom attribute in account  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_custom_attribute_in_account(body, account_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CustomAttributeCreateUpdatePayload body: (required)
        :param int account_id: The numeric ID of the account (required)
        :param int id: The ID of the custom attribute to be updated. (required)
        :return: CustomAttribute
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_custom_attribute_in_account_with_http_info(body, account_id, id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_custom_attribute_in_account_with_http_info(body, account_id, id, **kwargs)  # noqa: E501
            return data

    def update_custom_attribute_in_account_with_http_info(self, body, account_id, id, **kwargs):  # noqa: E501
        """Update custom attribute in Account  # noqa: E501

        Update a custom attribute in account  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_custom_attribute_in_account_with_http_info(body, account_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CustomAttributeCreateUpdatePayload body: (required)
        :param int account_id: The numeric ID of the account (required)
        :param int id: The ID of the custom attribute to be updated. (required)
        :return: CustomAttribute
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'account_id', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_custom_attribute_in_account" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_custom_attribute_in_account`")  # noqa: E501
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params or
                params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `update_custom_attribute_in_account`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `update_custom_attribute_in_account`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'account_id' in params:
            path_params['account_id'] = params['account_id']  # noqa: E501
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json; charset=utf-8'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json; charset=utf-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['userApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/accounts/{account_id}/custom_attribute_definitions/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CustomAttribute',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
