# coding: utf-8

"""
    Chatwoot

    This is the API documentation for Chatwoot server.  # noqa: E501

    OpenAPI spec version: 1.0.0
    Contact: hello@chatwoot.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from chatwoot_client.api_client import ApiClient


class CSATSurveyPageApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_csat_survey_page(self, conversation_uuid, **kwargs):  # noqa: E501
        """Get CSAT survey page  # noqa: E501

        You can redirect the client to this URL, instead of implementing the CSAT survey component yourself.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_csat_survey_page(conversation_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int conversation_uuid: The uuid of the conversation (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_csat_survey_page_with_http_info(conversation_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_csat_survey_page_with_http_info(conversation_uuid, **kwargs)  # noqa: E501
            return data

    def get_csat_survey_page_with_http_info(self, conversation_uuid, **kwargs):  # noqa: E501
        """Get CSAT survey page  # noqa: E501

        You can redirect the client to this URL, instead of implementing the CSAT survey component yourself.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_csat_survey_page_with_http_info(conversation_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int conversation_uuid: The uuid of the conversation (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['conversation_uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_csat_survey_page" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'conversation_uuid' is set
        if ('conversation_uuid' not in params or
                params['conversation_uuid'] is None):
            raise ValueError("Missing the required parameter `conversation_uuid` when calling `get_csat_survey_page`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'conversation_uuid' in params:
            path_params['conversation_uuid'] = params['conversation_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/survey/responses/{conversation_uuid}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
