"""Exception classes for Chzzk SDK."""

from chzzk.exceptions.errors import (
    AuthenticationError,
    ChatConnectionError,
    ChatNotLiveError,
    ChatReconnectError,
    ChzzkAPIError,
    ChzzkError,
    CookieAuthenticationError,
    EventSubscriptionError,
    ForbiddenError,
    InvalidClientError,
    InvalidStateError,
    InvalidTokenError,
    MessageParseError,
    NotFoundError,
    RateLimitError,
    ServerError,
    SessionConnectionError,
    SessionError,
    SessionLimitExceededError,
    TokenExpiredError,
    UnofficialAPIError,
    WebSocketProtocolError,
)

__all__ = [
    "AuthenticationError",
    "ChatConnectionError",
    "ChatNotLiveError",
    "ChatReconnectError",
    "ChzzkAPIError",
    "ChzzkError",
    "CookieAuthenticationError",
    "EventSubscriptionError",
    "ForbiddenError",
    "InvalidClientError",
    "InvalidStateError",
    "InvalidTokenError",
    "MessageParseError",
    "NotFoundError",
    "RateLimitError",
    "ServerError",
    "SessionConnectionError",
    "SessionError",
    "SessionLimitExceededError",
    "TokenExpiredError",
    "UnofficialAPIError",
    "WebSocketProtocolError",
]
