# pylint: disable=invalid-name,too-few-public-methods
"""This file is for `sphinx-build` configuration"""

import os
import sys


sys.path.insert(0, os.path.abspath(".."))

# -- General configuration
# ------------------------------------------------

# Add any Sphinx extension module names here, as strings. They can be
# extensions coming with Sphinx (named 'sphinx.ext.*') or your custom
# ones.
extensions = [
    "sphinx.ext.autodoc",
    "sphinx.ext.intersphinx",
    "sphinx.ext.napoleon",
    "sphinx.ext.todo",
    "sphinx.ext.viewcode",
    "sphinx_immaterial",
    # "rst2pdf.pdfbuilder",  # for local pdf builder support
]

# Uncomment the below if you use native CircuitPython modules such as
# digitalio, micropython and busio. List the modules you use. Without it, the
# autodoc module docs will fail to generate with a warning.
# autodoc_mock_imports = ["digitalio", "busio", "usb_hid", "microcontroller"]
autodoc_member_order = "bysource"

intersphinx_mapping = {
    "python": ("https://docs.python.org/3", None),
    "CircuitPython": ("https://circuitpython.readthedocs.io/en/latest/", None),
}

# Add any paths that contain templates here, relative to this directory.
templates_path = ["_templates"]

source_suffix = ".rst"

# The master toctree document.
master_doc = "index"

# General information about the project.
project = "Circuitpython Cirque Pinnacle Library"
copyright = "2020 Brendan Doherty"  # pylint: disable=redefined-builtin
author = "Brendan Doherty"

# The version info for the project you're documenting, acts as replacement for
# |version| and |release|, also used in various other places throughout the
# built documents.
#
# The short X.Y version.
version = "dev"
# The full version, including alpha/beta/rc tags.
release = "1.0"

html_baseurl = "https://circuitpython-cirque-pinnacle.readthedocs.io/"

# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
#
# This is also used if you do content translation via gettext catalogs.
# Usually you set "language" from the command line for these cases.
language = "en"

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
# This patterns also effect to html_static_path and html_extra_path
exclude_patterns = [
    "_build",
    "Thumbs.db",
    ".DS_Store",
    ".env",
    "CODE_OF_CONDUCT.md",
    "requirements.txt",
]

# The reST default role (used for this markup: `text`) to use for all
# documents.
#
default_role = "any"

rst_prolog = """
.. role:: python(code)
   :language: python
   :class: highlight
.. default-literal-role:: python

.. |rev2025| replace:: not supported on trackpads manufactured on or after 2025.
    Defer to :py:attr:`~circuitpython_cirque_pinnacle.PinnacleTouch.rev2025`.
.. |rev2025-no-effect| replace:: on newer trackpads will have no effect
"""

# If true, '()' will be appended to :func: etc. cross-reference text.
#
add_function_parentheses = True

# If true, `todo` and `todoList` produce output, else they produce nothing.
todo_include_todos = False

# If this is True, todo emits a warning for each TODO entries. The default is False.
todo_emit_warnings = False

napoleon_numpy_docstring = False

# -- Options for HTML output ----------------------------------------------

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
html_theme = "sphinx_immaterial"

html_theme_options = {
    "features": [
        "search.share",
    ],
    # Set the color and the accent color
    "palette": [
        {
            "media": "(prefers-color-scheme)",
            "toggle": {
                "icon": "material/brightness-auto",
                "name": "Switch to light mode",
            },
        },
        {
            "media": "(prefers-color-scheme: light)",
            "scheme": "default",
            "primary": "green",
            "accent": "light-blue",
            "toggle": {
                "icon": "material/lightbulb-outline",
                "name": "Switch to dark mode",
            },
        },
        {
            "media": "(prefers-color-scheme: dark)",
            "scheme": "slate",
            "primary": "green",
            "accent": "light-blue",
            "toggle": {
                "icon": "material/lightbulb",
                "name": "Switch to light mode",
            },
        },
    ],
    # Set the repo location to get a badge with stats
    "repo_url": "https://github.com/2bndy5/CircuitPython_Cirque_Pinnacle/",
    "repo_name": "CircuitPython_Cirque_Pinnacle",
    "social": [
        {
            "icon": "fontawesome/brands/github",
            "link": "https://github.com/2bndy5/CircuitPython_Cirque_Pinnacle",
        },
        {
            "icon": "fontawesome/brands/python",
            "link": "https://pypi.org/project/circuitpython-cirque-pinnacle/",
        },
        {
            "icon": "fontawesome/brands/discord",
            "link": "https://adafru.it/discord",
        },
        {
            "icon": "simple/adafruit",
            "link": "https://www.adafruit.com/",
        },
        {
            "icon": "simple/sparkfun",
            "link": "https://www.sparkfun.com/",
        },
        {
            "name": "CircuitPython Downloads",
            "icon": "octicons/download-24",
            "link": "https://circuitpython.org",
        },
    ],
}

sphinx_immaterial_custom_admonitions = [
    {
        "name": "warning",
        "color": (255, 66, 66),
        "icon": "octicons/alert-24",
        "override": True,
    },
    {
        "name": "note",
        "icon": "octicons/pencil-24",
        "override": True,
    },
    {
        "name": "seealso",
        "color": (255, 66, 252),
        "icon": "octicons/eye-24",
        "title": "See Also",
        "override": True,
    },
    {
        "name": "hint",
        "icon": "material/school",
        "override": True,
    },
    {
        "name": "tip",
        "icon": "material/school",
        "override": True,
    },
    {
        "name": "important",
        "icon": "material/school",
        "override": True,
    },
]

python_type_aliases = {
    "DigitalInOut": "digitalio.DigitalInOut",
}

object_description_options = [
    ("py:.*", dict(generate_synopses="first_sentence")),
]

# Set link name generated in the top bar.
html_title = "CircuitPython Cirque Pinnacle"

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
html_static_path = ["_static"]

# These paths are either relative to html_static_path
# or fully qualified paths (eg. https://...)
html_css_files = ["extra_css.css"]

# The name of an image file (relative to this directory) to use as a favicon of
# the docs.  This file should be a Windows icon file (.ico) being 16x16 or 32x32
# pixels large.
html_favicon = "_static/favicon.ico"

html_logo = "_static/Logo.png"
# Output file base name for HTML help builder.
htmlhelp_basename = "CircuitpythonCirquePinnacleLibrarydoc"

# -- Options for LaTeX output
# ---------------------------------------------

latex_elements = {
    # The paper size ('letterpaper' or 'a4paper').
    "papersize": "letterpaper",
    # The font size ('10pt', '11pt' or '12pt').
    "pointsize": "10pt",
    # Additional stuff for the LaTeX preamble.
    "preamble": "",
    # Latex figure (float) alignment
    "figure_align": "htbp",
}

# Grouping the document tree into LaTeX files. List of tuples
# (source start file, target name, title,
#  author, documentclass [howto, manual, or own class]).
latex_documents = [
    (
        master_doc,
        "CircuitPythonCirquePinnacleLibrary.tex",
        "CircuitPython Cirque Pinnacle Library Documentation",
        author,
        "manual",
    ),
]

# -- Options for manual page output
# ---------------------------------------

# One entry per manual page. List of tuples
# (source start file, name, description, authors, manual section).
man_pages = [
    (
        master_doc,
        "CircuitPythonCirquePinnacleLibrary",
        "CircuitPython Cirque Pinnacle Library Documentation",
        [author],
        1,
    )
]

# -- Options for Texinfo output
# -------------------------------------------

# Grouping the document tree into Texinfo files. List of tuples
# (source start file, target name, title, author,
#  dir menu entry, description, category)
texinfo_documents = [
    (
        master_doc,
        "CircuitpythonCirquePinnacleLibrary",
        "Circuitpython Cirque Pinnacle Library Documentation",
        author,
        "CircuitpythonCirquePinnacleLibrary",
        "CircuitPython Library for Cirque Pinnacle touch Controller.",
        "Miscellaneous",
    ),
]

# ---Options for PDF output
# -----------------------------------------
# requires `rst2pdf` module which is not builtin to Python 3.4 nor
# readthedocs.org's docker)

pdf_documents = [
    (
        "index",
        "CircuitPython-Cirque-Pinnacle",
        "CircuitPython-Cirque-Pinnacle library documentation",
        "Brendan Doherty",
    ),
]
