# CircuitPython MAX7347/MAX7348/MAX7349 Library

[![GitHub branch status](https://img.shields.io/github/checks-status/Roman3349/CircuitPython_MAX734X/master)](https://github.com/Roman3349/CircuitPython_MAX734X/actions?query=branch%3Amaster)
[![PyPI - Version](https://img.shields.io/pypi/v/circuitpython-max734x)](https://pypi.org/project/circuitpython-max734x/#history)
[![PyPI - Downloads](https://img.shields.io/pypi/dm/circuitpython-max734x)](https://pypi.org/project/circuitpython-max734x/)
[![PyPI - License](https://img.shields.io/pypi/l/circuitpython-max734x)](./LICENSE)

CircuitPython driver for the MAX7347/MAX7348/MAX7349 keyboard and sounder controllers.

## Dependencies

This driver depends on:

 - [Adafruit CircuitPython](https://github.com/adafruit/circuitpython)
 - [Bus Device](https://github.com/adafruit/Adafruit_CircuitPython_BusDevice)
 - [Register](https://github.com/adafruit/Adafruit_CircuitPython_Register)

## Installing from PyPI

On supported GNU/Linux systems like the Raspberry Pi, you can install the driver locally from [PyPI](https://pypi.org/project/circuitpython-max734x/).

To install in a virtual environment in your current project:
```bash
mkdir project-name && cd project-name
python3 -m venv venv
source venv/bin/activate
pip3 install circuitpython-max734x
```

## Usage Example

Examples can be found in the [examples](./examples) directory.
