# Changelog

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).
<!-- markdownlint-disable MD024 -->

## [2.2.0] - 2025-11-24

### <!-- 6 --> 📦 Dependency updates

- Bump pypa/gh-action-pypi-publish in /.github/workflows by \@dependabot[bot] in [#68](https://github.com/nRF24/CircuitPython_nRF24L01/pull/68)
- Bump actions/setup-python from 5 to 6 by \@dependabot[bot] in [#69](https://github.com/nRF24/CircuitPython_nRF24L01/pull/69)
- Bump actions/checkout from 4 to 5 by \@dependabot[bot] in [#67](https://github.com/nRF24/CircuitPython_nRF24L01/pull/67)
- Bump actions/upload-artifact from 4 to 5 in the actions group by \@dependabot[bot] in [#70](https://github.com/nRF24/CircuitPython_nRF24L01/pull/70)
- Bump actions/checkout from 5 to 6 in the actions group by \@dependabot[bot] in [#71](https://github.com/nRF24/CircuitPython_nRF24L01/pull/71)
- Drop support for Python v3.7 and v3.8 by \@2bndy5 in [#74](https://github.com/nRF24/CircuitPython_nRF24L01/pull/74)
- Bump actions/download-artifact from 5 to 6 in the actions group by \@dependabot[bot] in [#76](https://github.com/nRF24/CircuitPython_nRF24L01/pull/76)
- Switch to `uv` by \@2bndy5 in [#75](https://github.com/nRF24/CircuitPython_nRF24L01/pull/75)

### <!-- 9 --> 🗨️ Changed

- Group dependabot updates into 1 PR by \@2bndy5 in [`7ad575d`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/7ad575d66e1ad85cf9ce7b333513ddb8b5e47663)
- Upgrade pre-commit hooks by \@2bndy5 in [#72](https://github.com/nRF24/CircuitPython_nRF24L01/pull/72)
- Revise CI (again) by \@2bndy5 in [#73](https://github.com/nRF24/CircuitPython_nRF24L01/pull/73)
- Fix deployments to PyPI by \@2bndy5 in [`885511a`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/885511aa08b00a2ca427f7c031ccb0800d633cea)

[2.2.0]: https://github.com/nRF24/CircuitPython_nRF24L01/compare/v2.1.6...v2.2.0

Full commit diff: [`v2.1.6...v2.2.0`][2.2.0]

## [2.1.6] - 2025-05-08

### <!-- 1 --> 🚀 Added

- Updates from upstream C++ by \@2bndy5 in [#66](https://github.com/nRF24/CircuitPython_nRF24L01/pull/66)

### <!-- 9 --> 🗨️ Changed

- Bump version to v2.1.6 by \@2bndy5 in [`19720dd`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/19720dde75c157f0a42de0a6d9829e81f64bc5eb)

[2.1.6]: https://github.com/nRF24/CircuitPython_nRF24L01/compare/v2.1.5...v2.1.6

Full commit diff: [`v2.1.5...v2.1.6`][2.1.6]

## [2.1.5] - 2025-04-16

### <!-- 9 --> 🗨️ Changed

- Comment out debug print() call by \@2bndy5 in [`9be2955`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/9be295588ddebb3af0c65945bf5361f280c13cba)
- Bump version to v2.1.5 by \@2bndy5 in [`ebbdece`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/ebbdeceead96c2f2b20ae4fc843c25e99b52b06f)

[2.1.5]: https://github.com/nRF24/CircuitPython_nRF24L01/compare/v2.1.4...v2.1.5

Full commit diff: [`v2.1.4...v2.1.5`][2.1.5]

## [2.1.4] - 2025-01-29

### <!-- 1 --> 🚀 Added

- Network improvements by \@2bndy5 in [#59](https://github.com/nRF24/CircuitPython_nRF24L01/pull/59)

### <!-- 3 --> 🗑️ Removed

- Update pre-commit hooks by \@2bndy5 in [#58](https://github.com/nRF24/CircuitPython_nRF24L01/pull/58)

### <!-- 6 --> 📦 Dependency updates

- Bump actions/checkout from 3 to 4 by \@dependabot[bot] in [#51](https://github.com/nRF24/CircuitPython_nRF24L01/pull/51)
- Bump actions/setup-python from 4 to 5 by \@dependabot[bot] in [#53](https://github.com/nRF24/CircuitPython_nRF24L01/pull/53)
- Bump actions/upload-artifact from 3 to 4 by \@dependabot[bot] in [#55](https://github.com/nRF24/CircuitPython_nRF24L01/pull/55)
- Bump actions/cache from 3 to 4 by \@dependabot[bot] in [#56](https://github.com/nRF24/CircuitPython_nRF24L01/pull/56)
- Bump codecov/codecov-action from 3 to 4 by \@dependabot[bot] in [#57](https://github.com/nRF24/CircuitPython_nRF24L01/pull/57)
- Bump codecov/codecov-action from 4 to 5 by \@dependabot[bot] in [#63](https://github.com/nRF24/CircuitPython_nRF24L01/pull/63)
- Bump pypa/gh-action-pypi-publish from 1.10.3 to 1.12.4 by \@dependabot[bot] in [#65](https://github.com/nRF24/CircuitPython_nRF24L01/pull/65)

### <!-- 9 --> 🗨️ Changed

- Use dependabot by \@2bndy5 in [`c034e63`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/c034e63fab5885249366caaab4126c79496b03f0)
- Merge remote-tracking branch 'origin/use-dependabot' by \@2bndy5 in [`1a2f6c1`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/1a2f6c197d4d16626a59c70537660b7ee8c89999)
- Update pre commit hooks by \@2bndy5 in [#54](https://github.com/nRF24/CircuitPython_nRF24L01/pull/54)
- Update list of linting tools used in CONTIBUTING guideline by \@2bndy5 in [`fc69216`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/fc6921671893daa659c2aa12de805bfbcbfabbbf)
- Prepare for trusted publisher releases to pypi by \@2bndy5 in [`0870573`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/087057321395a5d1e2fe21b0f58c58504f9c5af9)
- Bump version to v2.1.4 by \@2bndy5 in [`719522d`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/719522d5cd34887aa90f7ee851a0737c566ecbc7)

[2.1.4]: https://github.com/nRF24/CircuitPython_nRF24L01/compare/2.1.3...v2.1.4

Full commit diff: [`2.1.3...v2.1.4`][2.1.4]

## New Contributors

- \@dependabot[bot] made their first contribution in [#65](https://github.com/nRF24/CircuitPython_nRF24L01/pull/65)

## [2.1.3] - 2023-09-05

### <!-- 3 --> 🗑️ Removed

- Generating social media cards for each docs page by \@2bndy5 in [#47](https://github.com/nRF24/CircuitPython_nRF24L01/pull/47)

### <!-- 4 --> 🛠️ Fixed

- Fix input to upload release assets action in CI by \@2bndy5 in [`c40ea2c`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/c40ea2c86c17d87bc57ea452aab909a11aa0e68f)
- Fix build CI for pre-release builds of CirPy by \@2bndy5 in [`3d3bc01`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/3d3bc018255736da8deb79ed82878d86b5ce2376)

### <!-- 8 --> 📝 Documentation

- Update docs by \@2bndy5 in [`1bfa436`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/1bfa4369dbd62f191ae061e6cf16514c86f5b984)

### <!-- 9 --> 🗨️ Changed

- Update `set-output` commands in CI by \@2bndy5 in [`a70a371`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/a70a371068f627f2f2288b3db3780a188aa86e6e)
- Merge branch 'more-CI-updates' by \@2bndy5 in [`c73978c`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/c73978c954d074cebd1337227dbc7ae08fbda51c)
- Resolve \#48 by \@2bndy5 in [#50](https://github.com/nRF24/CircuitPython_nRF24L01/pull/50)

[2.1.3]: https://github.com/nRF24/CircuitPython_nRF24L01/compare/2.1.2...2.1.3

Full commit diff: [`2.1.2...2.1.3`][2.1.3]

## [2.1.2] - 2022-10-26

### <!-- 1 --> 🚀 Added

- Add a dummy setup.py for older python versions by \@2bndy5 in [`f7b52f8`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/f7b52f87d2085401201bc4594c8648fd0a40e0a2)

### <!-- 3 --> 🗑️ Removed

- Remove submodule checkout in release CI by \@2bndy5 in [`95553b4`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/95553b4fd5c401a0c5904d1a1a79ca2c56d024be)

### <!-- 4 --> 🛠️ Fixed

- Fix project brief description in pyproject.toml by \@2bndy5 in [`26009da`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/26009da17a983b4908613dafe3d6d6956aca4d88)

### <!-- 7 -->🚦 Tests

- Repo updates by \@2bndy5 in [#44](https://github.com/nRF24/CircuitPython_nRF24L01/pull/44)

### <!-- 8 --> 📝 Documentation

- Doc updates by \@2bndy5 in [`b291e6f`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/b291e6f65374e5381fbccc6e772fae65bc542f00)

### <!-- 9 --> 🗨️ Changed

- Update actions/setup-python version in release CI by \@2bndy5 in [`375b37f`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/375b37f3dd03293d3771af95f0facd950ff06140)
- Update broken link in README by \@2bndy5 in [`c6f49b4`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/c6f49b49d3f53ee6c857f6a7f039b739a133f973)
- Merge branch 'master' of https://github.com/nRF24/CircuitPython_nRF24L01 by \@2bndy5 in [`5267423`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/5267423c78f97e790bd968882df49d4b3582d53b)
- Archive built bundles in release CI manual trigger by \@2bndy5 in [`5b69cf2`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/5b69cf2eb6284edba50f0f949e824a2d2a25021b)
- Don't generate _version.py by \@2bndy5 in [`4f3b9ab`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/4f3b9ab3974acc0e792148afdad9778d36fd860d)
- Merge branch 'preparing-for-v2.1.2' by \@2bndy5 in [`4ddf916`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/4ddf916e0f29d677a15793daec049c15fbf303f4)

[2.1.2]: https://github.com/nRF24/CircuitPython_nRF24L01/compare/2.1.1...2.1.2

Full commit diff: [`2.1.1...2.1.2`][2.1.2]

## [2.1.1] - 2022-06-16

### <!-- 3 --> 🗑️ Removed

- No more upy by \@2bndy5 in [#41](https://github.com/nRF24/CircuitPython_nRF24L01/pull/41)

### <!-- 8 --> 📝 Documentation

- Update docs build instructions by \@2bndy5 in [`c800869`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/c800869415275f960f97605c28529f9fa5e679b9)

[2.1.1]: https://github.com/nRF24/CircuitPython_nRF24L01/compare/2.1.0...2.1.1

Full commit diff: [`2.1.0...2.1.1`][2.1.1]

## [2.1.0] - 2021-11-26

### <!-- 1 --> 🚀 Added

- RF24Network, RF24Mesh, and RXing BLE by \@2bndy5 in [#33](https://github.com/nRF24/CircuitPython_nRF24L01/pull/33)

### <!-- 8 --> 📝 Documentation

- Proofread docs by \@2bndy5 in [`0cca768`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/0cca768c4da1383566bc31a131f2ff2c2c446491)

### <!-- 9 --> 🗨️ Changed

- Create CONTRIBUTING.md by \@2bndy5 in [`6cef461`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/6cef461cd5d4f8f37d2b50545b1fc11e09bbc874)

[2.1.0]: https://github.com/nRF24/CircuitPython_nRF24L01/compare/2.0.2...2.1.0

Full commit diff: [`2.0.2...2.1.0`][2.1.0]

## [2.0.2] - 2021-05-05

### <!-- 9 --> 🗨️ Changed

- Create FUNDING.yml by \@2bndy5 in [`da1f21b`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/da1f21b26d13b1ab6fddaf691c871cec0e9e8218)
- Ignore duplicate code - I'm painfully aware by \@2bndy5 in [`dd40503`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/dd405038aebd74a42862620dccbcbc23770f46d5)
- Update FUNDING.yml by \@2bndy5 in [`69c883e`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/69c883e0e9b8b365f59ba44703c147487743a3b0)
- Update rf24.py by \@bhartung in [`3979243`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/39792433eec5f0638e15a574ce5c605dd9d65684)
- Merge pull request \#27 from bhartung/master by \@2bndy5 in [#27](https://github.com/nRF24/CircuitPython_nRF24L01/pull/27)

[2.0.2]: https://github.com/nRF24/CircuitPython_nRF24L01/compare/2.0.1...2.0.2

Full commit diff: [`2.0.1...2.0.2`][2.0.2]

## New Contributors

- \@bhartung made their first contribution

## [2.0.1] - 2021-01-29

### <!-- 3 --> 🗑️ Removed

- Update adv API docs; remove redundant call in init by \@2bndy5 in [`4385bd6`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/4385bd64cddf3dd92e8d8257ba71f30048a58712)

### <!-- 8 --> 📝 Documentation

- Proofread BLE API docs by \@2bndy5 in [`60e2a99`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/60e2a991c866a914e6b56bc6f3508046b473ee5f)
- Correct docstrings in ble example by \@2bndy5 in [`e63d82b`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/e63d82b880537c7e09bf884accd43d657fd2e7af)
- Update basic API docs by \@2bndy5 in [`6135912`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/6135912aab9b007a2b77ca76fc3f5ef3ea1b2d72)

### <!-- 9 --> 🗨️ Changed

- Update greetings.rst by \@2bndy5 in [`0afacde`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/0afacde247ed7523f7413185fd364d56a2db9c38)
- Save unecessary new lines in BLE_FREQ src by \@2bndy5 in [`bdff835`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/bdff835a0c7a6c929fbb26209e99a0f5abe8a74c)
- Update BLE limitations list by \@2bndy5 in [`813002e`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/813002e09a86f514d2382c7341b4161c56c82356)
- Update get*_() by \@2bndy5 in [`9b8e3c2`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/9b8e3c237038b988b64d1d6bb6a6c7cb8616b7b0)

[2.0.1]: https://github.com/nRF24/CircuitPython_nRF24L01/compare/2.0.0...2.0.1

Full commit diff: [`2.0.0...2.0.1`][2.0.1]

## [2.0.0] - 2021-01-25

### <!-- 1 --> 🚀 Added

- Add set_retries() function by \@2bndy5 in [`90edaa3`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/90edaa33f39e4b95871a869e9daf6fa937912854)
- Add allow_ask_no_ack attribute by \@2bndy5 in [`788beec`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/788beec1e834ca22b56f8d8a60a9c1c87133e5cb)
- Add last_tx_arc attribute by \@2bndy5 in [`2a89271`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/2a89271bf0eac83e94665b332cc4bf14f6988b0a)
- Add new favicon by \@2bndy5 in [`ef09851`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/ef09851f11119c19f2e145be10f36ab47b6af622)
- Add hovering popups (beta sphinx-ext) by \@2bndy5 in [`52bc9e6`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/52bc9e6b6c9b73cdb337b214578965e3d1b39837)
- Add the click-to-copy button by \@2bndy5 in [`72253be`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/72253beb2a7239c27618d158330a6e9925f65f78)
- Add get_auto_retries() by \@2bndy5 in [`6ed161c`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/6ed161c3f49d1aeee40494af1502db27bc90dc8b)
- Add troubleshhoting link to top bar by \@2bndy5 in [`e34e0d3`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/e34e0d3a79fd1715aeee4ba6bcf172c15e217949)
- Add scanner example by \@2bndy5 in [`d364b11`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/d364b1152ba541d09b7090f97bfb7fc7a2d754c7)
- Merge pull request \#23 from 2bndy5/wireless-hid by \@2bndy5 in [#23](https://github.com/nRF24/CircuitPython_nRF24L01/pull/23)
- Add a link to atricle about clones by \@2bndy5 in [`6f544d9`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/6f544d9e92104b291793d4ef8c5075fc285867e2)
- Add BLE stuff to print_details(), set BLE RX addr by \@2bndy5 in [`6f8e262`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/6f8e2629893447f7428da670a7950fd6a60cbc18)
- Add hint about wrapping scanner output in terminal by \@2bndy5 in [`03cf057`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/03cf057f129199dd4229d12f74f2f1276773bafe)
- Merge pull request \#22 from 2bndy5/dev by \@2bndy5 in [#22](https://github.com/nRF24/CircuitPython_nRF24L01/pull/22)

### <!-- 3 --> 🗑️ Removed

- Oops remove useless artifact by \@2bndy5 in [`468f694`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/468f694214481ec07b9d2f10c89c4bff88395f5b)
- Update logo & remove relics by \@2bndy5 in [`338a27a`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/338a27a14498f5133273f86c71a6b8894398f962)
- Removed new binascii dependency by \@2bndy5 in [`985c898`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/985c898c57209805efc84466f0bb83fb75a3cf0b)
- Removed last of rtd-sphinx theme by \@2bndy5 in [`38eb680`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/38eb680186f1ce5d97fe1a1c1b0cf6bb2420a007)
- Removed recipes & sitemap generation by \@2bndy5 in [`bf8018a`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/bf8018afe9679fe163ce4800ef90ecee45037e07)

### <!-- 4 --> 🛠️ Fixed

- Fix ctx mgr about pl_len; rely on list IndexError by \@2bndy5 in [`23af426`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/23af4265c30c4c0447e6642777f458a9fc793249)
- Fix docs about auto_ack and dyn_pl attributes by \@2bndy5 in [`f7fe7dc`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/f7fe7dcba20a433d56695a1161ecc28d86902abd)
- Fix code-block in "Using Examples" by \@2bndy5 in [`013c040`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/013c040be914a925fc572b1551998d0ee41cc1ed)
- Fix workflows by \@2bndy5 in [`26b6d91`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/26b6d91050c9aed96afebbd424f7a0bccf5759a6)
- Fix some doc issues on mobile display by \@2bndy5 in [`78b8047`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/78b80479053d67ab71df18ddea2e39802af25641)
- Fix scaling of joystick input for mouse x/y axis by \@2bndy5 in [`ad91e9c`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/ad91e9c82506a32aefd2494f8a0689e370f7e6f4)
- Fix FakeBLE.__init__() by \@2bndy5 in [`1d1c5e0`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/1d1c5e01fccb459681b53c61c6af194e64495b8a)

### <!-- 8 --> 📝 Documentation

- Clarify docs on Re-use TX FIFO & code in update() by \@2bndy5 in [`36c9935`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/36c993521d31fbf887f5feda68f7c48ef148b48e)
- Updated docstr in stream test's make_buffer() by \@2bndy5 in [`70082fe`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/70082fe08b1e798148af3e3e9a576d9ba85dfb93)
- Update example docstring by \@2bndy5 in [`a8d9fb2`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/a8d9fb2d1669839c3fa2cfa64ba582bf7a57994f)
- Doc updates by \@2bndy5 in [`f1a570d`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/f1a570dcf1c4f64977fcaba934f3ef8a7c6f162b)
- Dyn_pl & auto_ack return int; more doc changes by \@2bndy5 in [`7938ecc`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/7938ecc1e6c7d7f0954c58e9502675a1040ba3ab)
- Clarify in docs by \@2bndy5 in [`d50b1ed`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/d50b1ed142947666d137533cd2bdc08e3fca8b79)
- Doc updates + css rule for table captions by \@2bndy5 in [`60af06c`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/60af06c52259c70ea1d4ec851a01a316495463ce)
- Del sidebar link to network api docs by \@2bndy5 in [`dd7a1e7`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/dd7a1e79b954965b25148f7ba3ef69211a2056e4)
- Re-org  docs about TMRh20 & examples use footnotes by \@2bndy5 in [`4263460`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/4263460b505681e6c6479172dc4e54c31c3bd7f2)
- Typos in docs by \@2bndy5 in [`81cc2e8`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/81cc2e80ca03f9a6b353a6601161960b814ae30d)
- Doc typo by \@2bndy5 in [`4b792d7`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/4b792d72720e72351c206a486acd7f13b5567833)
- Docs theme finalized; fix typos; some re-organized by \@2bndy5 in [`b74b24c`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/b74b24c587bdd149c4d1adafba5e56543bc4d2f7)
- Better docs on address_repr() by \@2bndy5 in [`0aee272`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/0aee272077a1d6a0707d05915d2afd49c94825cb)
- Docs typo by \@2bndy5 in [`6192cea`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/6192ceaaed2636007a9851462124edb333268039)
- Ref allow_ask_no_ack attr in print_details() docs by \@2bndy5 in [`7499f28`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/7499f28a19b65742cd9c3e71f1de62b01cd68d48)
- Limit what part of examples is shown in docs by \@2bndy5 in [`1d8585b`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/1d8585b10c2d897832b33cec75c86bb9b0b47ea2)

### <!-- 9 --> 🗨️ Changed

- Typo in examples.rst by \@2bndy5 in [`da0e37d`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/da0e37de95710c4f5af4f9c850d4529f4af1b720)
- Attempt to fix init of _pipe0_read_addr by \@2bndy5 in [`fe3d445`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/fe3d445f31d8359902785095b4093f2479cc8c2c)
- Revert "attempt to fix init of _pipe0_read_addr" by \@2bndy5 in [`8df70db`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/8df70db8bedf7b435b79308acc0709326256d22d)
- Listen won't flush RX FIFO; flush TX FIFO of ACKs by \@2bndy5 in [`6e8eb83`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/6e8eb8313bde160a949476b57767102b684fedc3)
- Typo by \@2bndy5 in [`71a92e0`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/71a92e001b972e42d4c13a61496ae490fba3af51)
- Exit blocking send/resend doesn't clear irq flags by \@2bndy5 in [`4e81319`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/4e81319cec9f1b918071ba9fd8b4edd5d19d6a99)
- Bad indent by \@2bndy5 in [`c9f4573`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/c9f45731494ee37d7a33d09cb39f84630e726dfe)
- Multiceiver doesn't ack payloads; pack TX payloads by \@2bndy5 in [`2063059`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/2063059373d0b4ddf945666b4891ae4fa5fe3299)
- Update fake_ble.py by \@2bndy5 in [`9b11a8a`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/9b11a8a6873897a2113b108fb1706af29e921cdd)
- Use 5 us for CSN_DELAY, not 5 ms by \@2bndy5 in [`6fde888`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/6fde8885096f158dc4de658d0de86c87526a5adf)
- 5us is too short; use 500 us by \@2bndy5 in [`4342334`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/43423341bb3b44a06f5dd5e44c087a8380c43f5b)
- Better csn_delay access by \@2bndy5 in [`d4f283a`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/d4f283a6e864120b4f55e2eeacd35c977cd75ba6)
- Let rf24_lite use custom csn_delay by \@2bndy5 in [`f999f83`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/f999f834865d1655f0a6e273ac6506badc7c07c4)
- (-) any delay < 100 us; examples require py v3.7 by \@2bndy5 in [`004310d`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/004310d55c7fe2e3475d6f1edb9bc88284e8e80c)
- Make workflow use python 3.7 by \@2bndy5 in [`638dcc1`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/638dcc156203d7f74ac9054fe44a621fff899633)
- Adjusted examples and SPIDevice extra_clocks param by \@2bndy5 in [`c380141`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/c38014198a08924d8d3cddbee3519fd21fd7ace6)
- Update release.yml by \@2bndy5 in [`fa3aa31`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/fa3aa31da4319c1113f85f9344565af8f9d44426)
- New example; listen augmented; updated pypi badge by \@2bndy5 in [`0729d64`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/0729d64e10f3e56346ed86fa253dcafab70a708d)
- Adjust prompt about IRQ config in what_happened() by \@2bndy5 in [`6938f55`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/6938f55735f4d8a86ddc7f0abf1263414842c833)
- Use of pipe 0 & examples revised by \@2bndy5 in [`55fd282`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/55fd2824fab9cff4bfec05098c34e36c5666ab82)
- Try saving build artifacts in workflow by \@2bndy5 in [`b363933`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/b36393305ed7aca8fd9a09fe9d58200a8a7f7bf0)
- Bad indent in workflow by \@2bndy5 in [`2caa5a4`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/2caa5a4c6e69cf6fd1e29e57f4d40175afa0dfdd)
- Tiny optimizations by \@2bndy5 in [`802ea4e`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/802ea4e4e5c050f818309dcb609d46a4a6f9cf48)
- Found bug in pl_len; add RF24.available() by \@2bndy5 in [`bb559bf`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/bb559bf7f97032abeb5a6f40dc83e235d5b5eac2)
- Missed renaming a couple FakeBLE.available() calls by \@2bndy5 in [`9577188`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/9577188e6b4c9aa071520760f7b5d3597761e6c3)
- Use available() in any() by \@2bndy5 in [`59da7e8`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/59da7e87d4e0e3a07eae6ef5d17e791cdb716938)
- Testing examples; found typo in available() by \@2bndy5 in [`35cce65`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/35cce654a184987426fd69d553bc4716e3de1d69)
- Keep CE HIGH while STATUS flags reports nothing by \@2bndy5 in [`6ae4a59`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/6ae4a59046aa07d57f16f3a75f739616fbc21720)
- Revised auto_ack, dyn_pl, & ack attributes by \@2bndy5 in [`173f913`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/173f913da4d849cf6947d06499abcee2e6cd9ba1)
- Revert "typo" by \@2bndy5 in [`4480758`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/448075808f522d90c6581718e38bec408c949deb)
- Revert "listen won't flush RX FIFO; flush TX FIFO of ACKs" by \@2bndy5 in [`66fa552`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/66fa552cfbe655e9df021316240b1f8f9cce3b47)
- Merge branch 'master' into dev by \@2bndy5 in [`ca8b60d`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/ca8b60dcb08a2e75598910074870a55ad9feadb2)
- Self-reviewed PR changes by \@2bndy5 in [`5c7398e`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/5c7398eda3bbc3ce95eb342e5c2d4917da3ad4b5)
- Use internal attribute instead of self.ack call by \@2bndy5 in [`11a3e3f`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/11a3e3f8d6e9aed62595fb87f309a2021ec64bc0)
- Clamp bad inputs to ard, arc, crc; no exception by \@2bndy5 in [`c78bd08`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/c78bd08836fbe396e9e03294d7288d89bd75868c)
- Rf24_lite listen flush_tx() upon entering TX mode by \@2bndy5 in [`4f4900a`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/4f4900abf6e3ef9deac5fe5a57c1612038f712db)
- Prepare for 2.0 by \@2bndy5 in [`13c609b`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/13c609b4e0976d6157baf15c9cb8f39a4a4ec88e)
- Rename recv() to read() by \@2bndy5 in [`3bd3027`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/3bd30270ab8b65119f3f554232beb9ace80ac5ed)
- + notes on allow_ask_no_ack for ask_no_ack params by \@2bndy5 in [`18a3476`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/18a3476d40f73c61bc6c80764f557c9558f10ea6)
- Explicit rule for caption text by \@2bndy5 in [`e735d1c`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/e735d1c260cecb6daf270f1312160dc2a1e8623d)
- Oops rf24network seems to be in this branch now by \@2bndy5 in [`335d862`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/335d862b58d74410c488f89388136f091a5fc321)
- FakeBLE inherits; new logo; index troubleshooting by \@2bndy5 in [`207bb35`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/207bb352ae0f941dcf5acd7e3deb6f32ac8cf32f)
- Del old favicon by \@2bndy5 in [`7753ac3`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/7753ac35b777c8c562a6c670159e68e4dfb9e7f3)
- Forced EN_CRC bit doesn't show in reg if AA is on by \@2bndy5 in [`247a57b`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/247a57b0b96a1ad8c1da199f4a6360b2c9dea171)
- Auto-ack independent of dyn_pl by \@2bndy5 in [`b8dc907`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/b8dc907e364fff82f6b342ec3fa300538358e376)
- Consistent examples about TMRh20 compatibility by \@2bndy5 in [`b9df72a`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/b9df72a15e7c66ded80bf5c057ce53e2bff2bfec)
- Move admonished note about auto-ack by \@2bndy5 in [`4020074`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/4020074946365b8c2333814b294badc35b878e28)
- Oops should've rtfd by \@2bndy5 in [`b83179d`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/b83179dbf1e77507d483e58b665ad23da7b7bbf4)
- Switch rtfd.io to material theme by \@2bndy5 in [`bdfd277`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/bdfd27783c8e993e86250cc86db98e45a8a7ee14)
- Use correct lib/repo title by \@2bndy5 in [`9ca1d78`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/9ca1d782ace7f9c0d2b4354a43c0af92b8013c6a)
- Move troubleshooting to after API refs by \@2bndy5 in [`9c07c96`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/9c07c96caaea1455e0adc3db2fec40348ea48579)
- What_happened print_details by \@2bndy5 in [`a7ce386`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/a7ce38643a892c7d5f661facfd6eb5a5532879e7)
- (+) RPD to rf24_lite by \@2bndy5 in [`d4f9aa0`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/d4f9aa0c870c4592631e853eb2479eede48370e7)
- Merge branch 'dev' into wireless-hid by \@2bndy5 in [`396d195`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/396d19525253451b85e943f908418cd6dac0dc1d)
- Properly close pipe 0; 2nd draft of HID recipes by \@2bndy5 in [`33eda64`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/33eda64332465e2339be4bf95fc9da955413a86a)
- Avoid bad address format by \@2bndy5 in [`f1ea4c4`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/f1ea4c459a87bfb70cc3adf59cb258c8c181e8ea)
- Display hexlified addresses in proper big endian by \@2bndy5 in [`8717f11`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/8717f11e94f180cef60d9629ff867d3d263333cd)
- Update nrf24l01_scanner_test.py by \@2bndy5 in [`2d6becd`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/2d6becdac588306ab00735acad24ceee9c35ce11)
- Prepend "0" to adress bytes <= 15 by \@2bndy5 in [`c0a3a85`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/c0a3a85271301f8c32df226c417dd71315035b53)
- Try to diagnose man_ack_test by \@2bndy5 in [`29a1639`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/29a16392142d7a8f3f3cfbea7aef3c6feefeebf9)
- Use time.monotonic_ns() by \@2bndy5 in [`7b0adad`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/7b0adad4b6552b1b6ff60050ee429ceff2bce746)
- Better scanner output in REPL by \@2bndy5 in [`040f9dc`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/040f9dc545be8409809dbabbc7917cca1491002a)
- Explain how to read scanner output by \@2bndy5 in [`e4ea72c`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/e4ea72c455e3a8682076237da2eaf8a81a342ab6)
- Change color of blockquotes by \@2bndy5 in [`3c827cd`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/3c827cd1307f527d57c05560e395bc71bee62a38)
- Try that again by \@2bndy5 in [`62c472e`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/62c472e24d0e4c15db3fdd8931fb7e4a67b56594)
- Something is wrong with blockquotes on rtfd.io by \@2bndy5 in [`1db71ac`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/1db71acfc3f1ecec6d6cc089993f45e337890ac8)
- It was my browser: using blockquotes is fine by \@2bndy5 in [`06fbbfe`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/06fbbfe6df0343e5580a96586cbe745eec83febb)
- Let examples run from CLI by \@2bndy5 in [`5d27e41`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/5d27e4185002ad1c635bb1e2ea196e040505df0e)
- Forgot an elif after return by \@2bndy5 in [`14909f0`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/14909f0f6ea7d2162fb218a3216a6d3c479cb6fe)
- Uniform examples' imports and layout by \@2bndy5 in [`ed3d867`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/ed3d8671283964e393e016985cf5d0158f8ceba6)
- Update greetings.rst & examples.rst by \@2bndy5 in [`1e7336f`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/1e7336f60dc07d6e834c4634b5b99f9b060c437d)
- Wrong timeout val in manual_ack test by \@2bndy5 in [`34cc874`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/34cc87489c224d33b3e0fa281e82a53dbcb7d570)
- Wrong timeout in slave() man_ack test by \@2bndy5 in [`d2114f9`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/d2114f9910edf5e3aabf2023d9f63cc66f657c33)

[2.0.0]: https://github.com/nRF24/CircuitPython_nRF24L01/compare/1.2.3...2.0.0

Full commit diff: [`1.2.3...2.0.0`][2.0.0]

## [1.2.3] - 2020-10-16

### <!-- 8 --> 📝 Documentation

- Correct attribute ref in RF24.ard docs by \@2bndy5 in [`0697382`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/0697382cb8e6a3e00f7d4fa707e78255dbc62af1)
- Corrected docs about fifo() by \@2bndy5 in [`03a8ade`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/03a8ade17656bdb52d0f2c56f5da5ea6fa9aa12b)

### <!-- 9 --> 🗨️ Changed

- Updated ACK test; typo in multiceiver test by \@2bndy5 in [`4d4bfcf`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/4d4bfcff8ad2a61c619a188be7d7fd80be05d9f4)
- Playing with write() by \@2bndy5 in [`457a121`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/457a121d5107d756ed238571a70b2438298d11db)
- Merge pull request \#20 from 2bndy5/repeating-payload by \@2bndy5 in [#20](https://github.com/nRF24/CircuitPython_nRF24L01/pull/20)
- Oops forgot to change this back by \@2bndy5 in [`9439e4c`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/9439e4cab94afbe538ad149f7c298e754a852891)
- Replaced another "if any()" in 2arduino test by \@2bndy5 in [`db19a94`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/db19a945b3f6c54d35991d7dfad06fdc22182c22)
- Simple 2arduino pass; 2arduino behaves like TMRh20 by \@2bndy5 in [`74c3d52`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/74c3d52cd3756885f792da04af36a52edab9a4be)
- Appended prompt in 2arduino by \@2bndy5 in [`b101534`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/b101534c616be7eabece3cbd6987e7c4b7c53a3c)

[1.2.3]: https://github.com/nRF24/CircuitPython_nRF24L01/compare/1.2.2...1.2.3

Full commit diff: [`1.2.2...1.2.3`][1.2.3]

## [1.2.2] - 2020-10-09

### <!-- 9 --> 🗨️ Changed

- Extremely rough draft by \@2bndy5 in [`729d8f3`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/729d8f385ba2ec529677b9dc565ecac12081ee9f)
- To_iphone attr -> to_android attr default is True by \@2bndy5 in [`a70d87d`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/a70d87d7724c134b0b16ede3f33d9a5efc612f4a)
- Mark to_android for deprecation by \@2bndy5 in [`6b77ad6`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/6b77ad6be8f15d9ae4199d9ad5dbd542af9dc132)

[1.2.2]: https://github.com/nRF24/CircuitPython_nRF24L01/compare/1.2.1...1.2.2

Full commit diff: [`1.2.1...1.2.2`][1.2.2]

## [1.2.1] - 2020-10-07

### <!-- 1 --> 🚀 Added

- Add intro prompt by \@2bndy5 in [`1b2779f`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/1b2779f70287cf6dc02753eb5b4e963d1f293a6c)

### <!-- 4 --> 🛠️ Fixed

- Fix payload id instance by \@2bndy5 in [`016622e`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/016622e26798a9f529fdf69475636dabf6cd6a7b)

### <!-- 8 --> 📝 Documentation

- Docs are vast; need for proofreading is endless by \@2bndy5 in [`96d0055`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/96d00552bbf6b232e28e6463ebd8b46125d19239)
- Update docs; multiceiver example works (w/ ACK) by \@2bndy5 in [`763fad9`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/763fad98b578236fe3bb43d5187097c8881ddacc)

### <!-- 9 --> 🗨️ Changed

- Release.yml use pkg folder name by \@2bndy5 in [`7ee8f74`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/7ee8f740e4005af70ef518cfaf59b07fef6568ac)
- Build.yml use pkg folder name by \@2bndy5 in [`1c64e91`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/1c64e91433559ef46f48679d8e03eaa937ce624b)
- Untested! add example of multiceiver by \@2bndy5 in [`7e78c63`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/7e78c63ee763a343965852d7c81bca7caf5fa10a)
- Oops; rookie typo by \@2bndy5 in [`17ca3f6`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/17ca3f66e9be591d5e954c7df1d1c095a62eff33)
- Pleasing pylint by \@2bndy5 in [`2da6a50`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/2da6a50194f32d4963ab32225c8d23553620443c)
- Example compatible with rf24_lite.py by \@2bndy5 in [`b7c7399`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/b7c739982a4cc669d2eacb798108d036168c3f32)
- Avoid inf loop in node() by \@2bndy5 in [`073ecd0`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/073ecd03746fe80f789673fe908c97a3c555aa54)
- Garnish example with comments by \@2bndy5 in [`20aa842`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/20aa8428adb104b2370f29220c58d9cf87c97786)
- Prepend payload id with node id by \@2bndy5 in [`52b54b7`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/52b54b75f43f277e42e2dd9a3c3caa850e24e297)
- Merge pull request \#17 from 2bndy5/multiceiver by \@2bndy5 in [#17](https://github.com/nRF24/CircuitPython_nRF24L01/pull/17)

[1.2.1]: https://github.com/nRF24/CircuitPython_nRF24L01/compare/1.2.0...1.2.1

Full commit diff: [`1.2.0...1.2.1`][1.2.1]

## [1.2.0] - 2020-10-06

### <!-- 1 --> 🚀 Added

- Add build-tools output to gitignore; fix no _spi by \@2bndy5 in [`510effd`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/510effd9717fb23cc929261226ad2ad87393e617)
- Add flag for broadcasting to iPhone by \@2bndy5 in [`7b6997e`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/7b6997e6d688954430844f0ca30c75f71585ce3c)
- Merge pull request \#16 from 2bndy5/BLEfake by \@2bndy5 in [#16](https://github.com/nRF24/CircuitPython_nRF24L01/pull/16)
- Merge pull request \#14 from 2bndy5/lite-beta by \@2bndy5 in [#14](https://github.com/nRF24/CircuitPython_nRF24L01/pull/14)

### <!-- 3 --> 🗑️ Removed

- Migrated breif docstring back to rf24.py & removed all option args from __init__() by \@2bndy5 in [`725bd3e`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/725bd3ec387ae86aeaa2bdba9c774cadeae7d40c)
- No more timeout calc; payload_length attribute changed by \@2bndy5 in [`e0d5e6c`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/e0d5e6c19af7c6e5a93df7caa1342c4774b60af0)

### <!-- 4 --> 🛠️ Fixed

- Fixed examples accordingly by \@2bndy5 in [`243eb3c`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/243eb3cdc653a57f0c97892cdc85d54d39a35566)
- Fixed gitignore for "build" actions by \@2bndy5 in [`fb07eb4`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/fb07eb468e17189bc08a2bd8f4754d053f2b497d)
- Fix result ref'd b4 assignment in send() by \@2bndy5 in [`d19f848`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/d19f8488105ecdd1d22bdfdd1cf34cb301b48a26)
- Fix address() returning long bytearray of 0s by \@2bndy5 in [`d6be50f`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/d6be50f3b2d4c94ebb6d8a9297d3012736ddf74a)
- Fixed saving address shadow copy in open_tx_pipe() by \@2bndy5 in [`9dc34b9`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/9dc34b9deb360aff39a368edc1403bc980c1395d)
- Fixed 2arduino example; it works w/ TMRh20\@v1.3.9 by \@2bndy5 in [`73a8896`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/73a88964b4b6c80d4384c8244b9f74dc7148435e)
- Fix sphinx build by \@2bndy5 in [`47ce366`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/47ce3660a225d74b558aa31de4ba03ac79425737)
- Fix bug when padding static payloads by \@2bndy5 in [`b3a839c`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/b3a839cb561d1455bdca3ec39a86ebc77ea875ae)
- Fix ref in docs by \@2bndy5 in [`3383006`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/33830062215fcc283c7f94a071d9cb2a93b2f74b)
- Fix fake_ble docs not showing completely by \@2bndy5 in [`384eb64`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/384eb642371203feeca6759fc5e6b041d9ea7402)
- Fix load_ack() in lite ver; FakeBLE.enter modified by \@2bndy5 in [`29bb9ea`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/29bb9eaacdfef1eefb58bfeb89cd3e93ea149725)
- Fix URLServiceData.uuid property by \@2bndy5 in [`7ed6adb`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/7ed6adb1ba9052356c6c916fac14ea1dd1faa5ec)
- Fix bugs about ctx mgr & prompt in what_happened() by \@2bndy5 in [`5c2c4c1`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/5c2c4c142841f53672f24f1dfd84cb142acdcd86)
- Fix ble example by \@2bndy5 in [`38f8cf1`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/38f8cf116fa75f61e3e365f4c219a44e8c058e3d)

### <!-- 8 --> 📝 Documentation

- Docs badge links to stable releases by \@2bndy5 in [`756e7f9`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/756e7f918b34f1aa34e031527e6fd272080e2268)
- Migrated docstring to api.rst by \@2bndy5 in [`b4a0577`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/b4a0577205fd47351d17fa2353e483143cd4d95d)
- Docs tweaks by \@2bndy5 in [`61fef47`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/61fef475e719fd58d714a6e197ede1769913aebf)
- Reducing even more! documented changes in lite version by \@2bndy5 in [`b1a9c0d`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/b1a9c0d84a755e26bbacde7c93b775c1f76aa705)
- Oh-k fixed docs about "pipe" by \@2bndy5 in [`cd2ec4a`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/cd2ec4ac03d540cad6c5c56c90b9ed7e11849c81)
- Typo in docs by \@2bndy5 in [`53b18de`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/53b18de124f4448561cac0056167d44fca03c383)
- `pipe` does not call `update()`; doc tweaks by \@2bndy5 in [`3e130e6`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/3e130e672e92ed16c631bfc6ef34270d987adc14)
- Some doc revision; pipe doesn't call update() by \@2bndy5 in [`db1e1dc`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/db1e1dc221ffc11f9494444db978d7abd0884685)
- Doc tweaks by \@2bndy5 in [`2f1893d`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/2f1893de64ed7de78fa4d019f2da127f5f6f28bf)
- (+) per pipe control; increased SPI baudrate by \@2bndy5 in [`20a6d9e`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/20a6d9efaa207c8f01aee540754a6b2223a290dc)
- (+) carrier wave funcs; example code in API docs by \@2bndy5 in [`82f7ceb`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/82f7cebce7b393defd954413fe85fcd078a2bd73)
- Move rpd in docs closer to carrier wave funcs by \@2bndy5 in [`ffd7229`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/ffd72293196ee47c7b8f1840b41ed960dc1cc78f)
- (+) configuration API to match TMRh20 docs by \@2bndy5 in [`ad41d57`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/ad41d57bea44feec9ae21074c37664c541b4ebb7)
- Documented spi_frequency, a kwarg to c'tor by \@2bndy5 in [`d968234`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/d968234ca0aebe9b7c90d08a01fca53be25f6e06)
- Typo in c'tor docs by \@2bndy5 in [`b0d6f3a`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/b0d6f3a439766ae8d59c958ce8e227e92426f73a)
- Specify units for spi_frequency kwarg in docs by \@2bndy5 in [`81892a5`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/81892a5429585400c1c9011d3fb18480fc1b8972)
- (docs) this will do for now by \@2bndy5 in [`6cab1cc`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/6cab1cc20de5028d85c398c820fe63e9dd295cee)
- Docs build; FakeBLE ctx independent of RF24 ctx by \@2bndy5 in [`259d45d`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/259d45dd6a751166b4f4bf612bc4cebacfa58be6)
- Updated docs by \@2bndy5 in [`a8b411a`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/a8b411a99244450ba5cd5ddb5f07639a4e9638b0)
- Expanded docs on whiten() by \@2bndy5 in [`9d69545`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/9d695457aa1ac565078418b15dc284c1b1b1d414)
- BLE capabilities are very limited; updated docs by \@2bndy5 in [`c3d5b10`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/c3d5b10e1c005f9e8ad256cb3942d37fa7508c8d)
- Error in docs about send() return values by \@2bndy5 in [`5dbe4d8`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/5dbe4d88393438fedc48cd6d5dcddc3f0599acfa)
- Clarify docs about UrlServiceData.pa_level (\@1m) by \@2bndy5 in [`bdebe07`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/bdebe07e17fa347f4313f9d0ff5cdcf1ef5b41b1)
- BLE data_rate is fixed; some docs improvements by \@2bndy5 in [`8f9d071`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/8f9d0712700ae6a67d8db8dbb1587822ac92b1da)

### <!-- 9 --> 🗨️ Changed

- Delete .gitattributes by \@2bndy5 in [`c095747`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/c0957474b2c51dc90c5f6b9d60955646ad51bb48)
- Valid names: irq_D* => irq_d*, ce => ce_pin, etc by \@2bndy5 in [`422896b`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/422896b2a8584361e2bac24752b97fcc62ea9829)
- Changed spi bus attribute to a hidden attribute by \@2bndy5 in [`3a2e18b`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/3a2e18bde7c7ee0104781ad0476107806a0e23bb)
- Context manager powers down radio on exit by \@2bndy5 in [`c215be6`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/c215be6eaf829ac1564d45ded105a0349d5e6f25)
- Found pin conflict in irq example -> uses d12 now by \@2bndy5 in [`27d2d60`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/27d2d60dd01a43479f58ef1013508cd72e92e852)
- Updates from logitech-mouse branch by \@2bndy5 in [`0b25dd4`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/0b25dd4a0e3f56eaa9134d02956685b621e92932)
- (-) experimentals from logitech-mouse branch by \@2bndy5 in [`fb93219`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/fb932193ccd64df9366b66d7cca6abeaee514aa8)
- Updated darkness.css for sidebar menu by \@2bndy5 in [`d493723`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/d4937237162a6528086f7c4b572a5854caeea13d)
- Updated examples for new returned format of send() by \@2bndy5 in [`40746e2`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/40746e21577a21179faf807f67fea99b1cb79503)
- Blank __init__.py, (-)  most comments, & (-) reset param in close_tx_pipe() by \@2bndy5 in [`53cd095`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/53cd0958ffffc25ea6fb5d7abcc550bdfca825a6)
- Indentations use tabs (saved 5KB) by \@2bndy5 in [`e0c3d9c`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/e0c3d9c6bbb64f600ed5575f1ce1e9505c933644)
- Rf24_m0.py works on trinket and feather express by \@2bndy5 in [`90356f7`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/90356f76472c3c87b504ea77b74a9b310ee469ea)
- Readying github actions & updated examples' import statements by \@2bndy5 in [`e88e140`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/e88e140e4aa573477d03bf312e1740624826f4fb)
- Create build.yml by \@2bndy5 in [`4f2e9e9`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/4f2e9e9f4d503ffe23f184890bfea5022d6db40a)
- Update build.yml by \@2bndy5 in [`55b8186`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/55b8186b4a7374cf04eae3d47062bc9adf455bff)
- Using template for repo name in "build assets" job by \@2bndy5 in [`0e9fc31`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/0e9fc313eadd3c4d99dbcd33ad008305f14d5c5c)
- Renaming file for implicit meaning by \@2bndy5 in [`65d3b63`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/65d3b63becb2c30040ce10f89599185acd2e83c0)
- Update rf24.py w/ some optimizations from lite ver by \@2bndy5 in [`73ede45`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/73ede457af5f794ee297d6568fa6c64f016c07df)
- Works w/ tinypico (esp32) by \@2bndy5 in [`cbec57d`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/cbec57d8dac897f122a31774c99de918219b7770)
- Disabling too-many-locals check by \@2bndy5 in [`a3d898b`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/a3d898b7a0f85b3b65973ffcb8aad95ff837e0c1)
- "pipe()" is now read-only attribute "pipe" by \@2bndy5 in [`868325b`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/868325bd53d05124973f70372c8a1d5009e77c41)
- Weird sphinx complaint about indent by \@2bndy5 in [`c856f0b`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/c856f0b0bf2b348d3994d03c04ade06d94c1bbaa)
- (-) `pa_level` from lite ver by \@2bndy5 in [`e924bcd`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/e924bcdc34e0c9a68e55bdc2aa016fc3d03ba52d)
- Formatting fixes; (+) pipe & rpd in lite ver by \@2bndy5 in [`141b2fe`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/141b2fe687b0cda12ee0781a5c359ff75237b3ca)
- Use self._addr_len in open_rx/tx_pipe() by \@2bndy5 in [`58d88d9`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/58d88d9e4cddeca3f092c4b6d673b7a34aadb0eb)
- Typo in readme; change to csv-table by \@2bndy5 in [`cff9267`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/cff92671394b70467067e5dfdb4f6b1ce95dec0a)
- Debugged context example & what_happened() by \@2bndy5 in [`d80db74`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/d80db74f2dc33ff70d9de60b81a96e3394a598fc)
- Improving returned results from send() by \@2bndy5 in [`9ec3a43`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/9ec3a433caa764ca9606a3f7c104596c04ed1607)
- Make simple test more successful by \@2bndy5 in [`10de8e4`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/10de8e4b469d41efb4ff82af02bf166f2e14f859)
- Make ack_payload example more successful by \@2bndy5 in [`784ad6f`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/784ad6f388684bfd7b9778f45fa6c2474526df1b)
- Adjustments for rf24_lite.py by \@2bndy5 in [`0c4f982`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/0c4f98269739527b4900b88b4118635cc32ea812)
- Pleasing black and pylint by \@2bndy5 in [`f8b4fe8`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/f8b4fe82d9e3162908e2fa612a3160749fd72522)
- Proofreading by \@2bndy5 in [`08cbc58`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/08cbc58f6a51c2c075102b96ba51834cafd376ee)
- Enabling github actions by \@2bndy5 in [`b6a6dd0`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/b6a6dd01feb7f8d37ff2f428f7b22744b601f004)
- Deleting travis.yml by \@2bndy5 in [`bc41e97`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/bc41e977784bd5964dbcf396a2b0c2f914071dda)
- Update badges & prepare switch to github actions by \@2bndy5 in [`c766f26`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/c766f26e6410ecf1bca763a296334ac31b69f15e)
- Badge missing target link by \@2bndy5 in [`afb35b8`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/afb35b836bbb0c6d0db74a64d4edfc1f97d4d9d4)
- Found typos by \@2bndy5 in [`29350e9`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/29350e93c9da84a2a0ee2ef1d65ee2d53fe7f59a)
- Merge branch 'master' into lite-beta by \@2bndy5 in [`b9e8249`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/b9e8249f9a46ccb2ec31edaee6c2b2270933ed9c)
- Merge branch 'lite-beta' of https://github.com/2bndy5/CircuitPython_nRF24L01 into lite-beta by \@2bndy5 in [`e00d2ba`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/e00d2babab3f2648d701c88170c99e9fa420c776)
- (-) addr_len check on functions about pipe addr by \@2bndy5 in [`cc50da9`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/cc50da9903654dc5562e6b1045493043fbfb03ee)
- Condensed listen.setter by \@2bndy5 in [`6c3930f`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/6c3930fd2886e24bdb50525733211c1f55514ab9)
- Multi-payloads rely on write() format check by \@2bndy5 in [`878523a`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/878523a3a5d7d5dc4f8a512cc276562877dc7e06)
- Prioritize init(); get HW check done 1st by \@2bndy5 in [`af0dcea`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/af0dcea9f0a230ec2a3f99692ecd2743fd4d3f23)
- Keep _pipes[0] mutable by \@2bndy5 in [`8370ade`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/8370ade655a29c133580f7fd79e2a2b671f82482)
- Recv() exits RX mode while fetching payload by \@2bndy5 in [`e2244eb`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/e2244eb10f3ace5ff7c46dd67b1d17ebbbca6bb4)
- Undo last commit; any() uses update() & pipe attr by \@2bndy5 in [`319dd69`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/319dd69d638d38df5767dc59b23adb9ff0721c6a)
- Pleaseing black by \@2bndy5 in [`db43af0`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/db43af0b62f177ebb2d6a9ca17fcdde90107ffac)
- (+) info about SI24R1 in readme by \@2bndy5 in [`aab82e8`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/aab82e881da374872d98317ee6dc9488eb91192f)
- Cleanup; lite version works; 2arduino = no joy by \@2bndy5 in [`45cfb54`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/45cfb54cf8299db3b25151ee1740517b185b472b)
- Use LNA_HCURR bit; mod'd readme about clones by \@2bndy5 in [`504f0f6`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/504f0f6362de3cc0f86cceb5331e1f7c30e8e143)
- Lite.mpy size down to 10252 bytes by \@2bndy5 in [`d2bb51c`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/d2bb51cc311ed993e86a0261a6bb1ca69a42bebb)
- Recv() takes length arg by \@2bndy5 in [`d148090`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/d1480906049538dfbae0fb3b8a23527ec7ab5d8e)
- Use latest pylint and black in buld.yml by \@2bndy5 in [`01f4b53`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/01f4b53f73f8ea03f4afbd89728924c4268fb132)
- Revise info about recv()'d data by \@2bndy5 in [`6dfa00f`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/6dfa00ffbffe2628fed0fc3af205460d7f620897)
- Enable LNA by default; discuss PA/LNA in readme by \@2bndy5 in [`f2594e3`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/f2594e33d47d03cc05a67275fe297d0bf9225875)
- Enable auto_ack when dynamic_payloads are enabled by \@2bndy5 in [`1c0fe3c`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/1c0fe3cfd135329c7f7e986660462258db7af1fc)
- Typo by \@2bndy5 in [`07a81b9`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/07a81b9e44bf31e6266e9027bc09e15ec8c378b8)
- Update from logitech-mouse branch by \@2bndy5 in [`3ad18e5`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/3ad18e5368dc0c9f2b74c7442b5a017020b3c0d8)
- (-) sniffer/logiMouse (+) fake_ble back in by \@2bndy5 in [`03033a6`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/03033a6c541e9b660f7b61f5dde076efc04fb9b1)
- Pleasing travis & pylint by \@2bndy5 in [`88acd6a`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/88acd6a0b0ae10e029cdbcbffca1dc20708cd05b)
- Forgot i renamed those vars by \@2bndy5 in [`a5008aa`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/a5008aa8e432a7f1a577edd5e02eadc36fa68375)
- Decided to not inherit RF24; now a class wrapper by \@2bndy5 in [`1b7651e`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/1b7651ea85b9b5992be30dd214d09f9075bb6fff)
- Manual rebase from lite-beta by \@2bndy5 in [`7707ebb`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/7707ebb2d4ac586ba71096840825c1051308778a)
- Copied crc work from my roboclaw lib by \@2bndy5 in [`5012086`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/50120860be665c869904b623049a3f4d3a0c9f43)
- Payload assembly is broken by \@2bndy5 in [`d8294ce`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/d8294ceeb4ef64226b97c95b28399645aa6f0d67)
- Swing and a miss by \@2bndy5 in [`571ae48`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/571ae4819e91653249d1408e8f456b5d3df46e8d)
- Crc works by \@2bndy5 in [`ccd8be0`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/ccd8be07a9ee8d107aefd494a5ac31e5b4b399d5)
- THIS WORKS!!!!!!!!!! by \@2bndy5 in [`6d8fe91`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/6d8fe917d631080c25c6553e86c6519579fc7fc0)
- Merge branch 'lite-beta' into BLEfake by \@2bndy5 in [`8cff3af`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/8cff3af0efd28a725ba88a3d777c5ccb9ff2317d)
- Update README.rst by \@2bndy5 in [`a88f2fe`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/a88f2fee8d8d2b7b520f502dc6482a3af52323f6)
- Update readme by \@2bndy5 in [`af47fd9`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/af47fd900f6fe26fbffe0ae361bdac4df6e1118f)
- Expose whitening() for future research by \@2bndy5 in [`72c4e6c`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/72c4e6c334a87db6fc0443ebb007e51dbc98c90c)
- Handling data; needs tweaking by \@2bndy5 in [`433e1a7`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/433e1a726fc8db4bfb5bb22e9113a49812245a4b)
- Keep to_iphone true in BLE example by \@2bndy5 in [`a13f331`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/a13f33105b9438fa5c58fd17198da5d87e41ceab)
- Trim trailing whitespace; super w/o args by \@2bndy5 in [`5e9112d`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/5e9112de887ea75c8f26b8d856928996e81ff78f)
- Unused import in BLE example by \@2bndy5 in [`94441f0`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/94441f06139bd81320c0fe6da5521f3ea687f745)
- BLE API toc tree corrected by \@2bndy5 in [`751fb9c`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/751fb9cf528d6b5cef2bdb5baecb4869cc47eeb8)
- This feels stable by \@2bndy5 in [`8cccfcc`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/8cccfcc369f6ee88289910407c08e877015b4e1c)
- Too many ambiant signals to tackle receiving BLE by \@2bndy5 in [`6923190`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/69231906b5841ca17b6145fb192608b1f83e15eb)
- Need to advertise for longer to be noticed by \@2bndy5 in [`dc3f878`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/dc3f87872b46056fb753dd9238dfe8f80a03e97a)
- Clarify UUID attr by \@2bndy5 in [`dc7e247`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/dc7e2479048c179ad5f9fefda7285cb9ae2ecc14)
- Freaking trailing whitespace by \@2bndy5 in [`03f921c`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/03f921c53c4a71cd7eb0b181bb8e80f9798fc0f1)
- Examples use -12 dBm; no debug prompt in rf24_lite by \@2bndy5 in [`c6ea5b1`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/c6ea5b13e8101d1180a229a8d4a7706f5c69387f)
- PR self-review changes by \@2bndy5 in [`350245d`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/350245dfe5fa902cea59cdb064186ef8e7f16c81)
- More backward compatibility for non-plus variants by \@2bndy5 in [`fc97570`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/fc9757050f118c43db0e71b514877e45f5e8df17)
- Clarify relations of dynamic_payloads & auto_ack by \@2bndy5 in [`1f5ed98`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/1f5ed98621aca0c4e15336cf3d1d3f1dbb68722c)
- Reverses bits not endianess by \@2bndy5 in [`d6b6f17`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/d6b6f178ee042dc5614ac191cb88340c2f08cebd)
- Didn't need that import anyway by \@2bndy5 in [`aed6497`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/aed6497b8fe6cec545d40bcfc0158d74eebb3c39)
- New send_only param for send() & resend() by \@2bndy5 in [`e2488d6`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/e2488d6144ff514de2c35cf65faabc93eacc5ba7)
- Skip a pipe if when index's value is invalid by \@2bndy5 in [`36aa0ad`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/36aa0ad67a269b0eecd66a7b36ca9e17884a60b6)
- Readme placeholder; adjust ble example by \@2bndy5 in [`d40f309`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/d40f30988352f1ed6de5398b9e37ec968c3c1b56)
- Testing examples on RPi by \@2bndy5 in [`e5346dd`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/e5346dd71d1387eb02b3e01edf8ef7ff96097a55)
- IRQ test uses ACK payloads; rf24_lite has fifo() by \@2bndy5 in [`4508fc6`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/4508fc6a3ea639df92d08e006216fec4c81cb7e0)
- More proofreading by \@2bndy5 in [`542710a`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/542710a3cb7bada3c5ef49565585d935e2e02b2d)
- Don't flush RX FIFO if send_only==True by \@2bndy5 in [`4d927cc`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/4d927cc133e3773cadde5a5e8f5776e21b403f38)
- Forgot intro prompt in irq test by \@2bndy5 in [`eaf8740`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/eaf8740a4c991614feb3866003d6a719a9fa1cae)
- Use send_only in recursion & during force_retries by \@2bndy5 in [`7e23ad4`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/7e23ad4b454766843a17c61641590044ca7c6785)
- Write() has write_only param for ignoring CE pin by \@2bndy5 in [`568d39e`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/568d39e0bd83ffe7f8c49fa758bf5ebea4e06e38)

[1.2.0]: https://github.com/nRF24/CircuitPython_nRF24L01/compare/1.1.2...1.2.0

Full commit diff: [`1.1.2...1.2.0`][1.2.0]

## [1.1.2] - 2019-11-09

### <!-- 1 --> 🚀 Added

- Added package_folder_prefix arg to travis.yml by \@2bndy5 in [`f014233`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/f01423367754e423ba0adc209a729a0aa33d3edd)

### <!-- 9 --> 🗨️ Changed

- Readme should now render on pypi by \@2bndy5 in [`853ff72`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/853ff724ade6159d5d879e30094d595748ec62de)

[1.1.2]: https://github.com/nRF24/CircuitPython_nRF24L01/compare/1.1.1rc...1.1.2

Full commit diff: [`1.1.1rc...1.1.2`][1.1.2]

## [1.1.1rc] - 2019-11-09

### <!-- 1 --> 🚀 Added

- Added pypi version tag to readme by \@2bndy5 in [`5adb617`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/5adb617c33dc71dff8608e76a95505eb13b7b998)
- Added arduino compat to supported list of features by \@2bndy5 in [`8b09c0b`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/8b09c0b294b8890b9d9e2cfcd523c92af402a35e)

### <!-- 3 --> 🗑️ Removed

- Linked pinout image to source and removed local copy by \@2bndy5 in [`b749018`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/b74901807d219683e1c515603a47f5027a75994c)
- Removed tutorials placeholder in sidebar by \@2bndy5 in [`5aad524`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/5aad524dfeef537a64dd265d6596342186a13462)
- Removed f-string by \@2bndy5 in [`ffd21a2`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/ffd21a2d170d9f93b955015d3d31ae9ca8c0b3a4)
- Removed useless "new lines" by \@2bndy5 in [`6a664e2`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/6a664e250180acfa31f41f7235c774cede693596)
- Removed fakeBLE stuff by \@2bndy5 in [`66aa435`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/66aa435caa0347becb19eebeb78c3857a40a479d)

### <!-- 4 --> 🛠️ Fixed

- Fixed mobile compatibility by \@2bndy5 in [`bbbc2e4`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/bbbc2e4458187661d56b5004b124bc44e6f1d1ab)
- Fix for travis checking ogf examples by \@2bndy5 in [`1e99f45`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/1e99f45256373d1e2b6b32153668d18ea152297b)

### <!-- 8 --> 📝 Documentation

- Various docs tweaks by \@2bndy5 in [`f2d23a5`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/f2d23a55da1fb1ee2cc83730a9f85c835bef941d)
- Some more doc tweaks by \@2bndy5 in [`afc847e`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/afc847e79a01060b2ede39bea399dc618de1656d)
- Learned to cross ref outside autodoc by \@2bndy5 in [`2b4706e`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/2b4706e8330ece29bf9e9c7ca833d724dab947cc)
- Docs build & can import from package namespace by \@2bndy5 in [`f688d79`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/f688d7958836c745e8ff717e3e1dc631ea99eb8a)
- Very experimental!!! by \@2bndy5 in [`8a3e78b`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/8a3e78b4314bbbe40ff706a6b1a47359f5c56481)
- Adjusted docs cuz dynPL is not req'd for autoACK by \@2bndy5 in [`62522b4`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/62522b4641a212b490c68ac53a07066b0f7adb5a)

### <!-- 9 --> 🗨️ Changed

- Merge branch 'master' of https://github.com/2bndy5/CircuitPython_nRF24L01 by \@2bndy5 in [`e8996d5`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/e8996d5bbb02234c1f37610106f6deebf05b9317)
- Another readme change by \@2bndy5 in [`1cdf60b`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/1cdf60b134f198d322517ce60d93f8f3309228e1)
- + pepy.tech download counter from pypi stats :) by \@2bndy5 in [`2faa9bb`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/2faa9bb78d19bc109d9422e1af4a9b8ec3f50e67)
- Tweaked rtd theme with darkness.css by \@2bndy5 in [`3c88b80`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/3c88b80857ca55f07e9307d4da6f31439135eafa)
- Better links for pypi sidebar by \@2bndy5 in [`afe3e5b`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/afe3e5bb66a5494dfe6264d7c96aa09594a412af)
- Background got messed up?! by \@2bndy5 in [`f310e91`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/f310e9135cf5bb2e8559915ec6590eb9587d980a)
- More readable literal text refs by \@2bndy5 in [`f46d919`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/f46d91986fa09d2b03398f572196086c6e28f81a)
- Found a typo in readme by \@2bndy5 in [`c5c4363`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/c5c436366584d232fe75b1418f27540f3396da49)
- Broke the example link by \@2bndy5 in [`43c5a56`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/43c5a56ff5cb97d62cf6fadecc1fd4d9c62b3d99)
- Revisiting pylint warnings by \@2bndy5 in [`8d401a5`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/8d401a5b374da8158335c5029859b40735c1b39e)
- Mpy-cross failed by \@2bndy5 in [`9b746bb`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/9b746bbe200fd6f1634344e78a14a67c6a79f111)
- Wtf mpy-cross by \@2bndy5 in [`f4e1570`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/f4e1570f5c3a3b4eb5c99e91029e432c1d0f7b82)
- This should at least keep pylint happy by \@2bndy5 in [`61b1ba0`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/61b1ba0ea433991170334654497bf6539b5c6ae0)
- Update circuitpython_nrf24l01.py by \@2bndy5 in [`e57aeef`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/e57aeef82404a97e406b08306ae64f89281957a2)
- Del a trailing whitespace by \@2bndy5 in [`0197aff`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/0197aff476f8d591f484836f0249ba3e2af9da1f)
- Consolidated and renamed examples by \@2bndy5 in [`27344aa`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/27344aa930d498cfcae1b7a73fc8447ca3c49703)
- Ignore the whole folder not just settings.json by \@2bndy5 in [`a781908`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/a781908d3969fc9622fe5760333615a18ad05bc6)
- Merge pull request \#7 from 2bndy5/master by \@2bndy5 in [#7](https://github.com/nRF24/CircuitPython_nRF24L01/pull/7)
- No more long lines in base RF24 class by \@2bndy5 in [`62cd61b`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/62cd61bfe695f2869320241747734b14cccf6f93)
- Forgot about travis checking only 1 module by \@2bndy5 in [`a60afd0`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/a60afd093d5131fb2e52f8ac54029c6b32103ed1)
- Probably do without disabling these pylint checks by \@2bndy5 in [`3b6e2a4`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/3b6e2a466b0493af6d73efb5567d447c366db3b1)
- Oh yea, can't avoid these for now by \@2bndy5 in [`e1ed418`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/e1ed4186d95fe0b3f90dea1392392a76db85fc95)
- "no-member" check should be only locally disabled by \@2bndy5 in [`532ddae`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/532ddae06c2d4694fdc8a51bb3fe357f3b0f8a7a)
- Registers now a dict in stand-alone module by \@2bndy5 in [`02e1fad`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/02e1fad3130966b38e5ce3b458deeb2920be0c6a)
- Compatible with TMRh20 lib!!! by \@2bndy5 in [`e97f782`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/e97f782c90db01552eb61e4abb02ff57862d8bc3)
- Arduino lib compatible example by \@2bndy5 in [`08905f1`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/08905f1c1907ad43e71faab17d9993ff45f545f2)
- Set payload length on open tx pipe by \@2bndy5 in [`5bea13e`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/5bea13e6002b2161dcfea31ffecd804a9ee44383)
- Pylint will never be happy w/ complex python libs by \@2bndy5 in [`254bd57`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/254bd57ad6a3e8890fc82b1e5eae680acf93a6c3)
- Merge pull request \#8 from 2bndy5/arduino_compat by \@2bndy5 in [#8](https://github.com/nRF24/CircuitPython_nRF24L01/pull/8)
- Context manager bug fixes + modified example by \@2bndy5 in [`0bb2c53`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/0bb2c5325a04f6f855a2f8a77d2a462d623da4b3)

[1.1.1rc]: https://github.com/nRF24/CircuitPython_nRF24L01/compare/1.1.0...1.1.1rc

Full commit diff: [`1.1.0...1.1.1rc`][1.1.1rc]

## [1.1.0] - 2019-08-26

### <!-- 3 --> 🗑️ Removed

- Removed redundancy from open_rx_pipe() by \@2bndy5 in [`013b323`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/013b32368c320c0dd1898e3634fe2cb0c7994986)
- Removed CnP error in readme by \@2bndy5 in [`9eeb5c8`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/9eeb5c8d7906f15f5d50bf47d983b9e1f7c48e0d)

### <!-- 8 --> 📝 Documentation

- Flush_rx/tx were poorly documented by \@2bndy5 in [`0f8f1b0`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/0f8f1b01fafd94a93bf719d3c83448fe47f6f272)
- Docs should be up to date as well by \@2bndy5 in [`d0bb373`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/d0bb3739025091c7018b01dd735232080334a326)

### <!-- 9 --> 🗨️ Changed

- Typo by \@2bndy5 in [`1e1a130`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/1e1a13049e2fd71931d524b513e6bab9227e994b)
- Duh by \@2bndy5 in [`00616f2`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/00616f2fd06ecaf2e5524bad96477cb044cf7bb4)
- Init() args proofread by \@2bndy5 in [`693cb2c`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/693cb2c24e8abf3bfaa7f11d6fae31e78fb62312)
- Refactored for community bundle by \@2bndy5 in [`16e9314`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/16e93140f4b92367668446bd3460adfb2c5bddd7)
- Pleasing travis CI by \@2bndy5 in [`27db36f`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/27db36f3aae1b29fdce0d32518ade44102a84650)
- My pi won't recognize the RF24 class by \@2bndy5 in [`af9ebc3`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/af9ebc34e481d188db5e9207eede968c31b9f934)
- Merge pull request \#6 from 2bndy5/refactoring by \@2bndy5 in [#6](https://github.com/nRF24/CircuitPython_nRF24L01/pull/6)

[1.1.0]: https://github.com/nRF24/CircuitPython_nRF24L01/compare/1.0.1...1.1.0

Full commit diff: [`1.0.1...1.1.0`][1.1.0]

## [1.0.1] - 2019-08-18

### <!-- 3 --> 🗑️ Removed

- Doc tweaks & removed reverse() by \@2bndy5 in [`51baae6`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/51baae614e4c7f399f92ae6f98e3584144a5f9c4)

### <!-- 8 --> 📝 Documentation

- Changing baud (rpi sux at this). doc revisions by \@2bndy5 in [`ad9fb70`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/ad9fb7053264912fa49c111b87cc493a434e98be)
- Newly ordered docs by \@2bndy5 in [`10e1981`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/10e1981d3ad3db1b03f4d042a56a0042584bd7c0)
- Module doc string required in source by \@2bndy5 in [`0837173`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/08371731ab69978504da0b389754f41495819372)
- Merge pull request \#3 from 2bndy5/docsNstream by \@2bndy5 in [#3](https://github.com/nRF24/CircuitPython_nRF24L01/pull/3)
- Modified _make_crc(). will test this later by \@2bndy5 in [`c2e7778`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/c2e7778ec10bc8b6b1042bdd883c2ccd0c82ba66)
- More fixes to the docs by \@2bndy5 in [`56671a6`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/56671a6f11337a88f892a35b18c57f07431f914c)

### <!-- 9 --> 🗨️ Changed

- Wsl changes in [`6569261`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/656926125020ae0469017f6fb13e01a01d23a02b)
- WSL screwed up committing by \@2bndy5 in [`b1688e1`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/b1688e1ae0ccaefb187342d6bfb0784933453302)
- CRLF vs LF is windows vs linux subsystem by \@2bndy5 in [`ff33bdb`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/ff33bdbe291f8096f0e8fbc36aafd38c7eb0ea2e)
- Polished streaming in send() now gives results by \@2bndy5 in [`059c739`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/059c739d4027778d817f5a5bed1403a17a64374c)
- Raspi deserves python 3.7 time module by \@2bndy5 in [`bfdbc3c`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/bfdbc3cddaa20a98592b8b5fdb2baaf6fe2739fa)
- Re-new  fakeBLE module by \@2bndy5 in [`cce1599`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/cce159975eadffeb3153fbe14e3e0877b0545ba0)
- Pleasing pylint again by \@2bndy5 in [`662f674`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/662f674457b96733d742a40f0140f569a0986e8b)
- New structure w/ init files by \@2bndy5 in [`9d2a93f`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/9d2a93fb2f829f281969f4b1d8c8f5a16d11763f)
- Improved structure in __init__ by \@2bndy5 in [`540d2c9`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/540d2c9125f28f29842ce1a1650599b99e8465f9)
- Why isn't that building by \@2bndy5 in [`8ac2b9b`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/8ac2b9be11d4ec01e51f20e34f1df6a1f06a4d52)
- FakeBLE not ready yet by \@2bndy5 in [`d9ff736`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/d9ff7360db7d1645593e5988cca6a407a7ea43a2)
- Fake ble still broken. fixed bug in PL_len setter by \@2bndy5 in [`86e1b60`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/86e1b60518ab33c83e701c273362b753de459ad6)
- Concise info about IRQ pin by \@2bndy5 in [`74ad126`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/74ad126a495871042fcea5fe54ba2b46cedb405e)
- Unused var by \@2bndy5 in [`93773ee`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/93773eed9508d03b029a919407610ebd5235fcb2)
- Typo using viewcode sphinx ext by \@2bndy5 in [`a6ffd17`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/a6ffd1716db77aa6d279a59f4f375459967f5554)
- Temp rem fake_ble.py by \@2bndy5 in [`c05e7d7`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/c05e7d794b801173751eb171d053fd6cba37ace6)
- Merge pull request \#4 from 2bndy5/BLEfake by \@2bndy5 in [#4](https://github.com/nRF24/CircuitPython_nRF24L01/pull/4)
- Merge pull request \#5 from 2bndy5/BLEfake by \@2bndy5 in [#5](https://github.com/nRF24/CircuitPython_nRF24L01/pull/5)
- Removing for release by \@2bndy5 in [`70204ad`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/70204adbacfbdf439552d6a71d18ebfd2a41e66c)
- Example typos & updates by \@2bndy5 in [`c974983`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/c97498373d9c90154cc1832543ae1faa6e39d49c)
- Readme tweak by \@2bndy5 in [`29e7b1f`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/29e7b1f36d4557d7c7dbb9e4844a221322966ee5)

[1.0.1]: https://github.com/nRF24/CircuitPython_nRF24L01/compare/1.0.0-rc3...1.0.1

Full commit diff: [`1.0.0-rc3...1.0.1`][1.0.1]

## New Contributors

- \@ made their first contribution

## [1.0.0-rc3] - 2019-08-08

### <!-- 8 --> 📝 Documentation

- With self works. docstr changes by \@2bndy5 in [`7c202fb`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/7c202fb3ef474d56ce7ebed3091aaf8fcebb15a2)
- Doc changes; almost stable release ready by \@2bndy5 in [`281293f`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/281293f06f8f1ac005995464c1f4dff6c59138e5)

### <!-- 9 --> 🗨️ Changed

- Prepping examples. by \@2bndy5 in [`8ff405a`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/8ff405affc2acdc1a45c96381f2c2af371778be5)
- Starting in on context managment by \@2bndy5 in [`4222c7b`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/4222c7bbb0e1f0c9fadb8cc110d0d6e478bab3c9)
- Pylint suggestions by \@2bndy5 in [`63892c7`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/63892c7472dee430cf735ebb6f6f7f01e635ddb3)
- Context manager to re-write all registers & more by \@2bndy5 in [`9da1163`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/9da1163819cae4f375953d179d3fce9e527e8a0b)
- I found that random CnP bug by \@2bndy5 in [`0bc151b`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/0bc151b4bd22656f38f0d6a14a0136cea1593a44)
- Should just disable all pylint by \@2bndy5 in [`d0fe468`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/d0fe468b928c8a9135a0572bda4330133b1bb425)
- Merge pull request \#1 from 2bndy5/config2context by \@2bndy5 in [#1](https://github.com/nRF24/CircuitPython_nRF24L01/pull/1)
- Testing lists of payloads by \@2bndy5 in [`5e0e74d`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/5e0e74da09f5413236e2a41f3b2110778bd5f81e)
- Need a pi_test equivalent by \@2bndy5 in [`5c9f58f`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/5c9f58f9c6e3732dee51f67c418af16202d5749e)
- Rx-ing unACK stream of PLs w/ auto-ack on by \@2bndy5 in [`cb6b4b8`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/cb6b4b8e420b0508081112b224751b091f30ef28)
- Send() accepts a list/tuple of payloads by \@2bndy5 in [`7aef74a`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/7aef74a4530514c92fd8be9fe57440d95c7e00d5)
- Polish. new update() for status byte updating by \@2bndy5 in [`532fe8e`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/532fe8e37961b9d4689fe05f221abf173b19dd6d)
- Using update() instead of generic non-op command by \@2bndy5 in [`078f782`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/078f782e056c24d6eb02c9c27fb85a0c5219c36f)
- Sloppy examples: needs cleaning by \@2bndy5 in [`c63f6e8`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/c63f6e83d3e81038ef1233eda7826ba94265e85c)
- Fine. so pylint is ok for checking stupid mistakes by \@2bndy5 in [`15ecf03`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/15ecf0319dd61721a8cffafc5bef4a84a5d73660)
- Wth sphinx by \@2bndy5 in [`09d1f7c`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/09d1f7cf53ac89d014d06816d6d0658fc803f154)
- And not or for while by \@2bndy5 in [`bbd23a6`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/bbd23a674aa9c0ed600c4678c71617bb5db50651)
- Making interrupt test run smoothly by \@2bndy5 in [`62b4811`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/62b4811f80c44528080fb1f2c162c75bf531533c)
- Same same by \@2bndy5 in [`3e6215b`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/3e6215b631a216a383d77b6020d4322797a0801e)
- Sphinx correction by \@2bndy5 in [`308fe32`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/308fe32600f0265b40e6b064a4893f532d9061bd)
- Time to test this polish by \@2bndy5 in [`3b6fade`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/3b6fade5359947af5735477949f2121ccf831104)
- Reversing addresses to try compat w/ arduino by \@2bndy5 in [`270dade`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/270dadebbd6b8538dc327ae58ea637d0727fe02f)
- Pylint doesn't len() to test empty bytearrays by \@2bndy5 in [`1556e65`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/1556e65a0591d31447dd4ee638b07eb4c4a9d9a9)
- So sick of pylint useless errors by \@2bndy5 in [`4275a27`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/4275a275dc9dbe9b1a8cf366e3fc1532958c9734)
- Testing new any() revisions by \@2bndy5 in [`51e746d`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/51e746dbed3ab8f78455cb064f2bc828cbc6027a)
- Timeouts on examples for failures by \@2bndy5 in [`f10932f`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/f10932fbe66923af6086b941b3469529bbf58c7d)
- Oops by \@2bndy5 in [`f0c2d42`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/f0c2d427f6eba7543fd6a3b787195b6305a5d08a)
- That should fix it by \@2bndy5 in [`4dd542c`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/4dd542c2ea70b34d4cfde7f13c0a0aaa12fd3fff)
- Undo reverse address. arduino not reacting by \@2bndy5 in [`2e7466a`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/2e7466a73d0f3deea94685056cee9487d0c17882)
- Polishing examples by \@2bndy5 in [`88da9bd`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/88da9bd5759afff95eff1ac8ed7a4cc7c80e4184)
- Stupid sphinx by \@2bndy5 in [`769cadb`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/769cadb436d48c3425cd7f3241aab04b1028743b)
- Merge pull request \#2 from 2bndy5/config2context by \@2bndy5 in [#2](https://github.com/nRF24/CircuitPython_nRF24L01/pull/2)
- Pylint checking examples by \@2bndy5 in [`cec4dd5`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/cec4dd5e1efe8796c02b10f27ba82797c9a59106)
- See if travis includes examples this time by \@2bndy5 in [`bcdb8e3`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/bcdb8e37493e40bf801e0c98cd091ed3632d3494)

[1.0.0-rc3]: https://github.com/nRF24/CircuitPython_nRF24L01/compare/1.0.1-beta...1.0.0-rc3

Full commit diff: [`1.0.1-beta...1.0.0-rc3`][1.0.0-rc3]

## [1.0.1-beta] - 2019-08-03

### <!-- 8 --> 📝 Documentation

- Ack attribute is read/write (see doc string) by \@2bndy5 in [`d9f2f81`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/d9f2f81276e641dda7741a4b2e624a2785ddf31e)
- Some docs changes by \@2bndy5 in [`151a771`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/151a771b9301a22ab2a0d6bc50602caade6bd0cf)

### <!-- 9 --> 🗨️ Changed

- Check all examples & build all .py in lib folder by \@2bndy5 in [`23e5623`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/23e56233880fe9510e4df1a7ead61ef155618bda)
- Modified setup.py accordingly by \@2bndy5 in [`fee9861`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/fee9861fc583a2e902bcec03ac468d00918b9e59)
- Psuedo ack example by \@2bndy5 in [`984e150`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/984e1509afd43774d838bb90ae40534320ce27ab)
- Circuitpython int doesn't inherit bool?! by \@2bndy5 in [`e73bcc4`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/e73bcc49597035c606433cc0583b548a33390516)
- Mended examples w/ comments n stuff by \@2bndy5 in [`5bff167`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/5bff16780ca7d30d477d95c126788c27130ad8ad)
- Better examples. read_ack() uses available() by \@2bndy5 in [`cbcc015`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/cbcc0150979e14245a6ead3d2ccac98e7d7bc26b)
- What_happened paid off! custom ACK was disabled by \@2bndy5 in [`68650d1`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/68650d163aa5729d27bfbb7d527a7d682d52da87)
- If ack is broken, then BREAK IT MORE?! by \@2bndy5 in [`57012f6`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/57012f65cf3f55a94933ec340f624e12b121db3e)
- Keyboard interrupts are messing w/ SPI bus by \@2bndy5 in [`043bb16`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/043bb16614581c77bed4f7d995ca298e209824c5)
- DebugRF24() in examples added 2 what_happened() by \@2bndy5 in [`f144043`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/f1440437cbd48885cca4f6fe45415ec95c7a1d15)
- Close_rx_pipe() to reset addresses and the obvious by \@2bndy5 in [`bde61eb`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/bde61eb7eee3a3a3c85b062a7302428c11e4437b)
- Back to any() by \@2bndy5 in [`c3c7b0a`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/c3c7b0a69baa51c0c3c42bf0162ad814d16da532)
- Pylint error by \@2bndy5 in [`647360c`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/647360cba149221db666c446eeb958cf305a0de2)
- Blank line but no trailing whitespace by \@2bndy5 in [`2ebbfa3`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/2ebbfa3daef39ac98bf62c3a58ef6626fa6f1c06)
- Another re-write by \@2bndy5 in [`2faa188`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/2faa188eaf6b95025c861ba28071c571685b12d3)
- Must be a way to reference other func param by \@2bndy5 in [`082e56c`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/082e56cb6a7f4003685f454b3f5ab43f03171ef8)
- Forgot about what_happened() by \@2bndy5 in [`275e5b6`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/275e5b660ecb2a41002007f9690550c47582c2f8)
- Did make it worse? by \@2bndy5 in [`9056d8b`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/9056d8be6690a8977b6163b26601ba139c552e1c)
- 0 byte command args; CnP errors by \@2bndy5 in [`8fbf225`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/8fbf225326eeb6ef24e7f2e6d7fa25c68fd3fc34)
- So many stipulations from pylint by \@2bndy5 in [`0e38f02`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/0e38f0250f6b921d183a14546fa15d211bc93c31)
- What_happened() pass on m4 by \@2bndy5 in [`519c8d1`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/519c8d10d4d6fe30b87f721f1bef29942467bbfc)
- No unexpected errors doing shout outs on M4 by \@2bndy5 in [`93d03bb`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/93d03bb823cb1d377e34c0aa97c406d95917b236)
- Some reduced intro & bug fixes by \@2bndy5 in [`ab798ba`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/ab798ba917abba118142ae8e739ee14b75059f1f)
- Why was I doing that? by \@2bndy5 in [`ac3fc3b`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/ac3fc3bd3e27ef8c86d8f9063255308bb4db4083)
- You don't need to know all that... by \@2bndy5 in [`8d81373`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/8d81373ef1c90e601aa2bea6a545ab9fe2a59838)
- Print everything - going back under the hood by \@2bndy5 in [`bd90f5a`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/bd90f5ac0ae91a3dde5351734d4279d36365df96)
- Works fine on the m4 by \@2bndy5 in [`248408f`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/248408faec70e26ec075fcc0c2545f3ccfa8fc7c)
- Context manager/wrapper would ease the features by \@2bndy5 in [`1fe1708`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/1fe170872e300f812e5e40ba04b6ceae9c045ab3)
- Need to abstract attributes by \@2bndy5 in [`a2c94ac`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/a2c94ac0864fc80e9b8cfceca497a642edd9564e)
- ACK still broken, dyn_pl works by \@2bndy5 in [`1083b04`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/1083b0404640ceb890a4844f6593311b26456443)
- Sphinx hungry; needs references by \@2bndy5 in [`83b8d6f`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/83b8d6f8cf3d58bf110a5cd550bb093c38c0383e)
- Ope_tx calls open_rx if auto_ack == True by \@2bndy5 in [`9619d3b`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/9619d3bfa8b1f80a123e75fbf1788e7243d864cf)
- Testng custom ack by \@2bndy5 in [`6fb0cea`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/6fb0ceafe2699ff3dd5e9f93adea24396afc9b5c)
- Custom ACK is must be on for both RX/TX nodes by \@2bndy5 in [`c670e2b`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/c670e2ba1f9ed5e43ea2f70eb1021f846baf8b1b)
- Better patching by \@2bndy5 in [`26101f6`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/26101f6ac9b03f4ec4134bb61b2dee61f3ab8d23)
- Typo by \@2bndy5 in [`c1b9a64`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/c1b9a64749db7cad20d6f075d4b88cee31778fef)
- Test better custom ack handling by \@2bndy5 in [`8d473c3`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/8d473c3511997f259e0d5b78d1a5c1d611a2a687)
- Send() now directly returns the ACK payload by \@2bndy5 in [`f331432`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/f3314324d04bca9d1bd4b8903bc0448d46527a03)
- I'm starting to like this for v1.0 by \@2bndy5 in [`0eae0a9`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/0eae0a949382fbc01063b5404120923982f67386)
- Custom ack & simple examples pass by \@2bndy5 in [`3e87927`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/3e879278220cea9a5a0d22586f1fc51964604e06)
- Finally branching off by \@2bndy5 in [`b3f8472`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/b3f8472a94abfdb3454383e31ba90099d05e2926)
- Trying pypi by \@2bndy5 in [`ce5b3e4`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/ce5b3e4a37203b200e1c4ab3e580bf633c2fcc67)

[1.0.1-beta]: https://github.com/nRF24/CircuitPython_nRF24L01/compare/1.0.0-rc2...1.0.1-beta

Full commit diff: [`1.0.0-rc2...1.0.1-beta`][1.0.1-beta]

## [1.0.0-rc2] - 2019-07-27

### <!-- 9 --> 🗨️ Changed

- Check simple example and where are my .mpy files? by \@2bndy5 in [`03f37b7`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/03f37b75ecbb9ebd02ba66377aa5d894bc47c357)
- Pylint non-sense in from simple example by \@2bndy5 in [`a47d765`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/a47d765354a3dcd1a85d36ac4ee9923a66169279)

[1.0.0-rc2]: https://github.com/nRF24/CircuitPython_nRF24L01/compare/1.0.0-rc1...1.0.0-rc2

Full commit diff: [`1.0.0-rc1...1.0.0-rc2`][1.0.0-rc2]

## [1.0.0-rc1] - 2019-07-27

### <!-- 3 --> 🗑️ Removed

- Build simple example; removed TODO from README by \@2bndy5 in [`1145568`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/11455689cdaa17d9378e89976d3877821468027b)

### <!-- 4 --> 🛠️ Fixed

- Fixing build parameters of travis CI by \@2bndy5 in [`2e91c7b`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/2e91c7b8da9946798c77e642f68852bd2b3f738e)
- Fix doc string in interrupt_config() by \@2bndy5 in [`a8f73da`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/a8f73dac5edc2148bf6584ff3db81f463725abc7)

### <!-- 8 --> 📝 Documentation

- Tweaking readthe docs build in api.rst by \@2bndy5 in [`f36deff`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/f36deff6e226ee8669d135a2e17fbb64fb1f8a9d)
- Still trying to make docs readable by \@2bndy5 in [`350ab3e`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/350ab3e6eabb004587c3ae17a121582c240d3b97)
- Can't reference a param in a func doc str by \@2bndy5 in [`b7260bd`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/b7260bdb5c3db2fca59dbbfab5d5e138bf7bfe4d)

### <!-- 9 --> 🗨️ Changed

- Init commit by \@2bndy5 in [`6be3e01`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/6be3e01171f94ef47b7c6c83c946de56ecf6ede0)
- Ready for ReadTheDocs by \@2bndy5 in [`35bc181`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/35bc1814ad22cc8f588a56b05054de5eff118562)
- Update to readme.rst by \@2bndy5 in [`9601e52`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/9601e520b6e297f8a6de9ff4981ab356fa26cc79)
- Simplified names and tweaked rST syntax by \@2bndy5 in [`68204b5`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/68204b51dd458445093b39a88f61748f9c567275)
- Trying to get the hang of rST by \@2bndy5 in [`ec00ba9`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/ec00ba9ccd845b8f6270b79ca3a2c57f642b4c77)
- Why is the sphinx failing? by \@2bndy5 in [`56a8cfb`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/56a8cfb5b6a9207a238117fdefdfd145f15a9b10)
- Show me the image! by \@2bndy5 in [`0e8dece`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/0e8dececef99929bc45a431849c4cb2f342a50ae)
- No mr. builder. you're failing me! by \@2bndy5 in [`fbbe8b6`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/fbbe8b6b3d6fff8cc2bb5f1059b4c9bc38a6bf01)
- Bow w/ empty lines for rST by \@2bndy5 in [`168dc14`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/168dc14908e4291807f7f93bb16e5e381a0dd4ba)
- More rSt mistakes by \@2bndy5 in [`125b797`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/125b797e8f7831d24a4137b11526e184181af291)
- Where's my Admonitions in send_fast()? by \@2bndy5 in [`eee7e48`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/eee7e481e52803b573cc6a1f544743de409aaa71)
- Double colons by \@2bndy5 in [`a93b9e1`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/a93b9e1e3c733e4165fcc9644fa181a7aaeba649)
- Scoping rSt  paragraphs is not intuitive by \@2bndy5 in [`1c77d6d`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/1c77d6ddbc7687887fc6802f29a357b6e1279c80)
- Can a note admonition be scoped to a parameter? by \@2bndy5 in [`4e32dbe`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/4e32dbea92879b33043a5414f58acc3aea57c43b)
- Back to testing examples actual programming by \@2bndy5 in [`65707d3`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/65707d3d1718efb194921f268ebf7768236c06dd)
- Gogo gadget travis CI by \@2bndy5 in [`acb3ee4`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/acb3ee49874c9791ae10ccef04aae5efbe0ea7bc)
- Travis CI also checks rST in comments? by \@2bndy5 in [`551c0fa`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/551c0fa00e344337426669ff1eb0caa48a149f2e)
- I am using multiple folders in examples/ by \@2bndy5 in [`38b8062`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/38b80628b12a536315ccb1f54d8d19dc614a09ee)
- Travis CI doesn't like my rST by \@2bndy5 in [`9a9d5db`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/9a9d5db67a71c141f86e7fcc9b5033c15ac21bb6)
- I obviously don't get rST syntax by \@2bndy5 in [`6a18055`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/6a1805546c825e4c70d9e37326fdcb5106da0038)
- That's wasn't readable by \@2bndy5 in [`17b5063`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/17b506383ccff05a60f777678155066ecc9038e7)
- Ok, you feel good spouting all these errors? by \@2bndy5 in [`0966d76`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/0966d76268be76300946d2a000c60b16291a845b)
- What the hell by \@2bndy5 in [`1386920`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/138692025306eaeb9b20329fab7d1ef04bd1e379)
- No more TODOs by \@2bndy5 in [`47acbee`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/47acbee2b8b10a2c170a0d3dc1dc3aa435b5e744)
- Are you happy now? by \@2bndy5 in [`ba51247`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/ba51247bfe702fac932c257d53048a603ee66cd5)
- Forget building examples by \@2bndy5 in [`8478870`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/8478870c5e594ef660e4eb216887b9b3e8e1c2a6)
- Building the only module by \@2bndy5 in [`73ad159`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/73ad159b39630f7b5bfdf281d63eb37f6796dc41)
- Forgot about the __init__.py by \@2bndy5 in [`60b050f`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/60b050f3ba7c3cc87f1038c50e4dae54a3f620f0)
- Disabling pylint checks on rf24.py by \@2bndy5 in [`fe4ec66`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/fe4ec66e8eb36d54e68045f05f7b6db271181d06)
- Disable/fix more pylint nonsense by \@2bndy5 in [`9965eac`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/9965eac4ab28e36c3f26fec653ef3e8752504c47)
- Sphinx reference not found?! by \@2bndy5 in [`f0e56d8`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/f0e56d8dd15b124a15a973b70b6dbfdd0f4e09f3)
- Another sphinx reference typo by \@2bndy5 in [`3348096`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/3348096904635522f7ced063ad771d556948a44c)
- Sphinx typo by \@2bndy5 in [`24ff63a`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/24ff63a104c8d92ee0823d42d47f8c5e89fb82c4)
- Use code sample instead by \@2bndy5 in [`9d6b297`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/9d6b2971cda1351ed2ce0f7e8526bbbb4c5fb50c)
- Some other unreferenc-able code samples by \@2bndy5 in [`3e68622`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/3e686220f03b9bd8f9cd87469a8f922f60cc0202)
- Missed one :(.. this better work by \@2bndy5 in [`80f7988`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/80f798801403a8569e7125dbb97a6172db87b893)
- Ok forgot about the readme.rst by \@2bndy5 in [`daa51a8`](https://github.com/nRF24/CircuitPython_nRF24L01/commit/daa51a87dcfb92f1abdce9637772557d042076d4)

[1.0.0-rc1]: https://github.com/nRF24/CircuitPython_nRF24L01/compare/6be3e01171f94ef47b7c6c83c946de56ecf6ede0...1.0.0-rc1

Full commit diff: [`6be3e01...1.0.0-rc1`][1.0.0-rc1]

## New Contributors

- \@2bndy5 made their first contribution

<!-- generated by git-cliff -->
