# SPDX-FileCopyrightText: 2024 Justin Myers
#
# SPDX-License-Identifier: MIT
"""
Board stub for LILYGO T-QT PRO PSRAM
 - port: espressif
 - board_id: lilygo_tqt_pro_psram
 - NVM size: 8192
 - Included modules: _asyncio, _pixelmap, adafruit_bus_device, adafruit_pixelbuf, aesio, alarm, analogbufio, analogio, array, atexit, audiobusio, audiocore, audiomixer, audiomp3, binascii, bitbangio, bitmaptools, board, builtins, builtins.pow3, busdisplay, busio, busio.SPI, busio.UART, canio, codeop, collections, countio, digitalio, displayio, epaperdisplay, errno, espidf, espnow, espulp, fontio, fourwire, framebufferio, frequencyio, getpass, gifio, hashlib, i2cdisplaybus, io, ipaddress, jpegio, json, keypad, keypad.KeyMatrix, keypad.Keys, keypad.ShiftRegisterKeys, keypad_demux, keypad_demux.DemuxKeyMatrix, locale, lvfontio, math, max3421e, mdns, memorymap, microcontroller, msgpack, neopixel_write, nvm, onewireio, os, os.getenv, ps2io, pulseio, pwmio, rainbowio, random, re, rgbmatrix, rotaryio, rtc, sdcardio, sdioio, select, sharpdisplay, socketpool, socketpool.socketpool.AF_INET6, ssl, storage, struct, supervisor, synthio, sys, terminalio, tilepalettemapper, time, touchio, traceback, ulab, usb, usb_cdc, usb_hid, usb_midi, vectorio, warnings, watchdog, wifi, zlib
 - Frozen libraries: 
"""

# Imports
import busio
import displayio
import microcontroller


# Board Info:
board_id: str


# Pins:
BUTTON0: microcontroller.Pin  # GPIO0
IO0: microcontroller.Pin  # GPIO0
BUTTON1: microcontroller.Pin  # GPIO47
IO47: microcontroller.Pin  # GPIO47
IO34: microcontroller.Pin  # GPIO34
IO33: microcontroller.Pin  # GPIO33
IO39: microcontroller.Pin  # GPIO39
IO38: microcontroller.Pin  # GPIO38
IO37: microcontroller.Pin  # GPIO37
IO36: microcontroller.Pin  # GPIO36
IO35: microcontroller.Pin  # GPIO35
IO16: microcontroller.Pin  # GPIO16
IO17: microcontroller.Pin  # GPIO17
IO18: microcontroller.Pin  # GPIO18
IO48: microcontroller.Pin  # GPIO48
IO43: microcontroller.Pin  # GPIO43
SDA: microcontroller.Pin  # GPIO43
IO44: microcontroller.Pin  # GPIO44
SCL: microcontroller.Pin  # GPIO44
LCD_BCKL: microcontroller.Pin  # GPIO10
LCD_DC: microcontroller.Pin  # GPIO6
LCD_CS: microcontroller.Pin  # GPIO5
LCD_CLK: microcontroller.Pin  # GPIO3
LCD_MOSI: microcontroller.Pin  # GPIO2
LCD_RST: microcontroller.Pin  # GPIO1


# Members:
def I2C() -> busio.I2C:
    """Returns the `busio.I2C` object for the board's designated I2C bus(es).
    The object created is a singleton, and uses the default parameter values for `busio.I2C`.
    """

def STEMMA_I2C() -> busio.I2C:
    """Returns the `busio.I2C` object for the board's designated I2C bus(es).
    The object created is a singleton, and uses the default parameter values for `busio.I2C`.
    """

"""Returns the `displayio.Display` object for the board's built in display.
The object created is a singleton, and uses the default parameter values for `displayio.Display`.
"""
DISPLAY: displayio.Display

def LCD_SPI() -> busio.SPI:
    """Returns the `busio.SPI` object for the board's designated SPI bus(es).
    The object created is a singleton, and uses the default parameter values for `busio.SPI`.
    """


# Unmapped:
#   none
